/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.pgm.CLIText;
import org.eclipse.jgit.pgm.Die;
import org.eclipse.jgit.pgm.opt.CmdLineParser;
import org.eclipse.jgit.revwalk.RevWalk;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;

public abstract class TextBuiltin {
    private String commandName;
    @Option(name="--help", usage="usage_displayThisHelpText", aliases={"-h"})
    private boolean help;
    protected PrintWriter out;
    protected Repository db;
    protected String gitdir;
    protected RevWalk argWalk;

    final void setCommandName(String name) {
        this.commandName = name;
    }

    protected boolean requiresRepository() {
        return true;
    }

    protected void init(Repository repository, String gitDir) {
        try {
            String outputEncoding;
            String string = outputEncoding = repository != null ? repository.getConfig().getString("i18n", null, "logOutputEncoding") : null;
            this.out = outputEncoding != null ? new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, outputEncoding))) : new PrintWriter(new BufferedWriter(new OutputStreamWriter(System.out)));
        }
        catch (IOException e) {
            throw TextBuiltin.die(CLIText.get().cannotCreateOutputStream);
        }
        if (repository != null && repository.getDirectory() != null) {
            this.db = repository;
            this.gitdir = repository.getDirectory().getAbsolutePath();
        } else {
            this.db = repository;
            this.gitdir = gitDir;
        }
    }

    public final void execute(String[] args) throws Exception {
        this.parseArguments(args);
        this.run();
    }

    protected void parseArguments(String[] args) {
        CmdLineParser clp;
        block3: {
            clp = new CmdLineParser(this);
            try {
                clp.parseArgument(args);
            }
            catch (CmdLineException err) {
                if (this.help) break block3;
                System.err.println(MessageFormat.format(CLIText.get().fatalError, err.getMessage()));
                System.exit(1);
            }
        }
        if (this.help) {
            this.printUsageAndExit(clp);
        }
        this.argWalk = clp.getRevWalkGently();
    }

    public void printUsageAndExit(CmdLineParser clp) {
        this.printUsageAndExit("", clp);
    }

    public void printUsageAndExit(String message, CmdLineParser clp) {
        PrintWriter writer = new PrintWriter(System.err);
        writer.println(message);
        writer.print("jgit ");
        writer.print(this.commandName);
        clp.printSingleLineUsage(writer, this.getResourceBundle());
        writer.println();
        writer.println();
        clp.printUsage(writer, this.getResourceBundle());
        writer.println();
        writer.flush();
        System.exit(1);
    }

    protected ResourceBundle getResourceBundle() {
        return CLIText.get().resourceBundle();
    }

    protected abstract void run() throws Exception;

    public Repository getRepository() {
        return this.db;
    }

    ObjectId resolve(String s) throws IOException {
        ObjectId r = this.db.resolve(s);
        if (r == null) {
            throw TextBuiltin.die(MessageFormat.format(CLIText.get().notARevision, s));
        }
        return r;
    }

    protected static Die die(String why) {
        return new Die(why);
    }

    protected static Die die(String why, Throwable cause) {
        return new Die(why, cause);
    }

    String abbreviateRef(String dst, boolean abbreviateRemote) {
        if (dst.startsWith("refs/heads/")) {
            dst = dst.substring("refs/heads/".length());
        } else if (dst.startsWith("refs/tags/")) {
            dst = dst.substring("refs/tags/".length());
        } else if (abbreviateRemote && dst.startsWith("refs/remotes/")) {
            dst = dst.substring("refs/remotes/".length());
        }
        return dst;
    }
}

