/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.eclipse;

import java.io.File;
import java.io.OutputStream;
import java.net.CookieHandler;
import java.text.MessageFormat;
import org.eclipse.jgit.iplog.IpLogGenerator;
import org.eclipse.jgit.iplog.SimpleCookieManager;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.pgm.CLIText;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.LockFile;
import org.eclipse.jgit.util.FileUtils;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(name="eclipse-iplog", common=false, usage="usage_produceAnEclipseIPLog")
class Iplog
extends TextBuiltin {
    @Option(name="--version", aliases={"-r"}, metaVar="metaVar_version", usage="usage_symbolicVersionForTheProject")
    private String version;
    @Option(name="--output", aliases={"-o"}, metaVar="metaVar_file", usage="usage_outputFile")
    private File output;
    @Argument(index=0, metaVar="metaVar_commitOrTag")
    private ObjectId commitId;

    Iplog() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run() throws Exception {
        block15: {
            if (CookieHandler.getDefault() == null) {
                CookieHandler.setDefault((CookieHandler)new SimpleCookieManager());
            }
            IpLogGenerator log = new IpLogGenerator();
            if (this.commitId == null) {
                System.err.println(MessageFormat.format(CLIText.get().warningNoCommitGivenOnCommandLine, "HEAD"));
                this.commitId = this.db.resolve("HEAD");
            }
            RevWalk rw = new RevWalk(this.db);
            RevObject start = rw.parseAny((AnyObjectId)this.commitId);
            if (this.version == null && start instanceof RevTag) {
                this.version = ((RevTag)start).getTagName();
            } else if (this.version == null) {
                throw Iplog.die(MessageFormat.format(CLIText.get().notATagVersionIsRequired, start.name()));
            }
            log.scan(this.db, rw.parseCommit((AnyObjectId)start), this.version);
            if (this.output != null) {
                FileUtils.mkdirs((File)this.output.getParentFile(), (boolean)true);
                LockFile lf = new LockFile(this.output, this.db.getFS());
                if (!lf.lock()) {
                    throw Iplog.die(MessageFormat.format(CLIText.get().cannotLock, this.output));
                }
                try {
                    OutputStream os = lf.getOutputStream();
                    try {
                        log.writeTo(os);
                    }
                    finally {
                        os.close();
                    }
                    if (!lf.commit()) {
                        throw Iplog.die(MessageFormat.format(CLIText.get().cannotWrite, this.output));
                    }
                    break block15;
                }
                finally {
                    lf.unlock();
                }
            }
            log.writeTo((OutputStream)System.out);
            System.out.flush();
        }
    }
}

