/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.eclipse;

import java.io.File;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.PasswordAuthentication;
import java.net.URL;
import org.eclipse.jgit.iplog.IpLogMeta;
import org.eclipse.jgit.iplog.SimpleCookieManager;
import org.eclipse.jgit.pgm.CLIText;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.kohsuke.args4j.Option;

@Command(name="eclipse-ipzilla", common=false, usage="usage_synchronizeIPZillaData")
class Ipzilla
extends TextBuiltin {
    @Option(name="--url", metaVar="metaVar_url", usage="usage_IPZillaURL")
    private String url = "https://dev.eclipse.org/ipzilla/";
    @Option(name="--username", metaVar="metaVar_user", usage="usage_IPZillaUsername")
    private String username;
    @Option(name="--password", metaVar="metaVar_pass", usage="usage_IPZillaPassword")
    private String password;
    @Option(name="--file", aliases={"-f"}, metaVar="metaVar_file", usage="usage_inputOutputFile")
    private File output;

    Ipzilla() {
    }

    protected void run() throws Exception {
        if (CookieHandler.getDefault() == null) {
            CookieHandler.setDefault((CookieHandler)new SimpleCookieManager());
        }
        URL ipzilla = new URL(this.url);
        if (this.username == null) {
            PasswordAuthentication auth = Authenticator.requestPasswordAuthentication(ipzilla.getHost(), null, ipzilla.getPort(), ipzilla.getProtocol(), CLIText.get().IPZillaPasswordPrompt, ipzilla.getProtocol(), ipzilla, Authenticator.RequestorType.SERVER);
            this.username = auth.getUserName();
            this.password = new String(auth.getPassword());
        }
        if (this.output == null) {
            this.output = new File(this.db.getWorkTree(), ".eclipse_iplog");
        }
        IpLogMeta meta = new IpLogMeta();
        meta.syncCQs(this.output, this.db.getFS(), ipzilla, this.username, this.password);
    }
}

