/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubmoduleUpdateCommand
extends TransportCommand<SubmoduleUpdateCommand, Collection<String>> {
    private ProgressMonitor monitor;
    private final Collection<String> paths = new ArrayList<String>();

    public SubmoduleUpdateCommand(Repository repo) {
        super(repo);
    }

    public SubmoduleUpdateCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public SubmoduleUpdateCommand addPath(String path) {
        this.paths.add(path);
        return this;
    }

    @Override
    public Collection<String> call() throws JGitInternalException {
        this.checkCallable();
        try {
            SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);
            if (!this.paths.isEmpty()) {
                generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            ArrayList<String> updated = new ArrayList<String>();
            while (generator.next()) {
                String url;
                if (generator.getModulesPath() == null || (url = generator.getConfigUrl()) == null) continue;
                Repository submoduleRepo = generator.getRepository();
                if (submoduleRepo == null) {
                    CloneCommand clone = Git.cloneRepository();
                    this.configure(clone);
                    clone.setURI(url);
                    clone.setDirectory(generator.getDirectory());
                    if (this.monitor != null) {
                        clone.setProgressMonitor(this.monitor);
                    }
                    submoduleRepo = clone.call().getRepository();
                }
                RevWalk walk = new RevWalk(submoduleRepo);
                RevCommit commit = walk.parseCommit(generator.getObjectId());
                String update = generator.getConfigUpdate();
                if ("merge".equals(update)) {
                    MergeCommand merge = new MergeCommand(submoduleRepo);
                    merge.include(commit);
                    merge.call();
                } else if ("rebase".equals(update)) {
                    RebaseCommand rebase = new RebaseCommand(submoduleRepo);
                    rebase.setUpstream(commit);
                    rebase.call();
                } else {
                    DirCacheCheckout co = new DirCacheCheckout(submoduleRepo, submoduleRepo.lockDirCache(), commit.getTree());
                    co.setFailOnConflict(true);
                    co.checkout();
                    RefUpdate refUpdate = submoduleRepo.updateRef("HEAD", true);
                    refUpdate.setNewObjectId(commit);
                    refUpdate.forceUpdate();
                }
                updated.add(generator.getPath());
            }
            return updated;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (ConfigInvalidException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (GitAPIException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }
}

