/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.text.MessageFormat;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.util.TemporaryBuffer;

public class IO {
    public static final byte[] readFully(File path) throws FileNotFoundException, IOException {
        return IO.readFully(path, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] readSome(File path, int limit) throws FileNotFoundException, IOException {
        int cnt;
        byte[] buf;
        FileInputStream in;
        block8: {
            byte[] n22;
            in = new FileInputStream(path);
            try {
                int n22;
                buf = new byte[limit];
                cnt = 0;
                while ((n22 = in.read(buf, cnt, buf.length - cnt)) > 0) {
                    cnt += n22;
                }
                if (cnt != buf.length) break block8;
                n22 = buf;
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    in.close();
                }
                catch (IOException ignored) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            return n22;
        }
        byte[] res = new byte[cnt];
        System.arraycopy(buf, 0, res, 0, cnt);
        byte[] byArray = res;
        Object var8_9 = null;
        try {
            in.close();
        }
        catch (IOException ignored) {
            // empty catch block
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] readFully(File path, int max) throws FileNotFoundException, IOException {
        byte[] buf;
        FileInputStream in;
        block8: {
            byte[] byArray;
            in = new FileInputStream(path);
            try {
                long sz = in.getChannel().size();
                if (sz > (long)max) {
                    throw new IOException(MessageFormat.format(JGitText.get().fileIsTooLarge, path));
                }
                buf = new byte[(int)sz];
                int actSz = IO.readFully(in, buf, 0);
                if ((long)actSz != sz) break block8;
                byte[] ret = new byte[actSz];
                System.arraycopy(buf, 0, ret, 0, actSz);
                byArray = ret;
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                try {
                    in.close();
                }
                catch (IOException ignored) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            return byArray;
        }
        byte[] byArray = buf;
        Object var10_10 = null;
        try {
            in.close();
        }
        catch (IOException ignored) {
            // empty catch block
        }
        return byArray;
    }

    public static ByteBuffer readWholeStream(InputStream in, int sizeHint) throws IOException {
        int pos;
        int read;
        byte[] out = new byte[sizeHint];
        for (pos = 0; pos < out.length; pos += read) {
            read = in.read(out, pos, out.length - pos);
            if (read >= 0) continue;
            return ByteBuffer.wrap(out, 0, pos);
        }
        int last = in.read();
        if (last < 0) {
            return ByteBuffer.wrap(out, 0, pos);
        }
        TemporaryBuffer.Heap tmp = new TemporaryBuffer.Heap(Integer.MAX_VALUE);
        tmp.write(out);
        tmp.write(last);
        tmp.copy(in);
        return ByteBuffer.wrap(tmp.toByteArray());
    }

    public static void readFully(InputStream fd, byte[] dst, int off, int len) throws IOException {
        while (len > 0) {
            int r = fd.read(dst, off, len);
            if (r <= 0) {
                throw new EOFException(JGitText.get().shortReadOfBlock);
            }
            off += r;
            len -= r;
        }
    }

    public static int read(ReadableByteChannel channel, byte[] dst, int off, int len) throws IOException {
        int r;
        if (len == 0) {
            return 0;
        }
        int cnt = 0;
        while (0 < len && (r = channel.read(ByteBuffer.wrap(dst, off, len))) > 0) {
            off += r;
            len -= r;
            cnt += r;
        }
        return cnt != 0 ? cnt : -1;
    }

    public static int readFully(InputStream fd, byte[] dst, int off) throws IOException {
        int len;
        int r;
        for (len = 0; (r = fd.read(dst, off, dst.length - off)) >= 0 && len < dst.length; len += r) {
            off += r;
        }
        return len;
    }

    public static void skipFully(InputStream fd, long toSkip) throws IOException {
        while (toSkip > 0L) {
            long r = fd.skip(toSkip);
            if (r <= 0L) {
                throw new EOFException(JGitText.get().shortSkipOfBlock);
            }
            toSkip -= r;
        }
    }

    private IO() {
    }
}

