/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubmoduleInitCommand
extends GitCommand<Collection<String>> {
    private final Collection<String> paths = new ArrayList<String>();

    public SubmoduleInitCommand(Repository repo) {
        super(repo);
    }

    public SubmoduleInitCommand addPath(String path) {
        this.paths.add(path);
        return this;
    }

    @Override
    public Collection<String> call() throws JGitInternalException {
        this.checkCallable();
        try {
            SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);
            if (!this.paths.isEmpty()) {
                generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            StoredConfig config = this.repo.getConfig();
            ArrayList<String> initialized = new ArrayList<String>();
            while (generator.next()) {
                if (generator.getConfigUrl() != null) continue;
                String path = generator.getPath();
                String url = generator.getModulesUrl();
                String update = generator.getModulesUpdate();
                if (url != null) {
                    config.setString("submodule", path, "url", url);
                }
                if (update != null) {
                    config.setString("submodule", path, "update", update);
                }
                if (url == null && update == null) continue;
                initialized.add(path);
            }
            if (!initialized.isEmpty()) {
                config.save();
            }
            return initialized;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (ConfigInvalidException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }
}

