/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.dircache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.CheckoutConflictException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.IndexWriteException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.NameConflictTreeWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirCacheCheckout {
    private Repository repo;
    private HashMap<String, ObjectId> updated = new HashMap();
    private ArrayList<String> conflicts = new ArrayList();
    private ArrayList<String> removed = new ArrayList();
    private ObjectId mergeCommitTree;
    private DirCache dc;
    private DirCacheBuilder builder;
    private NameConflictTreeWalk walk;
    private ObjectId headCommitTree;
    private WorkingTreeIterator workingTree;
    private boolean failOnConflict = true;
    private ArrayList<String> toBeDeleted = new ArrayList();

    public Map<String, ObjectId> getUpdated() {
        return this.updated;
    }

    public List<String> getConflicts() {
        return this.conflicts;
    }

    public List<String> getToBeDeleted() {
        return this.toBeDeleted;
    }

    public List<String> getRemoved() {
        return this.removed;
    }

    public DirCacheCheckout(Repository repo, ObjectId headCommitTree, DirCache dc, ObjectId mergeCommitTree, WorkingTreeIterator workingTree) throws IOException {
        this.repo = repo;
        this.dc = dc;
        this.headCommitTree = headCommitTree;
        this.mergeCommitTree = mergeCommitTree;
        this.workingTree = workingTree;
    }

    public DirCacheCheckout(Repository repo, ObjectId headCommitTree, DirCache dc, ObjectId mergeCommitTree) throws IOException {
        this(repo, headCommitTree, dc, mergeCommitTree, new FileTreeIterator(repo));
    }

    public DirCacheCheckout(Repository repo, DirCache dc, ObjectId mergeCommitTree, WorkingTreeIterator workingTree) throws IOException {
        this(repo, null, dc, mergeCommitTree, workingTree);
    }

    public DirCacheCheckout(Repository repo, DirCache dc, ObjectId mergeCommitTree) throws IOException {
        this(repo, null, dc, mergeCommitTree, new FileTreeIterator(repo));
    }

    public void preScanTwoTrees() throws CorruptObjectException, IOException {
        this.removed.clear();
        this.updated.clear();
        this.conflicts.clear();
        this.walk = new NameConflictTreeWalk(this.repo);
        this.builder = this.dc.builder();
        this.addTree(this.walk, this.headCommitTree);
        this.addTree(this.walk, this.mergeCommitTree);
        this.walk.addTree(new DirCacheBuildIterator(this.builder));
        this.walk.addTree(this.workingTree);
        while (this.walk.next()) {
            this.processEntry(this.walk.getTree(0, CanonicalTreeParser.class), this.walk.getTree(1, CanonicalTreeParser.class), this.walk.getTree(2, DirCacheBuildIterator.class), this.walk.getTree(3, WorkingTreeIterator.class));
            if (!this.walk.isSubtree()) continue;
            this.walk.enterSubtree();
        }
    }

    private void addTree(TreeWalk tw, ObjectId id) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (id == null) {
            tw.addTree(new EmptyTreeIterator());
        } else {
            tw.addTree(id);
        }
    }

    public void prescanOneTree() throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        this.removed.clear();
        this.updated.clear();
        this.conflicts.clear();
        this.builder = this.dc.builder();
        this.walk = new NameConflictTreeWalk(this.repo);
        this.walk.addTree(this.mergeCommitTree);
        this.walk.addTree(new DirCacheBuildIterator(this.builder));
        this.walk.addTree(this.workingTree);
        while (this.walk.next()) {
            this.processEntry(this.walk.getTree(0, CanonicalTreeParser.class), this.walk.getTree(1, DirCacheBuildIterator.class), this.walk.getTree(2, WorkingTreeIterator.class));
            if (!this.walk.isSubtree()) continue;
            this.walk.enterSubtree();
        }
        this.conflicts.removeAll(this.removed);
    }

    void processEntry(CanonicalTreeParser m, DirCacheBuildIterator i, WorkingTreeIterator f) throws IOException {
        if (m != null) {
            if (i == null) {
                if (f != null && !FileMode.TREE.equals(f.getEntryFileMode()) && !f.isEntryIgnored()) {
                    this.conflicts.add(this.walk.getPathString());
                } else {
                    this.update(m.getEntryPathString(), m.getEntryObjectId(), m.getEntryFileMode());
                }
            } else if (f == null || !m.idEqual(i)) {
                this.update(m.getEntryPathString(), m.getEntryObjectId(), m.getEntryFileMode());
            } else if (i.getDirCacheEntry() != null) {
                if (f.isModified(i.getDirCacheEntry(), true) || i.getDirCacheEntry().getStage() != 0) {
                    this.update(m.getEntryPathString(), m.getEntryObjectId(), m.getEntryFileMode());
                } else {
                    this.keep(i.getDirCacheEntry());
                }
            } else {
                this.keep(i.getDirCacheEntry());
            }
        } else if (f != null) {
            if (this.walk.isDirectoryFileConflict()) {
                this.conflicts.add(this.walk.getPathString());
            } else if (i != null) {
                this.remove(i.getEntryPathString());
                this.conflicts.remove(i.getEntryPathString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkout() throws IOException {
        try {
            boolean bl = this.doCheckout();
            return bl;
        }
        finally {
            this.dc.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCheckout() throws CorruptObjectException, IOException, MissingObjectException, IncorrectObjectTypeException, CheckoutConflictException, IndexWriteException {
        this.toBeDeleted.clear();
        ObjectReader objectReader = this.repo.getObjectDatabase().newReader();
        try {
            if (this.headCommitTree != null) {
                this.preScanTwoTrees();
            } else {
                this.prescanOneTree();
            }
            if (!this.conflicts.isEmpty()) {
                if (this.failOnConflict) {
                    throw new CheckoutConflictException(this.conflicts.toArray(new String[this.conflicts.size()]));
                }
                this.cleanUpConflicts();
            }
            this.builder.finish();
            File file = null;
            String last = "";
            for (int i = this.removed.size() - 1; i >= 0; --i) {
                String r = this.removed.get(i);
                file = new File(this.repo.getWorkTree(), r);
                if (!file.delete() && file.exists()) {
                    if (file.isDirectory()) continue;
                    this.toBeDeleted.add(r);
                    continue;
                }
                if (!DirCacheCheckout.isSamePrefix(r, last)) {
                    this.removeEmptyParents(new File(this.repo.getWorkTree(), last));
                }
                last = r;
            }
            if (file != null) {
                this.removeEmptyParents(file);
            }
            for (String path : this.updated.keySet()) {
                DirCacheEntry entry;
                file = new File(this.repo.getWorkTree(), path);
                if (!file.getParentFile().mkdirs()) {
                    // empty if block
                }
                if (FileMode.GITLINK.equals((entry = this.dc.getEntry(path)).getRawMode())) continue;
                DirCacheCheckout.checkoutEntry(this.repo, file, entry, objectReader);
            }
            if (!this.builder.commit()) {
                throw new IndexWriteException();
            }
        }
        finally {
            objectReader.release();
        }
        return this.toBeDeleted.size() == 0;
    }

    private static boolean isSamePrefix(String a, String b) {
        int as = a.lastIndexOf(47);
        int bs = b.lastIndexOf(47);
        return a.substring(0, as + 1).equals(b.substring(0, bs + 1));
    }

    private void removeEmptyParents(File f) {
        File parentFile = f.getParentFile();
        while (!parentFile.equals(this.repo.getWorkTree()) && parentFile.delete()) {
            parentFile = parentFile.getParentFile();
        }
    }

    void processEntry(AbstractTreeIterator h, AbstractTreeIterator m, DirCacheBuildIterator i, WorkingTreeIterator f) throws IOException {
        String name = this.walk.getPathString();
        if (i == null && m == null && h == null) {
            if (this.walk.isDirectoryFileConflict()) {
                this.conflict(name, null, null, null);
            }
            return;
        }
        ObjectId iId = i == null ? null : i.getEntryObjectId();
        ObjectId mId = m == null ? null : m.getEntryObjectId();
        ObjectId hId = h == null ? null : h.getEntryObjectId();
        int ffMask = 0;
        if (h != null) {
            int n = ffMask = FileMode.TREE.equals(h.getEntryFileMode()) ? 3328 : 3840;
        }
        if (i != null) {
            ffMask |= FileMode.TREE.equals(i.getEntryFileMode()) ? 208 : 240;
        }
        if (m != null) {
            ffMask |= FileMode.TREE.equals(m.getEntryFileMode()) ? 13 : 15;
        }
        if ((ffMask & 0x222) != 0 && ((ffMask & 0xF) == 13 || (ffMask & 0xF0) == 208 || (ffMask & 0xF00) == 3328)) {
            switch (ffMask) {
                case 3551: {
                    if (this.isModified(name)) {
                        this.conflict(name, i.getDirCacheEntry(), h, m);
                        break;
                    }
                    this.update(name, m.getEntryObjectId(), m.getEntryFileMode());
                    break;
                }
                case 3581: {
                    this.remove(name);
                    break;
                }
                case 3853: {
                    this.remove(name);
                    break;
                }
                case 3583: 
                case 4061: {
                    break;
                }
                case 3343: {
                    this.update(name, mId, m.getEntryFileMode());
                    break;
                }
                case 253: 
                case 3568: {
                    this.conflict(name, i != null ? i.getDirCacheEntry() : null, h, m);
                    break;
                }
                case 4063: {
                    if (hId.equals(mId)) {
                        if (this.isModified(name)) {
                            this.conflict(name, i.getDirCacheEntry(), h, m);
                            break;
                        }
                        this.update(name, mId, m.getEntryFileMode());
                        break;
                    }
                    if (!this.isModified(name)) {
                        this.update(name, mId, m.getEntryFileMode());
                        break;
                    }
                    this.conflict(name, i.getDirCacheEntry(), h, m);
                    break;
                }
                case 4048: {
                    this.keep(i.getDirCacheEntry());
                    break;
                }
                case 4093: {
                    if (hId.equals(iId)) {
                        DirCacheEntry dce = i.getDirCacheEntry();
                        if (f == null || f.isModified(dce, true)) {
                            this.conflict(name, dce, h, m);
                            break;
                        }
                        this.remove(name);
                        break;
                    }
                    this.conflict(name, i.getDirCacheEntry(), h, m);
                    break;
                }
                case 223: {
                    if (!this.isModified(name)) {
                        this.update(name, mId, m.getEntryFileMode());
                        break;
                    }
                    this.conflict(name, i.getDirCacheEntry(), h, m);
                    break;
                }
                default: {
                    this.keep(i.getDirCacheEntry());
                }
            }
            return;
        }
        if ((ffMask & 0x222) == 0) {
            return;
        }
        if (ffMask == 15 && f != null && FileMode.TREE.equals(f.getEntryFileMode())) {
            this.conflict(name, null, h, m);
        }
        if (i == null) {
            if (!(f == null || FileMode.GITLINK.equals(m.getEntryFileMode()) || mId != null && mId.equals(f.getEntryObjectId()))) {
                this.conflict(name, null, h, m);
                return;
            }
            if (h == null) {
                this.update(name, mId, m.getEntryFileMode());
            } else if (m == null) {
                this.remove(name);
            } else {
                this.update(name, mId, m.getEntryFileMode());
            }
        } else {
            DirCacheEntry dce = i.getDirCacheEntry();
            if (h == null) {
                if (m == null || mId.equals(iId)) {
                    if (m == null && this.walk.isDirectoryFileConflict()) {
                        if (dce != null && (f == null || f.isModified(dce, true))) {
                            this.conflict(name, dce, h, m);
                        } else {
                            this.remove(name);
                        }
                    } else {
                        this.keep(dce);
                    }
                } else {
                    this.conflict(name, dce, h, m);
                }
            } else if (m == null) {
                if (dce.getFileMode() == FileMode.GITLINK) {
                    this.remove(name);
                } else if (hId.equals(iId)) {
                    if (f == null || f.isModified(dce, true)) {
                        this.conflict(name, dce, h, m);
                    } else {
                        this.remove(name);
                    }
                } else {
                    this.conflict(name, dce, h, m);
                }
            } else if (!(hId.equals(mId) || hId.equals(iId) || mId.equals(iId))) {
                this.conflict(name, dce, h, m);
            } else if (hId.equals(iId) && !mId.equals(iId)) {
                if (dce != null && FileMode.GITLINK.equals(dce.getFileMode())) {
                    this.update(name, mId, m.getEntryFileMode());
                } else if (dce != null && (f == null || f.isModified(dce, true))) {
                    this.conflict(name, dce, h, m);
                } else {
                    this.update(name, mId, m.getEntryFileMode());
                }
            } else {
                this.keep(dce);
            }
        }
    }

    private void conflict(String path, DirCacheEntry e, AbstractTreeIterator h, AbstractTreeIterator m) {
        DirCacheEntry entry;
        this.conflicts.add(path);
        if (e != null) {
            entry = new DirCacheEntry(e.getPathString(), 1);
            entry.copyMetaData(e);
            this.builder.add(entry);
        }
        if (h != null && !FileMode.TREE.equals(h.getEntryFileMode())) {
            entry = new DirCacheEntry(h.getEntryPathString(), 2);
            entry.setFileMode(h.getEntryFileMode());
            entry.setObjectId(h.getEntryObjectId());
            this.builder.add(entry);
        }
        if (m != null && !FileMode.TREE.equals(m.getEntryFileMode())) {
            entry = new DirCacheEntry(m.getEntryPathString(), 3);
            entry.setFileMode(m.getEntryFileMode());
            entry.setObjectId(m.getEntryObjectId());
            this.builder.add(entry);
        }
    }

    private void keep(DirCacheEntry e) {
        if (e != null && !FileMode.TREE.equals(e.getFileMode())) {
            this.builder.add(e);
        }
    }

    private void remove(String path) {
        this.removed.add(path);
    }

    private void update(String path, ObjectId mId, FileMode mode) {
        if (!FileMode.TREE.equals(mode)) {
            this.updated.put(path, mId);
            DirCacheEntry entry = new DirCacheEntry(path, 0);
            entry.setObjectId(mId);
            entry.setFileMode(mode);
            this.builder.add(entry);
        }
    }

    public void setFailOnConflict(boolean failOnConflict) {
        this.failOnConflict = failOnConflict;
    }

    private void cleanUpConflicts() throws CheckoutConflictException {
        for (String c : this.conflicts) {
            File conflict = new File(this.repo.getWorkTree(), c);
            if (!conflict.delete()) {
                throw new CheckoutConflictException(MessageFormat.format(JGitText.get().cannotDeleteFile, c));
            }
            this.removeEmptyParents(conflict);
        }
        for (String r : this.removed) {
            File file = new File(this.repo.getWorkTree(), r);
            if (!file.delete()) {
                throw new CheckoutConflictException(MessageFormat.format(JGitText.get().cannotDeleteFile, file.getAbsolutePath()));
            }
            this.removeEmptyParents(file);
        }
    }

    private boolean isModified(String path) throws CorruptObjectException, IOException {
        NameConflictTreeWalk tw = new NameConflictTreeWalk(this.repo);
        tw.addTree(new DirCacheIterator(this.dc));
        tw.addTree(new FileTreeIterator(this.repo));
        tw.setRecursive(true);
        tw.setFilter(PathFilter.create(path));
        while (tw.next()) {
            DirCacheIterator dcIt = tw.getTree(0, DirCacheIterator.class);
            WorkingTreeIterator wtIt = tw.getTree(1, WorkingTreeIterator.class);
            if (dcIt == null || wtIt == null) {
                return true;
            }
            if (!wtIt.isModified(dcIt.getDirCacheEntry(), true)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkoutEntry(Repository repository, File f, DirCacheEntry entry) throws IOException {
        ObjectReader or = repository.newObjectReader();
        try {
            DirCacheCheckout.checkoutEntry(repository, f, entry, repository.newObjectReader());
        }
        finally {
            or.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkoutEntry(Repository repo, File f, DirCacheEntry entry, ObjectReader or) throws IOException {
        ObjectLoader ol = or.open(entry.getObjectId());
        File parentDir = f.getParentFile();
        File tmpFile = File.createTempFile("._" + f.getName(), null, parentDir);
        FileOutputStream channel = new FileOutputStream(tmpFile);
        try {
            ol.copyTo(channel);
        }
        finally {
            channel.close();
        }
        FS fs = repo.getFS();
        WorkingTreeOptions opt = repo.getConfig().get(WorkingTreeOptions.KEY);
        if (opt.isFileMode() && fs.supportsExecute()) {
            if (FileMode.EXECUTABLE_FILE.equals(entry.getRawMode())) {
                if (!fs.canExecute(tmpFile)) {
                    fs.setExecute(tmpFile, true);
                }
            } else if (fs.canExecute(tmpFile)) {
                fs.setExecute(tmpFile, false);
            }
        }
        if (!tmpFile.renameTo(f)) {
            FileUtils.delete(f);
            if (!tmpFile.renameTo(f)) {
                throw new IOException(MessageFormat.format(JGitText.get().couldNotWriteFile, tmpFile.getPath(), f.getPath()));
            }
        }
        entry.setLastModified(f.lastModified());
        entry.setLength((int)ol.getSize());
    }
}

