/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.gitrepo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.lib.Repository;

public class RepoProject
implements Comparable<RepoProject> {
    final String name;
    final String path;
    final String revision;
    final String remote;
    final Set<String> groups;
    final List<CopyFile> copyfiles;
    String url;
    String defaultRevision;

    public RepoProject(String name, String path, String revision, String remote, String groups) {
        this.name = name;
        this.path = path != null ? path : name;
        this.revision = revision;
        this.remote = remote;
        this.groups = new HashSet<String>();
        if (groups != null && groups.length() > 0) {
            this.groups.addAll(Arrays.asList(groups.split(",")));
        }
        this.copyfiles = new ArrayList<CopyFile>();
    }

    public RepoProject setUrl(String url) {
        this.url = url;
        return this;
    }

    public RepoProject setDefaultRevision(String defaultRevision) {
        this.defaultRevision = defaultRevision;
        return this;
    }

    public String getRevision() {
        return this.revision == null ? this.defaultRevision : this.revision;
    }

    public void addCopyFile(CopyFile copyfile) {
        this.copyfiles.add(copyfile);
    }

    String getPathWithSlash() {
        if (this.path.endsWith("/")) {
            return this.path;
        }
        return this.path + "/";
    }

    public boolean isAncestorOf(RepoProject that) {
        return that.getPathWithSlash().startsWith(this.getPathWithSlash());
    }

    public boolean equals(Object o) {
        if (o instanceof RepoProject) {
            RepoProject that = (RepoProject)o;
            return this.getPathWithSlash().equals(that.getPathWithSlash());
        }
        return false;
    }

    public int hashCode() {
        return this.getPathWithSlash().hashCode();
    }

    @Override
    public int compareTo(RepoProject that) {
        return this.getPathWithSlash().compareTo(that.getPathWithSlash());
    }

    public static class CopyFile {
        final Repository repo;
        final String path;
        final String src;
        final String dest;

        public CopyFile(Repository repo, String path, String src, String dest) {
            this.repo = repo;
            this.path = path;
            this.src = src;
            this.dest = dest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void copy() throws IOException {
            File srcFile = new File(this.repo.getWorkTree(), this.path + "/" + this.src);
            File destFile = new File(this.repo.getWorkTree(), this.dest);
            try (FileInputStream input = new FileInputStream(srcFile);
                 FileOutputStream output = new FileOutputStream(destFile);){
                FileChannel channel = input.getChannel();
                output.getChannel().transferFrom(channel, 0L, channel.size());
            }
        }
    }
}

