/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.ignore.internal.IMatcher;
import org.eclipse.jgit.ignore.internal.PathMatcher;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevWalk;

public class DescribeCommand
extends GitCommand<String> {
    private final RevWalk w;
    private RevCommit target;
    private int maxCandidates = 10;
    private boolean longDesc;
    private List<IMatcher> matchers = new ArrayList<IMatcher>();

    protected DescribeCommand(Repository repo) {
        super(repo);
        this.w = new RevWalk(repo);
        this.w.setRetainBody(false);
    }

    public DescribeCommand setTarget(ObjectId target) throws IOException {
        this.target = this.w.parseCommit(target);
        return this;
    }

    public DescribeCommand setTarget(String rev) throws IOException, RefNotFoundException {
        ObjectId id = this.repo.resolve(rev);
        if (id == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, rev));
        }
        return this.setTarget(id);
    }

    public DescribeCommand setLong(boolean longDesc) {
        this.longDesc = longDesc;
        return this;
    }

    private String longDescription(Ref tag, int depth, ObjectId tip) throws IOException {
        return String.format("%s-%d-g%s", tag.getName().substring("refs/tags/".length()), depth, this.w.getObjectReader().abbreviate(tip).name());
    }

    public DescribeCommand setMatch(String ... patterns) throws InvalidPatternException {
        String[] stringArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            this.matchers.add(PathMatcher.createPathMatcher(p, null, false));
            ++n2;
        }
        return this;
    }

    private Optional<Ref> getBestMatch(List<Ref> tags) {
        if (tags == null || tags.size() == 0) {
            return Optional.empty();
        }
        if (this.matchers.size() == 0) {
            return Optional.of(tags.get(0));
        }
        for (IMatcher matcher : this.matchers) {
            Optional<Ref> match = tags.stream().filter(tag -> matcher.matches(tag.getName(), false, false)).findFirst();
            if (!match.isPresent()) continue;
            return match;
        }
        return Optional.empty();
    }

    private ObjectId getObjectIdFromRef(Ref r) {
        ObjectId key = this.repo.peel(r).getPeeledObjectId();
        if (key == null) {
            key = r.getObjectId();
        }
        return key;
    }

    @Override
    public String call() throws GitAPIException {
        try {
            RevCommit c;
            this.checkCallable();
            if (this.target == null) {
                this.setTarget("HEAD");
            }
            List<Ref> tagList = this.repo.getRefDatabase().getRefsByPrefix("refs/tags/");
            Map<ObjectId, List<Ref>> tags = tagList.stream().collect(Collectors.groupingBy(this::getObjectIdFromRef));
            RevFlagSet allFlags = new RevFlagSet();
            class Candidate {
                final Ref tag;
                final RevFlag flag;
                int depth;

                Candidate(RevCommit commit, Ref tag, RevFlagSet revFlagSet) {
                    this.tag = tag;
                    this.flag = DescribeCommand.this.w.newFlag(tag.getName());
                    revFlagSet.add(this.flag);
                    DescribeCommand.this.w.carry(this.flag);
                    commit.add(this.flag);
                    commit.carry(this.flag);
                }

                boolean reaches(RevCommit c) {
                    return c.has(this.flag);
                }

                String describe(ObjectId tip) throws IOException {
                    return DescribeCommand.this.longDescription(this.tag, this.depth, tip);
                }
            }
            ArrayList<Candidate> candidates = new ArrayList<Candidate>();
            Optional<Ref> bestMatch = this.getBestMatch(tags.get(this.target));
            if (bestMatch.isPresent()) {
                String string = this.longDesc ? this.longDescription(bestMatch.get(), 0, this.target) : bestMatch.get().getName().substring("refs/tags/".length());
                return string;
            }
            this.w.markStart(this.target);
            int seen = 0;
            while ((c = this.w.next()) != null) {
                if (!c.hasAny(allFlags) && (bestMatch = this.getBestMatch(tags.get(c))).isPresent()) {
                    Candidate cd = new Candidate(c, bestMatch.get(), allFlags);
                    candidates.add(cd);
                    cd.depth = seen;
                }
                for (Candidate cd : candidates) {
                    if (cd.reaches(c)) continue;
                    ++cd.depth;
                }
                if (candidates.size() >= this.maxCandidates) break;
                ++seen;
            }
            while ((c = this.w.next()) != null) {
                if (c.hasAll(allFlags)) {
                    RevCommit[] revCommitArray = c.getParents();
                    int n = revCommitArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        RevCommit p = revCommitArray[n2];
                        p.add(RevFlag.SEEN);
                        ++n2;
                    }
                    continue;
                }
                for (Candidate cd : candidates) {
                    if (cd.reaches(c)) continue;
                    ++cd.depth;
                }
            }
            if (candidates.isEmpty()) {
                return null;
            }
            Candidate best = Collections.min(candidates, new Comparator<Candidate>(){

                @Override
                public int compare(Candidate o1, Candidate o2) {
                    return o1.depth - o2.depth;
                }
            });
            String string = best.describe(this.target);
            return string;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        finally {
            this.setCallable(false);
            this.w.close();
        }
    }
}

