/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.AsyncRevObjectQueue;
import org.eclipse.jgit.revwalk.BitmapWalker;
import org.eclipse.jgit.revwalk.DepthWalk;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.CommitTimeRevFilter;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.storage.pack.PackStatistics;
import org.eclipse.jgit.transport.AdvertiseRefsHook;
import org.eclipse.jgit.transport.CapabilitiesV2Request;
import org.eclipse.jgit.transport.FetchV2Request;
import org.eclipse.jgit.transport.GitProtocolConstants;
import org.eclipse.jgit.transport.LsRefsV2Request;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.PacketLineOut;
import org.eclipse.jgit.transport.PostUploadHook;
import org.eclipse.jgit.transport.PreUploadHook;
import org.eclipse.jgit.transport.ProtocolV2Hook;
import org.eclipse.jgit.transport.ProtocolV2Parser;
import org.eclipse.jgit.transport.RefAdvertiser;
import org.eclipse.jgit.transport.RefFilter;
import org.eclipse.jgit.transport.RequestNotYetReadException;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.SideBandOutputStream;
import org.eclipse.jgit.transport.SideBandProgressMonitor;
import org.eclipse.jgit.transport.TransferConfig;
import org.eclipse.jgit.transport.UploadPackInternalServerErrorException;
import org.eclipse.jgit.transport.UserAgent;
import org.eclipse.jgit.transport.WantNotValidException;
import org.eclipse.jgit.util.io.InterruptTimer;
import org.eclipse.jgit.util.io.NullOutputStream;
import org.eclipse.jgit.util.io.TimeoutInputStream;
import org.eclipse.jgit.util.io.TimeoutOutputStream;

public class UploadPack {
    private final Repository db;
    private final RevWalk walk;
    private PackConfig packConfig;
    private TransferConfig transferConfig;
    private int timeout;
    private boolean biDirectionalPipe = true;
    private InterruptTimer timer;
    private boolean clientRequestedV2;
    private InputStream rawIn;
    private ResponseBufferedOutputStream rawOut;
    private PacketLineIn pckIn;
    private PacketLineOut pckOut;
    private OutputStream msgOut = NullOutputStream.INSTANCE;
    private Map<String, Ref> refs;
    private ProtocolV2Hook protocolV2Hook = ProtocolV2Hook.DEFAULT;
    private AdvertiseRefsHook advertiseRefsHook = AdvertiseRefsHook.DEFAULT;
    private boolean advertiseRefsHookCalled;
    private RefFilter refFilter = RefFilter.DEFAULT;
    private PreUploadHook preUploadHook = PreUploadHook.NULL;
    private PostUploadHook postUploadHook = PostUploadHook.NULL;
    private Set<String> options;
    String userAgent;
    private final Set<ObjectId> wantIds = new HashSet<ObjectId>();
    private final Set<RevObject> wantAll = new HashSet<RevObject>();
    private final Set<RevObject> commonBase = new HashSet<RevObject>();
    private Set<ObjectId> clientShallowCommits = new HashSet<ObjectId>();
    private int depth;
    private int shallowSince;
    private List<String> deepenNotRefs = new ArrayList<String>();
    private int oldestTime;
    private Boolean okToGiveUp;
    private boolean sentReady;
    private Set<ObjectId> advertised;
    private final RevFlag WANT;
    private final RevFlag PEER_HAS;
    private final RevFlag COMMON;
    private final RevFlag SATISFIED;
    private final RevFlagSet SAVE;
    private RequestValidator requestValidator = new AdvertisedRequestValidator();
    private GitProtocolConstants.MultiAck multiAck = GitProtocolConstants.MultiAck.OFF;
    private boolean noDone;
    private PackStatistics statistics;
    private long filterBlobLimit = -1L;

    public UploadPack(Repository copyFrom) {
        this.db = copyFrom;
        this.walk = new RevWalk(this.db);
        this.walk.setRetainBody(false);
        this.WANT = this.walk.newFlag("WANT");
        this.PEER_HAS = this.walk.newFlag("PEER_HAS");
        this.COMMON = this.walk.newFlag("COMMON");
        this.SATISFIED = this.walk.newFlag("SATISFIED");
        this.walk.carry(this.PEER_HAS);
        this.SAVE = new RevFlagSet();
        this.SAVE.add(this.WANT);
        this.SAVE.add(this.PEER_HAS);
        this.SAVE.add(this.COMMON);
        this.SAVE.add(this.SATISFIED);
        this.setTransferConfig(null);
    }

    public final Repository getRepository() {
        return this.db;
    }

    public final RevWalk getRevWalk() {
        return this.walk;
    }

    public final Map<String, Ref> getAdvertisedRefs() {
        return this.refs;
    }

    public void setAdvertisedRefs(Map<String, Ref> allRefs) {
        this.refs = allRefs != null ? allRefs : this.db.getAllRefs();
        this.refs = this.refFilter == RefFilter.DEFAULT ? this.transferConfig.getRefFilter().filter(this.refs) : this.refFilter.filter(this.refs);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int seconds) {
        this.timeout = seconds;
    }

    public boolean isBiDirectionalPipe() {
        return this.biDirectionalPipe;
    }

    public void setBiDirectionalPipe(boolean twoWay) {
        this.biDirectionalPipe = twoWay;
    }

    public RequestPolicy getRequestPolicy() {
        if (this.requestValidator instanceof AdvertisedRequestValidator) {
            return RequestPolicy.ADVERTISED;
        }
        if (this.requestValidator instanceof ReachableCommitRequestValidator) {
            return RequestPolicy.REACHABLE_COMMIT;
        }
        if (this.requestValidator instanceof TipRequestValidator) {
            return RequestPolicy.TIP;
        }
        if (this.requestValidator instanceof ReachableCommitTipRequestValidator) {
            return RequestPolicy.REACHABLE_COMMIT_TIP;
        }
        if (this.requestValidator instanceof AnyRequestValidator) {
            return RequestPolicy.ANY;
        }
        return null;
    }

    public void setRequestPolicy(RequestPolicy policy) {
        switch (policy) {
            default: {
                this.requestValidator = new AdvertisedRequestValidator();
                break;
            }
            case REACHABLE_COMMIT: {
                this.requestValidator = new ReachableCommitRequestValidator();
                break;
            }
            case TIP: {
                this.requestValidator = new TipRequestValidator();
                break;
            }
            case REACHABLE_COMMIT_TIP: {
                this.requestValidator = new ReachableCommitTipRequestValidator();
                break;
            }
            case ANY: {
                this.requestValidator = new AnyRequestValidator();
            }
        }
    }

    public void setRequestValidator(RequestValidator validator) {
        this.requestValidator = validator != null ? validator : new AdvertisedRequestValidator();
    }

    public AdvertiseRefsHook getAdvertiseRefsHook() {
        return this.advertiseRefsHook;
    }

    public RefFilter getRefFilter() {
        return this.refFilter;
    }

    public void setAdvertiseRefsHook(AdvertiseRefsHook advertiseRefsHook) {
        this.advertiseRefsHook = advertiseRefsHook != null ? advertiseRefsHook : AdvertiseRefsHook.DEFAULT;
    }

    public void setProtocolV2Hook(ProtocolV2Hook hook) {
        this.protocolV2Hook = hook;
    }

    public void setRefFilter(RefFilter refFilter) {
        this.refFilter = refFilter != null ? refFilter : RefFilter.DEFAULT;
    }

    public PreUploadHook getPreUploadHook() {
        return this.preUploadHook;
    }

    public void setPreUploadHook(PreUploadHook hook) {
        this.preUploadHook = hook != null ? hook : PreUploadHook.NULL;
    }

    public PostUploadHook getPostUploadHook() {
        return this.postUploadHook;
    }

    public void setPostUploadHook(PostUploadHook hook) {
        this.postUploadHook = hook != null ? hook : PostUploadHook.NULL;
    }

    public void setPackConfig(PackConfig pc) {
        this.packConfig = pc;
    }

    public void setTransferConfig(TransferConfig tc) {
        TransferConfig transferConfig = this.transferConfig = tc != null ? tc : new TransferConfig(this.db);
        if (this.transferConfig.isAllowTipSha1InWant()) {
            this.setRequestPolicy(this.transferConfig.isAllowReachableSha1InWant() ? RequestPolicy.REACHABLE_COMMIT_TIP : RequestPolicy.TIP);
        } else {
            this.setRequestPolicy(this.transferConfig.isAllowReachableSha1InWant() ? RequestPolicy.REACHABLE_COMMIT : RequestPolicy.ADVERTISED);
        }
    }

    public boolean isSideBand() throws RequestNotYetReadException {
        if (this.options == null) {
            throw new RequestNotYetReadException();
        }
        return this.options.contains("side-band") || this.options.contains("side-band-64k");
    }

    public void setExtraParameters(Collection<String> params) {
        this.clientRequestedV2 = params.contains("version=2");
    }

    private boolean useProtocolV2() {
        return TransferConfig.ProtocolVersion.V2.equals((Object)this.transferConfig.protocolVersion) && this.clientRequestedV2;
    }

    public void upload(InputStream input, OutputStream output, OutputStream messages) throws IOException {
        try {
            this.rawIn = input;
            if (messages != null) {
                this.msgOut = messages;
            }
            if (this.timeout > 0) {
                Thread caller = Thread.currentThread();
                this.timer = new InterruptTimer(String.valueOf(caller.getName()) + "-Timer");
                TimeoutInputStream i = new TimeoutInputStream(this.rawIn, this.timer);
                TimeoutOutputStream o = new TimeoutOutputStream(output, this.timer);
                i.setTimeout(this.timeout * 1000);
                o.setTimeout(this.timeout * 1000);
                this.rawIn = i;
                output = o;
            }
            this.rawOut = new ResponseBufferedOutputStream(output);
            if (this.biDirectionalPipe) {
                this.rawOut.stopBuffering();
            }
            this.pckIn = new PacketLineIn(this.rawIn);
            this.pckOut = new PacketLineOut(this.rawOut);
            if (this.useProtocolV2()) {
                this.serviceV2();
            } else {
                this.service();
            }
        }
        finally {
            this.msgOut = NullOutputStream.INSTANCE;
            this.walk.close();
            if (this.timer != null) {
                try {
                    this.timer.terminate();
                }
                finally {
                    this.timer = null;
                }
            }
        }
    }

    public PackStatistics getStatistics() {
        return this.statistics;
    }

    private Map<String, Ref> getAdvertisedOrDefaultRefs() throws IOException {
        if (this.refs != null) {
            return this.refs;
        }
        if (!this.advertiseRefsHookCalled) {
            this.advertiseRefsHook.advertiseRefs(this);
            this.advertiseRefsHookCalled = true;
        }
        if (this.refs == null) {
            this.setAdvertisedRefs(this.db.getRefDatabase().getRefs().stream().collect(Collectors.toMap(Ref::getName, Function.identity())));
        }
        return this.refs;
    }

    private Map<String, Ref> getFilteredRefs(Collection<String> refPrefixes) throws IOException {
        if (refPrefixes.isEmpty()) {
            return this.getAdvertisedOrDefaultRefs();
        }
        if (this.refs == null && !this.advertiseRefsHookCalled) {
            this.advertiseRefsHook.advertiseRefs(this);
            this.advertiseRefsHookCalled = true;
        }
        if (this.refs == null) {
            HashMap<String, Ref> rs = new HashMap<String, Ref>();
            for (String p : refPrefixes) {
                for (Ref r : this.db.getRefDatabase().getRefsByPrefix(p)) {
                    rs.put(r.getName(), r);
                }
            }
            if (this.refFilter != RefFilter.DEFAULT) {
                return this.refFilter.filter(rs);
            }
            return this.transferConfig.getRefFilter().filter(rs);
        }
        return this.refs.values().stream().filter(ref -> refPrefixes.stream().anyMatch(ref.getName()::startsWith)).collect(Collectors.toMap(Ref::getName, Function.identity()));
    }

    @Nullable
    private Ref getRef(String name) throws IOException {
        if (this.refs != null) {
            return this.refs.get(name);
        }
        if (!this.advertiseRefsHookCalled) {
            this.advertiseRefsHook.advertiseRefs(this);
            this.advertiseRefsHookCalled = true;
        }
        if (this.refs == null && this.refFilter == RefFilter.DEFAULT && this.transferConfig.hasDefaultRefFilter()) {
            return this.db.getRefDatabase().exactRef(name);
        }
        return this.getAdvertisedOrDefaultRefs().get(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void service() throws IOException {
        block24: {
            boolean sendPack = false;
            PackStatistics.Accumulator accumulator = new PackStatistics.Accumulator();
            ArrayList<ObjectId> unshallowCommits = new ArrayList<ObjectId>();
            try {
                if (this.biDirectionalPipe) {
                    this.sendAdvertisedRefs(new RefAdvertiser.PacketLineOutRefAdvertiser(this.pckOut));
                } else {
                    this.advertised = this.requestValidator instanceof AnyRequestValidator ? Collections.emptySet() : UploadPack.refIdSet(this.getAdvertisedOrDefaultRefs().values());
                }
                long negotiateStart = System.currentTimeMillis();
                accumulator.advertised = this.advertised.size();
                this.recvWants();
                if (this.wantIds.isEmpty()) {
                    this.preUploadHook.onBeginNegotiateRound(this, this.wantIds, 0);
                    this.preUploadHook.onEndNegotiateRound(this, this.wantIds, 0, 0, false);
                }
                accumulator.wants = this.wantIds.size();
                if (this.options.contains("multi_ack_detailed")) {
                    this.multiAck = GitProtocolConstants.MultiAck.DETAILED;
                    this.noDone = this.options.contains("no-done");
                } else {
                    this.multiAck = this.options.contains("multi_ack") ? GitProtocolConstants.MultiAck.CONTINUE : GitProtocolConstants.MultiAck.OFF;
                }
                if (!this.clientShallowCommits.isEmpty()) {
                    this.verifyClientShallow(this.clientShallowCommits);
                }
                if (this.depth != 0) {
                    this.processShallow(null, unshallowCommits, true);
                }
                if (!this.clientShallowCommits.isEmpty()) {
                    this.walk.assumeShallow(this.clientShallowCommits);
                }
                sendPack = this.negotiate(accumulator);
                accumulator.timeNegotiating += System.currentTimeMillis() - negotiateStart;
                if (!sendPack) {
                }
                if (this.biDirectionalPipe) {
                }
                int eof = this.rawIn.read();
                if (eof >= 0) {
                    sendPack = false;
                    throw new CorruptObjectException(MessageFormat.format(JGitText.get().expectedEOFReceived, "\\x" + Integer.toHexString(eof)));
                }
            }
            catch (ServiceMayNotContinueException err) {
                if (err.isOutput()) throw err;
                if (err.getMessage() == null) throw err;
                try {
                    this.pckOut.writeString("ERR " + err.getMessage() + "\n");
                    err.setOutput();
                    throw err;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw err;
            }
            catch (IOException | Error | RuntimeException err) {
                boolean output = false;
                try {
                    String msg = err instanceof PackProtocolException ? err.getMessage() : JGitText.get().internalServerError;
                    this.pckOut.writeString("ERR " + msg + "\n");
                    output = true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!output) throw err;
                throw new UploadPackInternalServerErrorException(err);
            }
            finally {
                if (sendPack || this.biDirectionalPipe) break block24;
            }
            while (0L < this.rawIn.skip(2048L) || this.rawIn.read() >= 0) {
            }
        }
        this.rawOut.stopBuffering();
    }

    private void lsRefsV2() throws IOException {
        LsRefsV2Request.Builder builder = LsRefsV2Request.builder();
        ArrayList<String> prefixes = new ArrayList<String>();
        String line = this.pckIn.readString();
        if (line == PacketLineIn.DELIM) {
            while ((line = this.pckIn.readString()) != PacketLineIn.END) {
                if (line.equals("peel")) {
                    builder.setPeel(true);
                    continue;
                }
                if (line.equals("symrefs")) {
                    builder.setSymrefs(true);
                    continue;
                }
                if (line.startsWith("ref-prefix ")) {
                    prefixes.add(line.substring("ref-prefix ".length()));
                    continue;
                }
                throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedPacketLine, line));
            }
        } else if (line != PacketLineIn.END) {
            throw new PackProtocolException(MessageFormat.format(JGitText.get().unexpectedPacketLine, line));
        }
        LsRefsV2Request req = builder.setRefPrefixes(prefixes).build();
        this.protocolV2Hook.onLsRefs(req);
        this.rawOut.stopBuffering();
        RefAdvertiser.PacketLineOutRefAdvertiser adv = new RefAdvertiser.PacketLineOutRefAdvertiser(this.pckOut);
        adv.setUseProtocolV2(true);
        if (req.getPeel()) {
            adv.setDerefTags(true);
        }
        Map<String, Ref> refsToSend = this.getFilteredRefs(req.getRefPrefixes());
        if (req.getSymrefs()) {
            UploadPack.findSymrefs(adv, refsToSend);
        }
        adv.send(refsToSend);
        adv.end();
    }

    private void fetchV2() throws IOException {
        this.advertised = this.requestValidator instanceof TipRequestValidator || this.requestValidator instanceof ReachableCommitTipRequestValidator || this.requestValidator instanceof AnyRequestValidator ? Collections.emptySet() : UploadPack.refIdSet(this.getAdvertisedOrDefaultRefs().values());
        ProtocolV2Parser parser = new ProtocolV2Parser(this.transferConfig);
        FetchV2Request req = parser.parseFetchRequest(this.pckIn);
        this.rawOut.stopBuffering();
        this.protocolV2Hook.onFetch(req);
        this.options = req.getOptions();
        this.clientShallowCommits = req.getClientShallowCommits();
        this.depth = req.getDepth();
        this.shallowSince = req.getDeepenSince();
        this.filterBlobLimit = req.getFilterBlobLimit();
        this.deepenNotRefs = req.getDeepenNotRefs();
        this.wantIds.addAll(req.getWantsIds());
        TreeMap<String, ObjectId> wantedRefs = new TreeMap<String, ObjectId>();
        for (String refName : req.getWantedRefs()) {
            Ref ref = this.getRef(refName);
            if (ref == null) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidRefName, refName));
            }
            ObjectId objectId = ref.getObjectId();
            if (objectId == null) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidRefName, refName));
            }
            this.wantIds.add(objectId);
            wantedRefs.put(refName, objectId);
        }
        boolean sectionSent = false;
        ArrayList<ObjectId> shallowCommits = null;
        ArrayList<ObjectId> unshallowCommits = new ArrayList<ObjectId>();
        if (!req.getClientShallowCommits().isEmpty()) {
            this.verifyClientShallow(req.getClientShallowCommits());
        }
        if (req.getDepth() != 0 || req.getDeepenSince() != 0 || !req.getDeepenNotRefs().isEmpty()) {
            shallowCommits = new ArrayList<ObjectId>();
            this.processShallow(shallowCommits, unshallowCommits, false);
        }
        if (!req.getClientShallowCommits().isEmpty()) {
            this.walk.assumeShallow(req.getClientShallowCommits());
        }
        if (req.wasDoneReceived()) {
            this.processHaveLines(req.getPeerHas(), ObjectId.zeroId(), new PacketLineOut(NullOutputStream.INSTANCE));
        } else {
            this.pckOut.writeString("acknowledgments\n");
            for (ObjectId objectId : req.getPeerHas()) {
                if (!this.walk.getObjectReader().has(objectId)) continue;
                this.pckOut.writeString("ACK " + objectId.getName() + "\n");
            }
            this.processHaveLines(req.getPeerHas(), ObjectId.zeroId(), new PacketLineOut(NullOutputStream.INSTANCE));
            if (this.okToGiveUp()) {
                this.pckOut.writeString("ready\n");
            } else if (this.commonBase.isEmpty()) {
                this.pckOut.writeString("NAK\n");
            }
            sectionSent = true;
        }
        if (req.wasDoneReceived() || this.okToGiveUp()) {
            if (shallowCommits != null) {
                if (sectionSent) {
                    this.pckOut.writeDelim();
                }
                this.pckOut.writeString("shallow-info\n");
                for (ObjectId objectId : shallowCommits) {
                    this.pckOut.writeString("shallow " + objectId.getName() + '\n');
                }
                for (ObjectId objectId : unshallowCommits) {
                    this.pckOut.writeString("unshallow " + objectId.getName() + '\n');
                }
                sectionSent = true;
            }
            if (!wantedRefs.isEmpty()) {
                if (sectionSent) {
                    this.pckOut.writeDelim();
                }
                this.pckOut.writeString("wanted-refs\n");
                for (Map.Entry entry : wantedRefs.entrySet()) {
                    this.pckOut.writeString(String.valueOf(((ObjectId)entry.getValue()).getName()) + ' ' + (String)entry.getKey() + '\n');
                }
                sectionSent = true;
            }
            if (sectionSent) {
                this.pckOut.writeDelim();
            }
            this.pckOut.writeString("packfile\n");
            this.sendPack(new PackStatistics.Accumulator(), req.getOptions().contains("include-tag") ? this.db.getRefDatabase().getRefsByPrefix("refs/tags/") : null, unshallowCommits);
        } else {
            this.pckOut.end();
        }
    }

    private boolean serveOneCommandV2() throws IOException {
        String command;
        try {
            command = this.pckIn.readString();
        }
        catch (EOFException eof) {
            return true;
        }
        if (command == PacketLineIn.END) {
            return true;
        }
        if (command.equals("command=ls-refs")) {
            this.lsRefsV2();
            return false;
        }
        if (command.equals("command=fetch")) {
            this.fetchV2();
            return false;
        }
        throw new PackProtocolException(MessageFormat.format(JGitText.get().unknownTransportCommand, command));
    }

    private List<String> getV2CapabilityAdvertisement() {
        ArrayList<String> caps = new ArrayList<String>();
        caps.add("version 2");
        caps.add("ls-refs");
        boolean advertiseRefInWant = this.transferConfig.isAllowRefInWant() && this.db.getConfig().getBoolean("uploadpack", null, "advertiserefinwant", true);
        caps.add("fetch=" + (this.transferConfig.isAllowFilter() ? "filter " : "") + (advertiseRefInWant ? "ref-in-want " : "") + "shallow");
        return caps;
    }

    private void serviceV2() throws IOException {
        block7: {
            if (this.biDirectionalPipe) {
                this.protocolV2Hook.onCapabilities(CapabilitiesV2Request.builder().build());
                for (String s : this.getV2CapabilityAdvertisement()) {
                    this.pckOut.writeString(String.valueOf(s) + "\n");
                }
                this.pckOut.end();
                while (!this.serveOneCommandV2()) {
                }
                return;
            }
            try {
                this.serveOneCommandV2();
                break block7;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            while (0L < this.rawIn.skip(2048L) || this.rawIn.read() >= 0) {
            }
            this.rawOut.stopBuffering();
            throw throwable;
        }
        while (0L < this.rawIn.skip(2048L) || this.rawIn.read() >= 0) {
        }
        this.rawOut.stopBuffering();
    }

    private static Set<ObjectId> refIdSet(Collection<Ref> refs) {
        HashSet<ObjectId> ids = new HashSet<ObjectId>(refs.size());
        for (Ref ref : refs) {
            ObjectId id = ref.getObjectId();
            if (id != null) {
                ids.add(id);
            }
            if ((id = ref.getPeeledObjectId()) == null) continue;
            ids.add(id);
        }
        return ids;
    }

    private void processShallow(@Nullable List<ObjectId> shallowCommits, List<ObjectId> unshallowCommits, boolean writeToPckOut) throws IOException {
        if (this.options.contains("deepen-relative") || this.shallowSince != 0 || !this.deepenNotRefs.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        int walkDepth = this.depth - 1;
        Throwable throwable = null;
        Object var6_7 = null;
        try (DepthWalk.RevWalk depthWalk = new DepthWalk.RevWalk(this.walk.getObjectReader(), walkDepth);){
            ObjectId o2;
            for (ObjectId o2 : this.wantIds) {
                try {
                    depthWalk.markRoot(depthWalk.parseCommit(o2));
                }
                catch (IncorrectObjectTypeException incorrectObjectTypeException) {
                    // empty catch block
                }
            }
            while ((o2 = depthWalk.next()) != null) {
                DepthWalk.Commit c = (DepthWalk.Commit)o2;
                if (c.getDepth() == walkDepth && !this.clientShallowCommits.contains(c)) {
                    if (shallowCommits != null) {
                        shallowCommits.add(c.copy());
                    }
                    if (writeToPckOut) {
                        this.pckOut.writeString("shallow " + o2.name());
                    }
                }
                if (c.getDepth() >= walkDepth || !this.clientShallowCommits.remove(c)) continue;
                unshallowCommits.add(c.copy());
                if (!writeToPckOut) continue;
                this.pckOut.writeString("unshallow " + c.name());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (writeToPckOut) {
            this.pckOut.end();
        }
    }

    private void verifyClientShallow(Set<ObjectId> shallowCommits) throws IOException, PackProtocolException {
        block7: {
            AsyncRevObjectQueue q = this.walk.parseAny(shallowCommits, true);
            try {
                while (true) {
                    try {
                        RevObject o;
                        do {
                            if ((o = q.next()) != null) continue;
                            break block7;
                        } while (o instanceof RevCommit);
                        throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidShallowObject, o.name()));
                    }
                    catch (MissingObjectException notCommit) {
                        shallowCommits.remove(notCommit.getObjectId());
                        continue;
                    }
                    break;
                }
            }
            finally {
                q.release();
            }
        }
    }

    public void sendAdvertisedRefs(RefAdvertiser adv) throws IOException, ServiceMayNotContinueException {
        this.sendAdvertisedRefs(adv, null);
    }

    public void sendAdvertisedRefs(RefAdvertiser adv, @Nullable String serviceName) throws IOException, ServiceMayNotContinueException {
        RequestPolicy policy;
        if (this.useProtocolV2()) {
            this.protocolV2Hook.onCapabilities(CapabilitiesV2Request.builder().build());
            for (String s : this.getV2CapabilityAdvertisement()) {
                adv.writeOne(s);
            }
            adv.end();
            return;
        }
        Map<String, Ref> advertisedOrDefaultRefs = this.getAdvertisedOrDefaultRefs();
        if (serviceName != null) {
            adv.writeOne("# service=" + serviceName + '\n');
            adv.end();
        }
        adv.init(this.db);
        adv.advertiseCapability("include-tag");
        adv.advertiseCapability("multi_ack_detailed");
        adv.advertiseCapability("multi_ack");
        adv.advertiseCapability("ofs-delta");
        adv.advertiseCapability("side-band");
        adv.advertiseCapability("side-band-64k");
        adv.advertiseCapability("thin-pack");
        adv.advertiseCapability("no-progress");
        adv.advertiseCapability("shallow");
        if (!this.biDirectionalPipe) {
            adv.advertiseCapability("no-done");
        }
        if ((policy = this.getRequestPolicy()) == RequestPolicy.TIP || policy == RequestPolicy.REACHABLE_COMMIT_TIP || policy == null) {
            adv.advertiseCapability("allow-tip-sha1-in-want");
        }
        if (policy == RequestPolicy.REACHABLE_COMMIT || policy == RequestPolicy.REACHABLE_COMMIT_TIP || policy == null) {
            adv.advertiseCapability("allow-reachable-sha1-in-want");
        }
        adv.advertiseCapability("agent", UserAgent.get());
        if (this.transferConfig.isAllowFilter()) {
            adv.advertiseCapability("filter");
        }
        adv.setDerefTags(true);
        UploadPack.findSymrefs(adv, advertisedOrDefaultRefs);
        this.advertised = adv.send(advertisedOrDefaultRefs);
        if (adv.isEmpty()) {
            adv.advertiseId(ObjectId.zeroId(), "capabilities^{}");
        }
        adv.end();
    }

    public void sendMessage(String what) {
        try {
            this.msgOut.write(Constants.encode(String.valueOf(what) + "\n"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public OutputStream getMessageOutputStream() {
        return this.msgOut;
    }

    private void recvWants() throws IOException {
        boolean isFirst = true;
        boolean filterReceived = false;
        while (true) {
            String line;
            try {
                line = this.pckIn.readString();
            }
            catch (EOFException eof) {
                if (isFirst) break;
                throw eof;
            }
            if (line == PacketLineIn.END) break;
            if (line.startsWith("deepen ")) {
                this.depth = Integer.parseInt(line.substring(7));
                if (this.depth > 0) continue;
                throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidDepth, this.depth));
            }
            if (line.startsWith("shallow ")) {
                this.clientShallowCommits.add(ObjectId.fromString(line.substring(8)));
                continue;
            }
            if (this.transferConfig.isAllowFilter() && line.startsWith("filter ")) {
                String arg = line.substring("filter".length() + 1);
                if (filterReceived) {
                    throw new PackProtocolException(JGitText.get().tooManyFilters);
                }
                filterReceived = true;
                this.filterBlobLimit = ProtocolV2Parser.filterLine(arg);
                continue;
            }
            if (!line.startsWith("want ") || line.length() < 45) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedGot, "want", line));
            }
            if (isFirst) {
                if (line.length() > 45) {
                    FirstLine firstLine = new FirstLine(line);
                    this.options = firstLine.getOptions();
                    line = firstLine.getLine();
                } else {
                    this.options = Collections.emptySet();
                }
            }
            this.wantIds.add(ObjectId.fromString(line.substring(5)));
            isFirst = false;
        }
    }

    public int getDepth() {
        if (this.options == null) {
            throw new RequestNotYetReadException();
        }
        return this.depth;
    }

    public String getPeerUserAgent() {
        return UserAgent.getAgent(this.options, this.userAgent);
    }

    private boolean negotiate(PackStatistics.Accumulator accumulator) throws IOException {
        String line;
        this.okToGiveUp = Boolean.FALSE;
        ObjectId last = ObjectId.zeroId();
        ArrayList<ObjectId> peerHas = new ArrayList<ObjectId>(64);
        while (true) {
            try {
                line = this.pckIn.readString();
            }
            catch (EOFException eof) {
                if (!this.biDirectionalPipe && this.depth > 0) {
                    return false;
                }
                throw eof;
            }
            if (line == PacketLineIn.END) {
                last = this.processHaveLines(peerHas, last, this.pckOut);
                if (this.commonBase.isEmpty() || this.multiAck != GitProtocolConstants.MultiAck.OFF) {
                    this.pckOut.writeString("NAK\n");
                }
                if (this.noDone && this.sentReady) {
                    this.pckOut.writeString("ACK " + last.name() + "\n");
                    return true;
                }
                if (!this.biDirectionalPipe) {
                    return false;
                }
                this.pckOut.flush();
                continue;
            }
            if (!line.startsWith("have ") || line.length() != 45) break;
            peerHas.add(ObjectId.fromString(line.substring(5)));
            ++accumulator.haves;
        }
        if (line.equals("done")) {
            last = this.processHaveLines(peerHas, last, this.pckOut);
            if (this.commonBase.isEmpty()) {
                this.pckOut.writeString("NAK\n");
            } else if (this.multiAck != GitProtocolConstants.MultiAck.OFF) {
                this.pckOut.writeString("ACK " + last.name() + "\n");
            }
            return true;
        }
        throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedGot, "have", line));
    }

    private ObjectId processHaveLines(List<ObjectId> peerHas, ObjectId last, PacketLineOut out) throws IOException {
        this.preUploadHook.onBeginNegotiateRound(this, this.wantIds, peerHas.size());
        if (this.wantAll.isEmpty() && !this.wantIds.isEmpty()) {
            this.parseWants();
        }
        if (peerHas.isEmpty()) {
            return last;
        }
        this.sentReady = false;
        int haveCnt = 0;
        this.walk.getObjectReader().setAvoidUnreachableObjects(true);
        AsyncRevObjectQueue q = this.walk.parseAny(peerHas, false);
        try {
            while (true) {
                RevObject obj;
                try {
                    obj = q.next();
                }
                catch (MissingObjectException notFound) {
                    continue;
                }
                if (obj == null) {
                    break;
                }
                last = obj;
                ++haveCnt;
                if (obj instanceof RevCommit) {
                    RevCommit c = (RevCommit)obj;
                    if (this.oldestTime == 0 || c.getCommitTime() < this.oldestTime) {
                        this.oldestTime = c.getCommitTime();
                    }
                }
                if (obj.has(this.PEER_HAS)) continue;
                obj.add(this.PEER_HAS);
                if (obj instanceof RevCommit) {
                    ((RevCommit)obj).carry(this.PEER_HAS);
                }
                this.addCommonBase(obj);
                switch (this.multiAck) {
                    case OFF: {
                        if (this.commonBase.size() != 1) break;
                        out.writeString("ACK " + obj.name() + "\n");
                        break;
                    }
                    case CONTINUE: {
                        out.writeString("ACK " + obj.name() + " continue\n");
                        break;
                    }
                    case DETAILED: {
                        out.writeString("ACK " + obj.name() + " common\n");
                    }
                }
            }
        }
        finally {
            q.release();
            this.walk.getObjectReader().setAvoidUnreachableObjects(false);
        }
        int missCnt = peerHas.size() - haveCnt;
        boolean didOkToGiveUp = false;
        if (missCnt > 0) {
            int i = peerHas.size() - 1;
            while (i >= 0) {
                ObjectId id = peerHas.get(i);
                if (this.walk.lookupOrNull(id) == null) {
                    didOkToGiveUp = true;
                    if (!this.okToGiveUp()) break;
                    switch (this.multiAck) {
                        case OFF: {
                            break;
                        }
                        case CONTINUE: {
                            out.writeString("ACK " + id.name() + " continue\n");
                            break;
                        }
                        case DETAILED: {
                            out.writeString("ACK " + id.name() + " ready\n");
                            this.sentReady = true;
                        }
                    }
                    break;
                }
                --i;
            }
        }
        if (this.multiAck == GitProtocolConstants.MultiAck.DETAILED && !didOkToGiveUp && this.okToGiveUp()) {
            ObjectId id = peerHas.get(peerHas.size() - 1);
            out.writeString("ACK " + id.name() + " ready\n");
            this.sentReady = true;
        }
        this.preUploadHook.onEndNegotiateRound(this, this.wantAll, haveCnt, missCnt, this.sentReady);
        peerHas.clear();
        return last;
    }

    private void parseWants() throws IOException {
        ArrayList<ObjectId> notAdvertisedWants = null;
        for (ObjectId obj : this.wantIds) {
            if (this.advertised.contains(obj)) continue;
            if (notAdvertisedWants == null) {
                notAdvertisedWants = new ArrayList<ObjectId>();
            }
            notAdvertisedWants.add(obj);
        }
        if (notAdvertisedWants != null) {
            this.requestValidator.checkWants(this, notAdvertisedWants);
        }
        AsyncRevObjectQueue q = this.walk.parseAny(this.wantIds, true);
        try {
            try {
                RevObject obj;
                while ((obj = q.next()) != null) {
                    this.want(obj);
                    if (!(obj instanceof RevCommit)) {
                        obj.add(this.SATISFIED);
                    }
                    if (!(obj instanceof RevTag) || !((obj = this.walk.peel(obj)) instanceof RevCommit)) continue;
                    this.want(obj);
                }
                this.wantIds.clear();
            }
            catch (MissingObjectException notFound) {
                throw new WantNotValidException(notFound.getObjectId(), (Throwable)notFound);
            }
        }
        finally {
            q.release();
        }
    }

    private void want(RevObject obj) {
        if (!obj.has(this.WANT)) {
            obj.add(this.WANT);
            this.wantAll.add(obj);
        }
    }

    private static void checkNotAdvertisedWantsUsingBitmap(ObjectReader reader, BitmapIndex bitmapIndex, List<ObjectId> notAdvertisedWants, Set<ObjectId> reachableFrom) throws IOException {
        BitmapWalker bitmapWalker = new BitmapWalker(new ObjectWalk(reader), bitmapIndex, null);
        BitmapIndex.BitmapBuilder reachables = bitmapWalker.findObjects(reachableFrom, null, false);
        for (ObjectId oid : notAdvertisedWants) {
            if (reachables.contains(oid)) continue;
            throw new WantNotValidException(oid);
        }
    }

    /*
     * Exception decompiling
     */
    private static void checkNotAdvertisedWants(UploadPack up, List<ObjectId> notAdvertisedWants, Set<ObjectId> reachableFrom) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 20[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addCommonBase(RevObject o) {
        if (!o.has(this.COMMON)) {
            o.add(this.COMMON);
            this.commonBase.add(o);
            this.okToGiveUp = null;
        }
    }

    private boolean okToGiveUp() throws PackProtocolException {
        if (this.okToGiveUp == null) {
            this.okToGiveUp = this.okToGiveUpImp();
        }
        return this.okToGiveUp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean okToGiveUpImp() throws PackProtocolException {
        if (this.commonBase.isEmpty()) {
            return false;
        }
        try {
            RevObject obj;
            Iterator<RevObject> iterator = this.wantAll.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (this.wantSatisfied(obj = iterator.next()));
            return false;
        }
        catch (IOException e) {
            throw new PackProtocolException(JGitText.get().internalRevisionError, e);
        }
    }

    private boolean wantSatisfied(RevObject want) throws IOException {
        RevCommit c;
        if (want.has(this.SATISFIED)) {
            return true;
        }
        this.walk.resetRetain(this.SAVE);
        this.walk.markStart((RevCommit)want);
        if (this.oldestTime != 0) {
            this.walk.setRevFilter(CommitTimeRevFilter.after((long)this.oldestTime * 1000L));
        }
        while ((c = this.walk.next()) != null) {
            if (!c.has(this.PEER_HAS)) continue;
            this.addCommonBase(c);
            want.add(this.SATISFIED);
            return true;
        }
        return false;
    }

    private void sendPack(PackStatistics.Accumulator accumulator, @Nullable Collection<Ref> allTags, List<ObjectId> unshallowCommits) throws IOException {
        boolean sideband;
        boolean bl = sideband = this.options.contains("side-band") || this.options.contains("side-band-64k");
        if (sideband) {
            try {
                this.sendPack(true, accumulator, allTags, unshallowCommits);
            }
            catch (ServiceMayNotContinueException noPack) {
                throw noPack;
            }
            catch (IOException err) {
                if (this.reportInternalServerErrorOverSideband()) {
                    throw new UploadPackInternalServerErrorException(err);
                }
                throw err;
            }
            catch (RuntimeException err) {
                if (this.reportInternalServerErrorOverSideband()) {
                    throw new UploadPackInternalServerErrorException(err);
                }
                throw err;
            }
            catch (Error err) {
                if (this.reportInternalServerErrorOverSideband()) {
                    throw new UploadPackInternalServerErrorException(err);
                }
                throw err;
            }
        } else {
            this.sendPack(false, accumulator, allTags, unshallowCommits);
        }
    }

    private boolean reportInternalServerErrorOverSideband() {
        try {
            SideBandOutputStream err = new SideBandOutputStream(3, 1000, this.rawOut);
            err.write(Constants.encode(JGitText.get().internalServerError));
            err.flush();
            return true;
        }
        catch (Throwable cannotReport) {
            return false;
        }
    }

    private void sendPack(boolean sideband, PackStatistics.Accumulator accumulator, @Nullable Collection<Ref> allTags, List<ObjectId> unshallowCommits) throws IOException {
        ProgressMonitor pm = NullProgressMonitor.INSTANCE;
        OutputStream packOut = this.rawOut;
        if (sideband) {
            int bufsz = 1000;
            if (this.options.contains("side-band-64k")) {
                bufsz = 65520;
            }
            packOut = new SideBandOutputStream(1, bufsz, this.rawOut);
            if (!this.options.contains("no-progress")) {
                this.msgOut = new SideBandOutputStream(2, bufsz, this.rawOut);
                pm = new SideBandProgressMonitor(this.msgOut);
            }
        }
        try {
            if (this.wantAll.isEmpty()) {
                this.preUploadHook.onSendPack(this, this.wantIds, this.commonBase);
            } else {
                this.preUploadHook.onSendPack(this, this.wantAll, this.commonBase);
            }
            this.msgOut.flush();
        }
        catch (ServiceMayNotContinueException noPack) {
            if (sideband && noPack.getMessage() != null) {
                noPack.setOutput();
                SideBandOutputStream err = new SideBandOutputStream(3, 1000, this.rawOut);
                err.write(Constants.encode(noPack.getMessage()));
                err.flush();
            }
            throw noPack;
        }
        PackConfig cfg = this.packConfig;
        if (cfg == null) {
            cfg = new PackConfig(this.db);
        }
        PackWriter pw = new PackWriter(cfg, this.walk.getObjectReader(), accumulator);
        try {
            pw.setIndexDisabled(true);
            if (this.filterBlobLimit >= 0L) {
                pw.setFilterBlobLimit(this.filterBlobLimit);
                pw.setUseCachedPacks(false);
            } else {
                pw.setUseCachedPacks(true);
            }
            pw.setUseBitmaps(this.depth == 0 && this.clientShallowCommits.isEmpty());
            pw.setClientShallowCommits(this.clientShallowCommits);
            pw.setReuseDeltaCommits(true);
            pw.setDeltaBaseAsOffset(this.options.contains("ofs-delta"));
            pw.setThin(this.options.contains("thin-pack"));
            pw.setReuseValidatingObjects(false);
            if (this.commonBase.isEmpty() && this.refs != null) {
                HashSet<ObjectId> tagTargets = new HashSet<ObjectId>();
                for (Ref ref : this.refs.values()) {
                    if (ref.getPeeledObjectId() != null) {
                        tagTargets.add(ref.getPeeledObjectId());
                        continue;
                    }
                    if (ref.getObjectId() == null || !ref.getName().startsWith("refs/heads/")) continue;
                    tagTargets.add(ref.getObjectId());
                }
                pw.setTagTargets(tagTargets);
            }
            RevWalk rw = this.walk;
            if (this.depth > 0) {
                pw.setShallowPack(this.depth, unshallowCommits);
                rw = new DepthWalk.RevWalk(this.walk.getObjectReader(), this.depth - 1);
                rw.assumeShallow(this.clientShallowCommits);
            }
            if (this.wantAll.isEmpty()) {
                pw.preparePack(pm, this.wantIds, this.commonBase, this.clientShallowCommits);
            } else {
                this.walk.reset();
                ObjectWalk ow = rw.toObjectWalkWithSameObjects();
                pw.preparePack(pm, ow, this.wantAll, this.commonBase, PackWriter.NONE);
                rw = ow;
            }
            if (this.options.contains("include-tag") && allTags != null) {
                for (Ref ref : allTags) {
                    RevObject obj;
                    ObjectId objectId = ref.getObjectId();
                    if (objectId == null || (!this.wantAll.isEmpty() ? (obj = rw.lookupOrNull(objectId)) != null && obj.has(this.WANT) : this.wantIds.contains(objectId))) continue;
                    if (!ref.isPeeled()) {
                        ref = this.db.getRefDatabase().peel(ref);
                    }
                    ObjectId peeledId = ref.getPeeledObjectId();
                    objectId = ref.getObjectId();
                    if (peeledId == null || objectId == null || !pw.willInclude(peeledId) || pw.willInclude(objectId)) continue;
                    pw.addObject(rw.parseAny(objectId));
                }
            }
            pw.writePack(pm, NullProgressMonitor.INSTANCE, packOut);
            if (this.msgOut != NullOutputStream.INSTANCE) {
                String msg = String.valueOf(pw.getStatistics().getMessage()) + '\n';
                this.msgOut.write(Constants.encode(msg));
                this.msgOut.flush();
            }
        }
        finally {
            this.statistics = pw.getStatistics();
            if (this.statistics != null) {
                this.postUploadHook.onPostUpload(this.statistics);
            }
            pw.close();
        }
        if (sideband) {
            this.pckOut.end();
        }
    }

    private static void findSymrefs(RefAdvertiser adv, Map<String, Ref> refs) {
        Ref head = refs.get("HEAD");
        if (head != null && head.isSymbolic()) {
            adv.addSymref("HEAD", head.getLeaf().getName());
        }
    }

    public static final class AdvertisedRequestValidator
    implements RequestValidator {
        @Override
        public void checkWants(UploadPack up, List<ObjectId> wants) throws PackProtocolException, IOException {
            if (!up.isBiDirectionalPipe()) {
                new ReachableCommitRequestValidator().checkWants(up, wants);
            } else if (!wants.isEmpty()) {
                throw new WantNotValidException(wants.iterator().next());
            }
        }
    }

    public static final class AnyRequestValidator
    implements RequestValidator {
        @Override
        public void checkWants(UploadPack up, List<ObjectId> wants) throws PackProtocolException, IOException {
        }
    }

    public static class FirstLine {
        private final String line;
        private final Set<String> options;

        public FirstLine(String line) {
            if (line.length() > 45) {
                HashSet<String> opts = new HashSet<String>();
                String opt = line.substring(45);
                if (opt.startsWith(" ")) {
                    opt = opt.substring(1);
                }
                String[] stringArray = opt.split(" ");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String c = stringArray[n2];
                    opts.add(c);
                    ++n2;
                }
                this.line = line.substring(0, 45);
                this.options = Collections.unmodifiableSet(opts);
            } else {
                this.line = line;
                this.options = Collections.emptySet();
            }
        }

        public String getLine() {
            return this.line;
        }

        public Set<String> getOptions() {
            return this.options;
        }
    }

    public static final class ReachableCommitRequestValidator
    implements RequestValidator {
        @Override
        public void checkWants(UploadPack up, List<ObjectId> wants) throws PackProtocolException, IOException {
            UploadPack.checkNotAdvertisedWants(up, wants, UploadPack.refIdSet(up.getAdvertisedRefs().values()));
        }
    }

    public static final class ReachableCommitTipRequestValidator
    implements RequestValidator {
        @Override
        public void checkWants(UploadPack up, List<ObjectId> wants) throws PackProtocolException, IOException {
            UploadPack.checkNotAdvertisedWants(up, wants, UploadPack.refIdSet(up.getRepository().getRefDatabase().getRefs()));
        }
    }

    public static enum RequestPolicy {
        ADVERTISED,
        REACHABLE_COMMIT,
        TIP,
        REACHABLE_COMMIT_TIP,
        ANY;

    }

    public static interface RequestValidator {
        public void checkWants(UploadPack var1, List<ObjectId> var2) throws PackProtocolException, IOException;
    }

    private static class ResponseBufferedOutputStream
    extends OutputStream {
        private final OutputStream rawOut;
        private OutputStream out;

        ResponseBufferedOutputStream(OutputStream rawOut) {
            this.rawOut = rawOut;
            this.out = new ByteArrayOutputStream();
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        void stopBuffering() throws IOException {
            if (this.out != this.rawOut) {
                ((ByteArrayOutputStream)this.out).writeTo(this.rawOut);
                this.out = this.rawOut;
            }
        }
    }

    public static final class TipRequestValidator
    implements RequestValidator {
        @Override
        public void checkWants(UploadPack up, List<ObjectId> wants) throws PackProtocolException, IOException {
            if (!up.isBiDirectionalPipe()) {
                new ReachableCommitTipRequestValidator().checkWants(up, wants);
            } else if (!wants.isEmpty()) {
                Set refIds = UploadPack.refIdSet(up.getRepository().getRefDatabase().getRefs());
                for (ObjectId obj : wants) {
                    if (refIds.contains(obj)) continue;
                    throw new WantNotValidException(obj);
                }
            }
        }
    }
}

