/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.api.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jkube.kit.build.api.model.Container;
import org.eclipse.jkube.kit.common.util.EnvUtil;

public class PortMapping {
    private static final Pattern PROTOCOL_SPLIT_PATTERN = Pattern.compile("(.*?)(?:/(tcp|udp))?$");
    private final Map<String, String> bindToHostMap = new HashMap<String, String>();
    private final Map<String, Integer> containerPortToHostPort = new HashMap<String, Integer>();
    private final Properties dynamicProperties = new Properties();
    private final Map<String, String> hostIpVariableMap = new HashMap<String, String>();
    private final Map<String, Integer> hostPortVariableMap = new HashMap<String, Integer>();
    private final Properties projProperties;
    private final Map<String, String> specToHostIpVariableMap = new HashMap<String, String>();
    private final Map<String, String> specToHostPortVariableMap = new HashMap<String, String>();

    public PortMapping(List<String> portMappings, Properties projProperties) {
        this.projProperties = projProperties;
        for (String portMapping : portMappings) {
            this.parsePortMapping(portMapping);
        }
    }

    public boolean needsPropertiesUpdate() {
        return !this.specToHostPortVariableMap.isEmpty() || !this.specToHostIpVariableMap.isEmpty();
    }

    public Set<String> getContainerPorts() {
        return this.containerPortToHostPort.keySet();
    }

    public void updateProperties(Map<String, Container.PortBinding> dockerObtainedDynamicBindings) {
        for (Map.Entry<String, Container.PortBinding> entry : dockerObtainedDynamicBindings.entrySet()) {
            String variable = entry.getKey();
            Container.PortBinding portBinding = entry.getValue();
            if (portBinding == null) continue;
            this.update(this.hostPortVariableMap, this.specToHostPortVariableMap.get(variable), portBinding.getHostPort());
            String hostIp = portBinding.getHostIp();
            if ("0.0.0.0".equals(hostIp)) {
                hostIp = this.projProperties.getProperty("docker.host.address");
            }
            this.update(this.hostIpVariableMap, this.specToHostIpVariableMap.get(variable), hostIp);
        }
        this.updateDynamicProperties(this.hostPortVariableMap);
        this.updateDynamicProperties(this.hostIpVariableMap);
    }

    public JsonObject toDockerPortBindingsJson() {
        Map<String, Integer> portMap = this.getContainerPortToHostPortMap();
        if (!portMap.isEmpty()) {
            JsonObject portBindings = new JsonObject();
            Map<String, String> bindToMap = this.getBindToHostMap();
            for (Map.Entry<String, Integer> entry : portMap.entrySet()) {
                String containerPortSpec = entry.getKey();
                Integer hostPort = entry.getValue();
                JsonObject o = new JsonObject();
                o.addProperty("HostPort", hostPort != null ? hostPort.toString() : "");
                if (bindToMap.containsKey(containerPortSpec)) {
                    o.addProperty("HostIp", bindToMap.get(containerPortSpec));
                }
                JsonArray array = new JsonArray();
                array.add((JsonElement)o);
                portBindings.add(containerPortSpec, (JsonElement)array);
            }
            return portBindings;
        }
        return null;
    }

    public JsonArray toJson() {
        Map<String, Integer> portMap = this.getContainerPortToHostPortMap();
        if (portMap.isEmpty()) {
            return null;
        }
        JsonArray ret = new JsonArray();
        Map<String, String> bindToMap = this.getBindToHostMap();
        for (Map.Entry<String, Integer> entry : portMap.entrySet()) {
            Integer hostPort;
            JsonObject mapping = new JsonObject();
            String containerPortSpec = entry.getKey();
            Matcher matcher = PROTOCOL_SPLIT_PATTERN.matcher(entry.getKey());
            if (!matcher.matches()) {
                throw new IllegalStateException("Internal error: " + entry.getKey() + " doesn't contain protocol part and doesn't match " + PROTOCOL_SPLIT_PATTERN);
            }
            mapping.addProperty("containerPort", (Number)Integer.parseInt(matcher.group(1)));
            if (matcher.group(2) != null) {
                mapping.addProperty("protocol", matcher.group(2));
            }
            if ((hostPort = entry.getValue()) != null) {
                mapping.addProperty("hostPort", (Number)hostPort);
            }
            if (bindToMap.containsKey(containerPortSpec)) {
                mapping.addProperty("hostIP", bindToMap.get(containerPortSpec));
            }
            ret.add((JsonElement)mapping);
        }
        return ret;
    }

    Map<String, String> getBindToHostMap() {
        return this.bindToHostMap;
    }

    Map<String, Integer> getContainerPortToHostPortMap() {
        return this.containerPortToHostPort;
    }

    Map<String, String> getHostIpVariableMap() {
        return this.hostIpVariableMap;
    }

    Map<String, Integer> getHostPortVariableMap() {
        return this.hostPortVariableMap;
    }

    Map<String, Integer> getPortsMap() {
        return this.containerPortToHostPort;
    }

    private IllegalArgumentException createInvalidMappingError(String mapping, Exception exp) {
        return new IllegalArgumentException("\nInvalid port mapping '" + mapping + "'\nRequired format: '<hostIP>:<hostPort>:<containerPort>(/tcp|udp)'\nSee the reference manual for more details");
    }

    private void createMapping(String[] parts, String protocol) {
        if (parts.length == 3) {
            this.mapBindToAndHostPortSpec(parts[0], parts[1], this.createPortSpec(parts[2], protocol));
        } else if (parts.length == 2) {
            this.mapHostPortToSpec(parts[0], this.createPortSpec(parts[1], protocol));
        } else {
            this.mapHostPortToSpec(null, this.createPortSpec(parts[0], protocol));
        }
    }

    private String createPortSpec(String port, String protocol) {
        return Integer.parseInt(port) + "/" + protocol;
    }

    private Integer getAsIntOrNull(String val) {
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException exp) {
            return null;
        }
    }

    private Integer getPortFromProjectOrSystemProperty(String var) {
        String sysProp = System.getProperty(var);
        if (sysProp != null) {
            return this.getAsIntOrNull(sysProp);
        }
        if (this.projProperties.containsKey(var)) {
            return this.getAsIntOrNull(this.projProperties.getProperty(var));
        }
        return null;
    }

    private String extractPortPropertyName(String name) {
        String mavenPropName = EnvUtil.extractMavenPropertyName((String)name);
        return mavenPropName != null ? mavenPropName : name;
    }

    private void mapBindToAndHostPortSpec(String bindTo, String hPort, String portSpec) {
        this.mapHostPortToSpec(hPort, portSpec);
        String hostPropName = this.extractHostPropertyName(bindTo);
        if (hostPropName != null) {
            String host = this.projProperties.getProperty(hostPropName);
            if (host != null) {
                this.bindToHostMap.put(portSpec, this.resolveHostname(host));
            }
            this.specToHostIpVariableMap.put(portSpec, hostPropName);
        } else {
            this.bindToHostMap.put(portSpec, this.resolveHostname(bindTo));
        }
    }

    private String extractHostPropertyName(String name) {
        if (name.startsWith("+")) {
            return name.substring(1);
        }
        return EnvUtil.extractMavenPropertyName((String)name);
    }

    private void mapHostPortToSpec(String hPort, String portSpec) {
        Integer hostPort;
        if (hPort == null) {
            hostPort = null;
        } else {
            try {
                hostPort = Integer.parseInt(hPort);
            }
            catch (NumberFormatException exp) {
                String portPropertyName = this.extractPortPropertyName(hPort);
                hostPort = this.getPortFromProjectOrSystemProperty(portPropertyName);
                if (hostPort != null) {
                    this.hostPortVariableMap.put(portPropertyName, hostPort);
                }
                this.specToHostPortVariableMap.put(portSpec, portPropertyName);
            }
        }
        this.containerPortToHostPort.put(portSpec, hostPort);
    }

    private void parsePortMapping(String input) {
        try {
            Matcher matcher = PROTOCOL_SPLIT_PATTERN.matcher(input);
            matcher.matches();
            String mapping = matcher.group(1);
            String protocol = matcher.group(2);
            if (protocol == null) {
                protocol = "tcp";
            }
            this.createMapping(mapping.split(":", 3), protocol);
        }
        catch (NullPointerException | NumberFormatException exp) {
            throw this.createInvalidMappingError(input, exp);
        }
    }

    private String resolveHostname(String bindToHost) {
        try {
            return InetAddress.getByName(bindToHost).getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Host '" + bindToHost + "' to bind to cannot be resolved");
        }
    }

    private <T> void update(Map<String, T> map, String key, T value) {
        if (key != null) {
            map.put(key, value);
        }
    }

    private void updateDynamicProperties(Map<String, ?> dynamicPorts) {
        for (Map.Entry<String, ?> entry : dynamicPorts.entrySet()) {
            String var = entry.getKey();
            String val = entry.getValue().toString();
            this.projProperties.setProperty(var, val);
            this.dynamicProperties.setProperty(var, val);
        }
    }

    public static class PropertyWriteHelper {
        private final Properties globalExport;
        private final String globalFile;
        private final Map<String, Properties> toExport;

        public PropertyWriteHelper(String globalFile) {
            this.globalFile = globalFile;
            this.toExport = new HashMap<String, Properties>();
            this.globalExport = new Properties();
        }

        public void add(PortMapping portMapping, String portPropertyFile) {
            if (portPropertyFile != null) {
                this.toExport.put(portPropertyFile, portMapping.dynamicProperties);
            } else if (this.globalFile != null) {
                this.globalExport.putAll((Map<?, ?>)portMapping.dynamicProperties);
            }
        }

        public void write() throws IOException {
            for (Map.Entry<String, Properties> entry : this.toExport.entrySet()) {
                Properties props = entry.getValue();
                this.writeProperties(props, entry.getKey());
                this.globalExport.putAll((Map<?, ?>)props);
            }
            if (this.globalFile != null && !this.globalExport.isEmpty()) {
                this.writeProperties(this.globalExport, this.globalFile);
            }
        }

        private void writeProperties(Properties props, String file) throws IOException {
            File propFile = new File(file);
            try (FileOutputStream os = new FileOutputStream(propFile);){
                props.store(os, "Docker ports");
            }
            catch (IOException e) {
                throw new IOException("Cannot write properties to " + file + ": " + e, e);
            }
        }
    }
}

