/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.api.auth;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.build.api.auth.RegistryAuthConfig;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.Serialization;

public class AuthConfig {
    public static final AuthConfig EMPTY_AUTH_CONFIG = new AuthConfig("", "", "", "", "");
    private final String username;
    private final String password;
    private final String email;
    private final String auth;
    private final String identityToken;
    private String authEncoded;

    public AuthConfig(String username, String password, String email, String auth, String identityToken) {
        this.username = username;
        this.password = password;
        this.email = email;
        this.auth = auth;
        this.identityToken = identityToken;
    }

    public AuthConfig(String username, String password, String email, String auth) {
        this(username, password, email, auth, null);
    }

    public String toHeaderValue(KitLogger logger) {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)this.identityToken)) {
            this.putNonNull(ret, "identityToken", this.identityToken);
            if (StringUtils.isNotBlank((CharSequence)this.username)) {
                logger.warn("Using identityToken, found username not blank : " + this.username, new Object[0]);
            }
        } else {
            this.putNonNull(ret, "username", this.username);
            this.putNonNull(ret, "password", this.password);
            this.putNonNull(ret, "email", this.email);
            this.putNonNull(ret, "auth", this.auth);
        }
        try {
            byte[] bytes = Serialization.jsonWriter().without(SerializationFeature.INDENT_OUTPUT).writeValueAsBytes(ret);
            return this.encodeBase64ChunkedURLSafeString(bytes);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Cannot encode auth config", e);
        }
    }

    public static AuthConfig fromMap(Map<String, String> params) {
        return AuthConfig.builder().username(params.get("username")).password(params.get("password")).email(params.get("email")).auth(params.get("auth")).build();
    }

    public static AuthConfig fromCredentialsEncoded(String credentialsEncoded, String email) {
        String credentials = new String(Base64.decodeBase64((String)credentialsEncoded));
        String[] parsedCredentials = credentials.split(":", 2);
        return AuthConfig.builder().username(parsedCredentials[0]).password(parsedCredentials[1]).email(email).build();
    }

    public static AuthConfig fromRegistryAuthConfig(RegistryAuthConfig registryAuthConfig, RegistryAuthConfig.Kind kind, UnaryOperator<String> decryptor) {
        String password = registryAuthConfig.getPassword(kind);
        return AuthConfig.builder().username(registryAuthConfig.getUsername(kind)).email(registryAuthConfig.getEmail(kind)).auth(registryAuthConfig.getAuth(kind)).password(AuthConfig.decryptPassword(password, decryptor)).build();
    }

    public static String decryptPassword(String password, UnaryOperator<String> decryptor) {
        return Optional.ofNullable(decryptor).map(d -> (String)d.apply(password)).orElse(password);
    }

    private String encodeBase64ChunkedURLSafeString(byte[] binaryData) {
        return Base64.encodeBase64String((byte[])binaryData).replace('+', '-').replace('/', '_');
    }

    private void putNonNull(Map<String, String> ret, String key, String value) {
        if (value != null) {
            ret.put(key, value);
        }
    }

    @Generated
    public static AuthConfigBuilder builder() {
        return new AuthConfigBuilder();
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getAuth() {
        return this.auth;
    }

    @Generated
    public String getIdentityToken() {
        return this.identityToken;
    }

    @Generated
    public String getAuthEncoded() {
        return this.authEncoded;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthConfig)) {
            return false;
        }
        AuthConfig other = (AuthConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$auth = this.getAuth();
        String other$auth = other.getAuth();
        if (this$auth == null ? other$auth != null : !this$auth.equals(other$auth)) {
            return false;
        }
        String this$identityToken = this.getIdentityToken();
        String other$identityToken = other.getIdentityToken();
        if (this$identityToken == null ? other$identityToken != null : !this$identityToken.equals(other$identityToken)) {
            return false;
        }
        String this$authEncoded = this.getAuthEncoded();
        String other$authEncoded = other.getAuthEncoded();
        return !(this$authEncoded == null ? other$authEncoded != null : !this$authEncoded.equals(other$authEncoded));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuthConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $auth = this.getAuth();
        result = result * 59 + ($auth == null ? 43 : $auth.hashCode());
        String $identityToken = this.getIdentityToken();
        result = result * 59 + ($identityToken == null ? 43 : $identityToken.hashCode());
        String $authEncoded = this.getAuthEncoded();
        result = result * 59 + ($authEncoded == null ? 43 : $authEncoded.hashCode());
        return result;
    }

    @Generated
    public static class AuthConfigBuilder {
        @Generated
        private String username;
        @Generated
        private String password;
        @Generated
        private String email;
        @Generated
        private String auth;
        @Generated
        private String identityToken;

        @Generated
        AuthConfigBuilder() {
        }

        @Generated
        public AuthConfigBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public AuthConfigBuilder password(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public AuthConfigBuilder email(String email) {
            this.email = email;
            return this;
        }

        @Generated
        public AuthConfigBuilder auth(String auth) {
            this.auth = auth;
            return this;
        }

        @Generated
        public AuthConfigBuilder identityToken(String identityToken) {
            this.identityToken = identityToken;
            return this;
        }

        @Generated
        public AuthConfig build() {
            return new AuthConfig(this.username, this.password, this.email, this.auth, this.identityToken);
        }

        @Generated
        public String toString() {
            return "AuthConfig.AuthConfigBuilder(username=" + this.username + ", password=" + this.password + ", email=" + this.email + ", auth=" + this.auth + ", identityToken=" + this.identityToken + ")";
        }
    }
}

