/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.api.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.build.api.helper.DockerFileUtil;
import org.eclipse.jkube.kit.common.JKubeConfiguration;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;

public class BuildArgResolverUtil {
    private static final String ARG_PREFIX = "docker.buildArg.";

    private BuildArgResolverUtil() {
    }

    public static Map<String, String> mergeBuildArgsIncludingLocalDockerConfigProxySettings(ImageConfiguration imageConfig, JKubeConfiguration configuration, KitLogger logger) {
        ArrayList<Map<String, String>> buildArgSources = new ArrayList<Map<String, String>>();
        buildArgSources.add(BuildArgResolverUtil.buildArgsFromDockerConfig());
        buildArgSources.add(configuration.getBuildArgs());
        buildArgSources.add(BuildArgResolverUtil.buildArgsFromProperties(configuration.getProject().getProperties()));
        buildArgSources.add(BuildArgResolverUtil.buildArgsFromProperties(System.getProperties()));
        buildArgSources.add(imageConfig.getBuild().getArgs());
        return BuildArgResolverUtil.mergeBuildArgsFrom(buildArgSources, logger);
    }

    public static Map<String, String> mergeBuildArgsWithoutLocalDockerConfigProxySettings(ImageConfiguration imageConfig, JKubeConfiguration configuration, KitLogger logger) {
        ArrayList<Map<String, String>> buildArgSources = new ArrayList<Map<String, String>>();
        buildArgSources.add(configuration.getBuildArgs());
        buildArgSources.add(BuildArgResolverUtil.buildArgsFromProperties(configuration.getProject().getProperties()));
        buildArgSources.add(BuildArgResolverUtil.buildArgsFromProperties(System.getProperties()));
        buildArgSources.add(imageConfig.getBuild().getArgs());
        return BuildArgResolverUtil.mergeBuildArgsFrom(buildArgSources, logger);
    }

    private static Map<String, String> mergeBuildArgsFrom(List<Map<String, String>> buildArgSources, KitLogger logger) {
        HashMap<String, String> buildArgs = new HashMap<String, String>();
        buildArgSources.stream().filter(Objects::nonNull).flatMap(map -> map.entrySet().stream()).forEach(entry -> {
            if (buildArgs.containsKey(entry.getKey())) {
                logger.warn(String.format("Multiple Build Args with the same key: %s=%s and %s=%s, overriding value of key to %s=%s", entry.getKey(), buildArgs.get(entry.getKey()), entry.getKey(), entry.getValue(), entry.getKey(), entry.getValue()), new Object[0]);
            }
            buildArgs.put((String)entry.getKey(), (String)entry.getValue());
        });
        return buildArgs;
    }

    private static Map<String, String> buildArgsFromProperties(Properties properties) {
        HashMap<String, String> buildArgs = new HashMap<String, String>();
        for (Object keyObj : properties.keySet()) {
            String key = (String)keyObj;
            if (!key.startsWith(ARG_PREFIX)) continue;
            String argKey = key.replaceFirst(ARG_PREFIX, "");
            String value = properties.getProperty(key);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            buildArgs.put(argKey, value);
        }
        return buildArgs;
    }

    private static Map<String, String> buildArgsFromDockerConfig() {
        Map proxies;
        Map<String, Object> dockerConfig = DockerFileUtil.readDockerConfig();
        if (dockerConfig == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> buildArgs = new HashMap<String, String>();
        if (dockerConfig.containsKey("proxies") && (proxies = (Map)dockerConfig.get("proxies")).containsKey("default")) {
            Map defaultProxyObj = (Map)proxies.get("default");
            String[] proxyMapping = new String[]{"httpProxy", "http_proxy", "httpsProxy", "https_proxy", "noProxy", "no_proxy", "ftpProxy", "ftp_proxy"};
            for (int index = 0; index < proxyMapping.length; index += 2) {
                if (!defaultProxyObj.containsKey(proxyMapping[index])) continue;
                buildArgs.put(ARG_PREFIX + proxyMapping[index + 1], (String)defaultProxyObj.get(proxyMapping[index]));
            }
        }
        return buildArgs;
    }
}

