/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.api.auth.handler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jkube.kit.build.api.auth.AuthConfig;
import org.eclipse.jkube.kit.build.api.auth.RegistryAuthConfig;
import org.eclipse.jkube.kit.build.api.auth.RegistryAuthHandler;
import org.eclipse.jkube.kit.common.KitLogger;
import org.yaml.snakeyaml.Yaml;

public class OpenShiftRegistryAuthHandler
implements RegistryAuthHandler {
    public static final String AUTH_USE_OPENSHIFT_AUTH = "useOpenShiftAuth";
    private final RegistryAuthConfig registryAuthConfig;
    private final KitLogger log;

    public OpenShiftRegistryAuthHandler(RegistryAuthConfig registryAuthConfig, KitLogger log) {
        this.registryAuthConfig = registryAuthConfig;
        this.log = log;
    }

    @Override
    public String getId() {
        return "openshift";
    }

    @Override
    public AuthConfig create(RegistryAuthConfig.Kind kind, String user, String registry, UnaryOperator<String> decryptor) {
        Properties props = System.getProperties();
        String useOpenAuthMode = this.registryAuthConfig.extractFromProperties(props, kind, AUTH_USE_OPENSHIFT_AUTH);
        if (useOpenAuthMode != null) {
            boolean useOpenShift = Boolean.parseBoolean(useOpenAuthMode);
            if (!useOpenShift) {
                return null;
            }
            this.log.debug("AuthConfig: OpenShift credentials", new Object[0]);
            return this.validateMandatoryOpenShiftLogin(this.parseOpenShiftConfig());
        }
        boolean useOpenShiftAuth = Optional.ofNullable(this.registryAuthConfig.getConfigForHandler(this.getId(), AUTH_USE_OPENSHIFT_AUTH)).map(Boolean::parseBoolean).orElse(false);
        if (useOpenShiftAuth) {
            this.log.debug("AuthConfig: OpenShift credentials", new Object[0]);
            return this.validateMandatoryOpenShiftLogin(this.parseOpenShiftConfig());
        }
        return null;
    }

    private AuthConfig validateMandatoryOpenShiftLogin(AuthConfig openShiftRegistryAuth) {
        if (openShiftRegistryAuth != null) {
            return openShiftRegistryAuth;
        }
        String kubeConfigEnv = System.getenv("KUBECONFIG");
        throw new IllegalArgumentException(String.format("OpenShift auth check enabled, but not active user and/or token found in %s. Please use 'oc login' for connecting to OpenShift.", kubeConfigEnv != null ? kubeConfigEnv : "~/.kube/config"));
    }

    private AuthConfig parseOpenShiftConfig() {
        Map<String, ?> kubeConfig = this.readKubeConfig();
        if (kubeConfig == null) {
            return null;
        }
        String currentContextName = (String)kubeConfig.get("current-context");
        if (currentContextName == null) {
            return null;
        }
        for (Map contextMap : (List)kubeConfig.get("contexts")) {
            if (!currentContextName.equals(contextMap.get("name"))) continue;
            return this.parseContext(kubeConfig, (Map)contextMap.get("context"));
        }
        return null;
    }

    private Map<String, ?> readKubeConfig() {
        String kubeConfig = System.getenv("KUBECONFIG");
        Optional<Reader> reader = this.getFileReaderFromDir(kubeConfig == null ? new File(this.getHomeDir(), ".kube/config") : new File(kubeConfig));
        return reader.map(r -> new Yaml().load(r)).orElse(null);
    }

    private Optional<Reader> getFileReaderFromDir(File file) {
        try {
            return Optional.of(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            return Optional.empty();
        }
    }

    private File getHomeDir() {
        String homeDir = System.getProperty("user.home") != null ? System.getProperty("user.home") : System.getenv("HOME");
        return new File(homeDir);
    }

    private AuthConfig parseContext(Map kubeConfig, Map context) {
        if (context == null) {
            return null;
        }
        String userName = (String)context.get("user");
        if (userName == null) {
            return null;
        }
        List users = (List)kubeConfig.get("users");
        if (users == null) {
            return null;
        }
        for (Map userMap : users) {
            if (!userName.equals(userMap.get("name"))) continue;
            return this.parseUser(userName, (Map)userMap.get("user"));
        }
        return null;
    }

    private AuthConfig parseUser(String userName, Map user) {
        if (user == null) {
            return null;
        }
        String token = (String)user.get("token");
        if (token == null) {
            return null;
        }
        Matcher matcher = Pattern.compile("^([^/]+).*$").matcher(userName);
        return AuthConfig.builder().username(matcher.matches() ? matcher.group(1) : userName).password(token).build();
    }
}

