/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.api.helper;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.build.api.helper.JKubeDockerfileInterpolator;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;
import org.yaml.snakeyaml.Yaml;

public class DockerFileUtil {
    private static final String ARG_PATTERN_REGEX = "\\$(?:\\{(.*)\\}|(.*))";
    private static final Pattern argPattern = Pattern.compile("\\$(?:\\{(.*)\\}|(.*))");

    private DockerFileUtil() {
    }

    public static List<String> extractBaseImages(File dockerFile, Properties properties, String filter, Map<String, String> argsFromBuildConfig) throws IOException {
        List<String[]> fromLines = DockerFileUtil.extractLines(dockerFile, "FROM", properties, DockerFileUtil.resolveDockerfileFilter(filter));
        Map<String, String> args = DockerFileUtil.extractArgs(dockerFile, properties, filter, argsFromBuildConfig);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        HashSet<String> fromAlias = new HashSet<String>();
        for (String[] fromLine : fromLines) {
            if (fromLine.length == 2) {
                result.add(DockerFileUtil.resolveImageTagFromArgs(fromLine[1], args));
                continue;
            }
            if (fromLine.length != 4) continue;
            if (!fromAlias.contains(fromLine[1])) {
                result.add(DockerFileUtil.resolveImageTagFromArgs(fromLine[1], args));
            }
            fromAlias.add(DockerFileUtil.resolveImageTagFromArgs(fromLine[3], args));
        }
        return new ArrayList<String>(result);
    }

    public static Map<String, String> extractArgs(File dockerfile, Properties properties, String filter, Map<String, String> argsFromBuildConfig) throws IOException {
        return DockerFileUtil.extractArgsFromLines(DockerFileUtil.extractLines(dockerfile, "ARG", properties, filter), argsFromBuildConfig);
    }

    public static List<String[]> extractLines(File dockerFile, String keyword, Properties properties, String filter) throws IOException {
        ArrayList<String[]> ret = new ArrayList<String[]>();
        try (BufferedReader reader = new BufferedReader(new FileReader(dockerFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                String lineInterpolated = JKubeDockerfileInterpolator.interpolate(line, properties, filter);
                String[] lineParts = lineInterpolated.split("\\s+");
                if (lineParts.length <= 0 || !lineParts[0].equalsIgnoreCase(keyword)) continue;
                ret.add(lineParts);
            }
        }
        return ret;
    }

    public static String interpolate(File dockerFile, Properties properties, String filter) throws IOException {
        StringBuilder ret = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(dockerFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                ret.append(JKubeDockerfileInterpolator.interpolate(line, properties, DockerFileUtil.resolveDockerfileFilter(filter))).append(System.lineSeparator());
            }
        }
        return ret.toString();
    }

    private static Reader getFileReaderFromDir(File file) {
        if (file.exists() && file.length() != 0L) {
            try {
                return new FileReader(file);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Cannot find " + file, e);
            }
        }
        return null;
    }

    protected static Map<String, String> extractArgsFromLines(List<String[]> argLines, Map<String, String> argsFromBuildConfig) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String[] argLine : argLines) {
            if (argLine.length <= 1) continue;
            DockerFileUtil.updateMapWithArgValue(result, argsFromBuildConfig, argLine[1]);
        }
        return result;
    }

    private static String resolveImageTagFromArgs(String imageTagString, Map<String, String> args) {
        if (imageTagString.startsWith("$")) {
            String resolvedVal = DockerFileUtil.resolveArgValueFromStrContainingArgKey(imageTagString, args);
            if (resolvedVal != null) {
                return resolvedVal;
            }
        } else {
            String tag;
            String[] imageTagArr = imageTagString.split(":");
            if (imageTagArr.length > 1 && (tag = DockerFileUtil.resolveArgValueFromStrContainingArgKey(imageTagArr[1], args)) != null) {
                return imageTagArr[0] + ":" + tag;
            }
        }
        return imageTagString;
    }

    static String resolveArgValueFromStrContainingArgKey(String argString, Map<String, String> args) {
        Matcher matcher = argPattern.matcher(argString);
        if (matcher.matches()) {
            if (matcher.group(1) != null) {
                return args.get(matcher.group(1));
            }
            if (matcher.group(2) != null) {
                return args.get(matcher.group(2));
            }
        }
        return null;
    }

    public static JsonObject readDockerConfig() {
        String dockerConfig = System.getenv("DOCKER_CONFIG");
        Reader reader = dockerConfig == null ? DockerFileUtil.getFileReaderFromDir(new File(DockerFileUtil.getHomeDir(), ".docker/config.json")) : DockerFileUtil.getFileReaderFromDir(new File(dockerConfig, "config.json"));
        return reader != null ? (JsonObject)new Gson().fromJson(reader, JsonObject.class) : null;
    }

    public static String[] extractDelimiters(String filter) {
        Matcher matcher;
        if (filter == null || filter.equalsIgnoreCase("false") || filter.equalsIgnoreCase("none")) {
            return new String[0];
        }
        if (filter.contains("*") && (matcher = Pattern.compile("^(?<start>[^*]+)\\*(?<end>.*)$").matcher(filter)).matches()) {
            return new String[]{matcher.group("start"), matcher.group("end")};
        }
        return new String[]{filter, filter};
    }

    public static Map<String, ?> readKubeConfig() {
        Reader reader;
        String kubeConfig = System.getenv("KUBECONFIG");
        Reader reader2 = reader = kubeConfig == null ? DockerFileUtil.getFileReaderFromDir(new File(DockerFileUtil.getHomeDir(), ".kube/config")) : DockerFileUtil.getFileReaderFromDir(new File(kubeConfig));
        if (reader != null) {
            Yaml ret = new Yaml();
            return (Map)ret.load(reader);
        }
        return null;
    }

    public static boolean isSimpleDockerFileMode(File projectBaseDirectory) {
        if (projectBaseDirectory != null) {
            return DockerFileUtil.getTopLevelDockerfile(projectBaseDirectory).exists();
        }
        return false;
    }

    public static File getTopLevelDockerfile(File projectBaseDirectory) {
        return new File(projectBaseDirectory, "Dockerfile");
    }

    public static ImageConfiguration createSimpleDockerfileConfig(File dockerFile, String defaultImageName) {
        if (defaultImageName == null) {
            defaultImageName = "%g/%a:%l";
        }
        BuildConfiguration buildConfig = BuildConfiguration.builder().dockerFile(dockerFile.getPath()).ports(DockerFileUtil.extractPorts(dockerFile)).build();
        return ImageConfiguration.builder().name(defaultImageName).build(buildConfig).build();
    }

    public static ImageConfiguration addSimpleDockerfileConfig(ImageConfiguration image, File dockerfile) {
        BuildConfiguration buildConfig = BuildConfiguration.builder().dockerFile(dockerfile.getPath()).ports(DockerFileUtil.extractPorts(dockerfile)).build();
        return image.toBuilder().build(buildConfig).build();
    }

    private static File getHomeDir() {
        String homeDir = System.getProperty("user.home");
        if (homeDir == null) {
            homeDir = System.getenv("HOME");
        }
        return new File(homeDir);
    }

    private static void updateMapWithArgValue(Map<String, String> result, Map<String, String> args, String argString) {
        if (argString.contains("=") || argString.contains(":")) {
            String[] argStringParts = argString.split("[=:]");
            String argStringValue = argString.substring(argStringParts[0].length() + 1);
            if (argStringValue.startsWith("\"") || argStringValue.startsWith("'")) {
                argStringValue = DockerFileUtil.trimSurroundingQuotes(argStringValue);
            } else {
                DockerFileUtil.validateArgValue(argStringValue);
            }
            result.put(argStringParts[0], argStringValue);
        } else {
            DockerFileUtil.validateArgValue(argString);
            result.putAll(DockerFileUtil.fetchArgsFromBuildConfiguration(argString, args));
        }
    }

    private static Map<String, String> fetchArgsFromBuildConfiguration(String argString, Map<String, String> args) {
        HashMap<String, String> argFromBuildConfig = new HashMap<String, String>();
        if (args != null) {
            argFromBuildConfig.put(argString, args.getOrDefault(argString, ""));
        }
        return argFromBuildConfig;
    }

    private static void validateArgValue(String argStringParam) {
        String[] argStringParts = argStringParam.split("\\s+");
        if (argStringParts.length > 1) {
            throw new IllegalArgumentException("Dockerfile parse error: ARG requires exactly one argument. Provided : " + argStringParam);
        }
    }

    private static String trimSurroundingQuotes(String argStringValue) {
        if (argStringValue.startsWith("\"") && argStringValue.endsWith("\"") || argStringValue.startsWith("'") && argStringValue.endsWith("'")) {
            return argStringValue.substring(1, argStringValue.length() - 1);
        }
        return argStringValue;
    }

    static List<String> extractPorts(File dockerFile) {
        Properties properties = new Properties();
        try {
            return DockerFileUtil.extractPorts(DockerFileUtil.extractLines(dockerFile, "EXPOSE", properties, null));
        }
        catch (IOException ioException) {
            throw new IllegalArgumentException("Error in reading Dockerfile", ioException);
        }
    }

    static List<String> extractPorts(List<String[]> dockerLinesContainingExpose) {
        HashSet ports = new HashSet();
        dockerLinesContainingExpose.forEach(line -> Arrays.stream(line).skip(1L).filter(Objects::nonNull).filter(StringUtils::isNotBlank).forEach(ports::add));
        return new ArrayList<String>(ports);
    }

    static String resolveDockerfileFilter(String filter) {
        return filter != null ? filter : "${*}";
    }
}

