/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.service.buildpacks.controller;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.config.image.ImageName;
import org.eclipse.jkube.kit.service.buildpacks.BuildPackBuildOptions;
import org.eclipse.jkube.kit.service.buildpacks.BuildPackCommand;
import org.eclipse.jkube.kit.service.buildpacks.controller.BuildPackController;

public class BuildPackCliController
implements BuildPackController {
    private final File pack;
    private final KitLogger kitLogger;

    public BuildPackCliController(File binaryFile, KitLogger kitLogger) {
        this.pack = binaryFile;
        this.kitLogger = kitLogger;
    }

    @Override
    public void build(BuildPackBuildOptions buildOptions) {
        BuildPackCommand buildPackCommand = new BuildPackCommand(this.kitLogger, this.pack, this.createBuildCommandArguments(buildOptions), l -> this.kitLogger.info("[[s]]%s", new Object[]{l}));
        try {
            buildPackCommand.execute();
        }
        catch (IOException e) {
            throw new IllegalStateException("Process Existed With : " + buildPackCommand.getExitCode() + " [" + e.getMessage() + "]", e);
        }
    }

    @Override
    public String version() {
        AtomicReference versionRef = new AtomicReference();
        BuildPackCommand versionCommand = new BuildPackCommand(this.kitLogger, this.pack, Collections.singletonList("--version"), versionRef::set);
        try {
            versionCommand.execute();
        }
        catch (IOException e) {
            this.kitLogger.warn(e.getMessage(), new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)versionRef.get()))) {
            return (String)versionRef.get();
        }
        return null;
    }

    private List<String> createBuildCommandArguments(BuildPackBuildOptions buildOptions) {
        ArrayList<String> buildArgs = new ArrayList<String>();
        buildArgs.add("build");
        buildArgs.add(buildOptions.getImageName());
        buildArgs.addAll(Arrays.asList("--builder", buildOptions.getBuilderImage()));
        buildArgs.addAll(Arrays.asList("--creation-time", buildOptions.getCreationTime()));
        buildArgs.addAll(this.extractStringArg("--pull-policy", buildOptions.getImagePullPolicy()));
        buildArgs.addAll(this.extractRepeatedArgsForListElements("--volume", buildOptions.getVolumes()));
        if (buildOptions.getTags() != null && !buildOptions.getTags().isEmpty()) {
            ImageName specifiedImageName = new ImageName(buildOptions.getImageName());
            List<String> imageNameWithAdditionalTags = buildOptions.getTags().stream().map(t -> specifiedImageName.getNameWithoutTag() + ":" + t).collect(Collectors.toList());
            buildArgs.addAll(this.extractRepeatedArgsForListElements("--tag", imageNameWithAdditionalTags));
        }
        if (buildOptions.getEnv() != null) {
            List<String> keyValueEntryList = buildOptions.getEnv().entrySet().stream().map(this::getSingleEnvArg).collect(Collectors.toList());
            buildArgs.addAll(this.extractRepeatedArgsForListElements("--env", keyValueEntryList));
        }
        if (buildOptions.isClearCache()) {
            buildArgs.add("--clear-cache");
        }
        buildArgs.addAll(Arrays.asList("--path", buildOptions.getPath()));
        return buildArgs;
    }

    private List<String> extractRepeatedArgsForListElements(String flag, List<String> flagValues) {
        ArrayList<String> args = new ArrayList<String>();
        if (flagValues != null && !flagValues.isEmpty()) {
            flagValues.forEach(v -> args.addAll(this.extractStringArg(flag, (String)v)));
        }
        return args;
    }

    private List<String> extractStringArg(String flag, String flagValue) {
        ArrayList<String> args = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)flagValue)) {
            args.add(flag);
            args.add(flagValue);
        }
        return args;
    }

    private String getSingleEnvArg(Map.Entry<String, String> e) {
        String entryKeyValue = e.getKey();
        if (StringUtils.isNotBlank((CharSequence)e.getValue())) {
            entryKeyValue = entryKeyValue + "=" + e.getValue();
        }
        return entryKeyValue;
    }
}

