/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.access.log;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import org.eclipse.jkube.kit.build.service.docker.helper.Timestamp;
import org.fusesource.jansi.Ansi;

public class LogOutputSpec {
    public static final LogOutputSpec DEFAULT = new LogOutputSpec("", Ansi.Color.YELLOW, false, null, null, true, true);
    private static final String DEFAULT_TIMESTAMP_PATTERN = "HH:mm:ss.SSS";
    private final boolean useColor;
    private final boolean logStdout;
    private final boolean fgBright;
    private String prefix;
    private Ansi.Color color;
    private DateTimeFormatter timeFormatter;
    private String file;
    private static final Ansi.Color[] COLOR_PALETTE = new Ansi.Color[]{Ansi.Color.YELLOW, Ansi.Color.CYAN, Ansi.Color.MAGENTA, Ansi.Color.GREEN, Ansi.Color.RED, Ansi.Color.BLUE};
    private static int globalColorIdx = 0;

    private LogOutputSpec(String prefix, Ansi.Color color, boolean fgBright, DateTimeFormatter timeFormatter, String file, boolean useColor, boolean logStdout) {
        this.prefix = prefix;
        this.color = color;
        this.fgBright = fgBright;
        this.timeFormatter = timeFormatter;
        this.file = file;
        this.useColor = useColor;
        this.logStdout = logStdout;
    }

    public boolean isUseColor() {
        return this.useColor && (this.getFile() == null || this.isLogStdout());
    }

    public String getPrompt(boolean withColor, Timestamp timestamp) {
        return this.formatTimestamp(timestamp, withColor) + this.formatPrefix(this.prefix, withColor);
    }

    private String formatTimestamp(Timestamp timestamp, boolean withColor) {
        if (this.timeFormatter == null) {
            return "";
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DEFAULT_TIMESTAMP_PATTERN);
        LocalDateTime localDateTime = LocalDateTime.from(formatter.parse(timestamp.toString()));
        return (withColor ? Ansi.ansi().fgBright(Ansi.Color.BLACK).a((Object)localDateTime).reset().toString() : localDateTime) + " ";
    }

    private String formatPrefix(String prefix, boolean withColor) {
        if (withColor) {
            Ansi ansi = Ansi.ansi();
            if (this.fgBright) {
                ansi.fgBright(this.color);
            } else {
                ansi.fg(this.color);
            }
            return ansi.a(prefix).reset().toString();
        }
        return prefix;
    }

    public static LogOutputSpecBuilder builder() {
        return new LogOutputSpecBuilder();
    }

    public LogOutputSpecBuilder toBuilder() {
        return new LogOutputSpecBuilder().prefix(this.prefix).color(this.color).fgBright(this.fgBright).timeFormatter(this.timeFormatter).file(this.file).useColor(this.useColor).logStdout(this.logStdout);
    }

    public boolean isLogStdout() {
        return this.logStdout;
    }

    public boolean isFgBright() {
        return this.fgBright;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Ansi.Color getColor() {
        return this.color;
    }

    public DateTimeFormatter getTimeFormatter() {
        return this.timeFormatter;
    }

    public String getFile() {
        return this.file;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogOutputSpec)) {
            return false;
        }
        LogOutputSpec other = (LogOutputSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseColor() != other.isUseColor()) {
            return false;
        }
        if (this.isLogStdout() != other.isLogStdout()) {
            return false;
        }
        if (this.isFgBright() != other.isFgBright()) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        Ansi.Color this$color = this.getColor();
        Ansi.Color other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        DateTimeFormatter this$timeFormatter = this.getTimeFormatter();
        DateTimeFormatter other$timeFormatter = other.getTimeFormatter();
        if (this$timeFormatter == null ? other$timeFormatter != null : !this$timeFormatter.equals(other$timeFormatter)) {
            return false;
        }
        String this$file = this.getFile();
        String other$file = other.getFile();
        return !(this$file == null ? other$file != null : !this$file.equals(other$file));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LogOutputSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseColor() ? 79 : 97);
        result = result * 59 + (this.isLogStdout() ? 79 : 97);
        result = result * 59 + (this.isFgBright() ? 79 : 97);
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        Ansi.Color $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        DateTimeFormatter $timeFormatter = this.getTimeFormatter();
        result = result * 59 + ($timeFormatter == null ? 43 : $timeFormatter.hashCode());
        String $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        return result;
    }

    public static class LogOutputSpecBuilder {
        private String prefix;
        private Ansi.Color color;
        private boolean fgBright;
        private DateTimeFormatter timeFormatter;
        private String file;
        private boolean useColor;
        private boolean logStdout;

        public LogOutputSpecBuilder colorString(String color) {
            return this.colorString(color, false);
        }

        public LogOutputSpecBuilder colorString(String color, boolean fgBright) {
            if (color == null) {
                this.color = COLOR_PALETTE[globalColorIdx++ % COLOR_PALETTE.length];
            } else {
                try {
                    this.color = Ansi.Color.valueOf((String)color.toUpperCase());
                    this.fgBright = fgBright;
                }
                catch (IllegalArgumentException exp) {
                    throw new IllegalArgumentException("Invalid color '" + color + "'. Color must be one of YELLOW, CYAN, MAGENTA, GREEN, RED, BLUE or BLACK");
                }
            }
            return this;
        }

        public LogOutputSpecBuilder timeFormatterString(String formatOrConstant) {
            if (formatOrConstant == null || formatOrConstant.equalsIgnoreCase("NONE") || formatOrConstant.equalsIgnoreCase("FALSE")) {
                this.timeFormatter = null;
            } else if (formatOrConstant.length() == 0 || formatOrConstant.equalsIgnoreCase("DEFAULT")) {
                this.timeFormatter = DateTimeFormatter.ofPattern(LogOutputSpec.DEFAULT_TIMESTAMP_PATTERN);
            } else if (formatOrConstant.equalsIgnoreCase("ISO8601")) {
                this.timeFormatter = DateTimeFormatter.ISO_DATE_TIME;
            } else if (formatOrConstant.equalsIgnoreCase("SHORT")) {
                this.timeFormatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT);
            } else if (formatOrConstant.equalsIgnoreCase("MEDIUM")) {
                this.timeFormatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM);
            } else if (formatOrConstant.equalsIgnoreCase("LONG")) {
                this.timeFormatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG);
            } else if (formatOrConstant.equalsIgnoreCase("FULL")) {
                this.timeFormatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL);
            } else {
                try {
                    this.timeFormatter = DateTimeFormatter.ofPattern(formatOrConstant);
                }
                catch (IllegalArgumentException exp) {
                    throw new IllegalArgumentException("Cannot parse log date specification '" + formatOrConstant + "'.Must be either DEFAULT, NONE, ISO8601, SHORT, MEDIUM, LONG, FULL or a format string parseable by DateTimeFormat. See https://docs.oracle.com/javase/8/docs/api/java/time/format/DateTimeFormatter.html");
                }
            }
            return this;
        }

        LogOutputSpecBuilder() {
        }

        public LogOutputSpecBuilder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public LogOutputSpecBuilder color(Ansi.Color color) {
            this.color = color;
            return this;
        }

        public LogOutputSpecBuilder fgBright(boolean fgBright) {
            this.fgBright = fgBright;
            return this;
        }

        public LogOutputSpecBuilder timeFormatter(DateTimeFormatter timeFormatter) {
            this.timeFormatter = timeFormatter;
            return this;
        }

        public LogOutputSpecBuilder file(String file) {
            this.file = file;
            return this;
        }

        public LogOutputSpecBuilder useColor(boolean useColor) {
            this.useColor = useColor;
            return this;
        }

        public LogOutputSpecBuilder logStdout(boolean logStdout) {
            this.logStdout = logStdout;
            return this;
        }

        public LogOutputSpec build() {
            return new LogOutputSpec(this.prefix, this.color, this.fgBright, this.timeFormatter, this.file, this.useColor, this.logStdout);
        }

        public String toString() {
            return "LogOutputSpec.LogOutputSpecBuilder(prefix=" + this.prefix + ", color=" + this.color + ", fgBright=" + this.fgBright + ", timeFormatter=" + this.timeFormatter + ", file=" + this.file + ", useColor=" + this.useColor + ", logStdout=" + this.logStdout + ")";
        }
    }
}

