/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.access.hc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.eclipse.jkube.kit.build.api.auth.AuthConfig;
import org.eclipse.jkube.kit.build.api.model.Container;
import org.eclipse.jkube.kit.build.api.model.ContainerDetails;
import org.eclipse.jkube.kit.build.api.model.ContainersListElement;
import org.eclipse.jkube.kit.build.api.model.ExecDetails;
import org.eclipse.jkube.kit.build.api.model.Network;
import org.eclipse.jkube.kit.build.api.model.NetworkCreateConfig;
import org.eclipse.jkube.kit.build.api.model.NetworksListElement;
import org.eclipse.jkube.kit.build.api.model.VolumeCreateConfig;
import org.eclipse.jkube.kit.build.service.docker.access.BuildOptions;
import org.eclipse.jkube.kit.build.service.docker.access.ContainerCreateConfig;
import org.eclipse.jkube.kit.build.service.docker.access.CreateImageOptions;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccess;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccessException;
import org.eclipse.jkube.kit.build.service.docker.access.UrlBuilder;
import org.eclipse.jkube.kit.build.service.docker.access.chunked.BuildJsonResponseHandler;
import org.eclipse.jkube.kit.build.service.docker.access.chunked.PullOrPushResponseJsonHandler;
import org.eclipse.jkube.kit.build.service.docker.access.hc.ApacheHttpClientDelegate;
import org.eclipse.jkube.kit.build.service.docker.access.hc.HcChunkedResponseHandlerWrapper;
import org.eclipse.jkube.kit.build.service.docker.access.hc.http.HttpClientBuilder;
import org.eclipse.jkube.kit.build.service.docker.access.hc.unix.UnixSocketClientBuilder;
import org.eclipse.jkube.kit.build.service.docker.access.hc.util.ClientBuilder;
import org.eclipse.jkube.kit.build.service.docker.access.hc.win.NamedPipeClientBuilder;
import org.eclipse.jkube.kit.build.service.docker.access.log.DefaultLogCallback;
import org.eclipse.jkube.kit.build.service.docker.access.log.LogCallback;
import org.eclipse.jkube.kit.build.service.docker.access.log.LogGetHandle;
import org.eclipse.jkube.kit.build.service.docker.access.log.LogOutputSpec;
import org.eclipse.jkube.kit.build.service.docker.access.log.LogRequestor;
import org.eclipse.jkube.kit.build.service.docker.helper.Timestamp;
import org.eclipse.jkube.kit.common.Arguments;
import org.eclipse.jkube.kit.common.JsonFactory;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.archive.ArchiveCompression;
import org.eclipse.jkube.kit.common.util.EnvUtil;
import org.eclipse.jkube.kit.config.image.ImageName;

public class DockerAccessWithHcClient
implements DockerAccess {
    private static final String UNIX_URL = "unix://127.0.0.1:1/";
    private static final String NPIPE_URL = "npipe://127.0.0.1:1/";
    public static final String API_VERSION = "1.18";
    private final KitLogger log;
    private final ApacheHttpClientDelegate delegate;
    private final UrlBuilder urlBuilder;

    public DockerAccessWithHcClient(String baseUrl, String certPath, int maxConnections, KitLogger log) throws IOException {
        URI uri = URI.create(Objects.requireNonNull(baseUrl, "Docker daemon baseUrl is required"));
        if (uri.getScheme() == null) {
            throw new IllegalArgumentException("The docker access url '" + baseUrl + "' must contain a schema tcp://, unix:// or npipe://");
        }
        if (uri.getScheme().equalsIgnoreCase("unix")) {
            this.delegate = this.createHttpClient(new UnixSocketClientBuilder(uri.getPath(), maxConnections, log));
            baseUrl = UNIX_URL;
        } else if (uri.getScheme().equalsIgnoreCase("npipe")) {
            this.delegate = this.createHttpClient(new NamedPipeClientBuilder(uri.getPath(), maxConnections, log), false);
            baseUrl = NPIPE_URL;
        } else {
            this.delegate = this.createHttpClient(new HttpClientBuilder(DockerAccessWithHcClient.isSSL(baseUrl) ? certPath : null, maxConnections));
        }
        while (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        this.urlBuilder = new UrlBuilder(baseUrl, "v" + this.fetchApiVersionFromServer(baseUrl, this.delegate));
        this.log = log;
    }

    @Override
    public String getServerApiVersion() throws DockerAccessException {
        try {
            String url = this.urlBuilder.version();
            String response = this.delegate.get(url, 200);
            JsonObject info = JsonFactory.newJsonObject((String)response);
            return info.get("ApiVersion").getAsString();
        }
        catch (Exception e) {
            throw new DockerAccessException(e, "Cannot extract API version from server %s", this.urlBuilder.getBaseUrl());
        }
    }

    @Override
    public void startExecContainer(String containerId, LogOutputSpec outputSpec) throws DockerAccessException {
        try {
            String url = this.urlBuilder.startExecContainer(containerId);
            JsonObject request = new JsonObject();
            request.addProperty("Detach", Boolean.valueOf(false));
            request.addProperty("Tty", Boolean.valueOf(true));
            this.delegate.post(url, (Object)request.toString(), this.createExecResponseHandler(outputSpec), 200);
        }
        catch (Exception e) {
            throw new DockerAccessException(e, "Unable to start container id [%s]", containerId);
        }
    }

    private ResponseHandler<Object> createExecResponseHandler(LogOutputSpec outputSpec) {
        DefaultLogCallback callback = new DefaultLogCallback(outputSpec);
        return response -> {
            try (InputStream stream = response.getEntity().getContent();
                 LineNumberReader reader = new LineNumberReader(new InputStreamReader(stream));){
                try {
                    String line;
                    callback.open();
                    while ((line = reader.readLine()) != null) {
                        callback.log(1, new Timestamp(), line);
                    }
                    callback.close();
                    return null;
                }
                catch (LogCallback.DoneException doneException) {
                    return null;
                }
                finally {
                    callback.close();
                }
            }
        };
    }

    @Override
    public String createExecContainer(String containerId, Arguments arguments) throws DockerAccessException {
        String url = this.urlBuilder.createExecContainer(containerId);
        JsonObject request = new JsonObject();
        request.addProperty("Tty", Boolean.valueOf(true));
        request.addProperty("AttachStdin", Boolean.valueOf(false));
        request.addProperty("AttachStdout", Boolean.valueOf(true));
        request.addProperty("AttachStderr", Boolean.valueOf(true));
        request.add("Cmd", (JsonElement)JsonFactory.newJsonArray((List)arguments.getExec()));
        String execJsonRequest = request.toString();
        try {
            String response = this.delegate.post(url, (Object)execJsonRequest, new ApacheHttpClientDelegate.BodyResponseHandler(), 201);
            JsonObject json = JsonFactory.newJsonObject((String)response);
            if (json.has("Warnings")) {
                this.logWarnings(json);
            }
            return json.get("Id").getAsString();
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to exec [%s] on container [%s]", request.toString(), containerId);
        }
    }

    @Override
    public String createContainer(ContainerCreateConfig containerConfig, String containerName) throws DockerAccessException {
        String createJson = containerConfig.toJson();
        this.log.debug("Container create config: %s", new Object[]{createJson});
        try {
            String url = this.urlBuilder.createContainer(containerName);
            String response = this.delegate.post(url, (Object)createJson, new ApacheHttpClientDelegate.BodyResponseHandler(), 201);
            JsonObject json = JsonFactory.newJsonObject((String)response);
            this.logWarnings(json);
            return json.get("Id").getAsString().substring(0, 12);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to create container for [%s]", containerConfig.getImageName());
        }
    }

    @Override
    public void startContainer(String containerId) throws DockerAccessException {
        try {
            String url = this.urlBuilder.startContainer(containerId);
            this.delegate.post(url, 204, 200);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to start container id [%s]", containerId);
        }
    }

    @Override
    public void stopContainer(String containerId, int killWait) throws DockerAccessException {
        try {
            String url = this.urlBuilder.stopContainer(containerId, killWait);
            this.delegate.post(url, 204, 304);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to stop container id [%s]", containerId);
        }
    }

    @Override
    public void buildImage(String image, File dockerArchive, BuildOptions options) throws DockerAccessException {
        try {
            String url = this.urlBuilder.buildImage(image, options);
            this.delegate.post(url, (Object)dockerArchive, this.createBuildResponseHandler(), 200);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to build image [%s]", image);
        }
    }

    @Override
    public void copyArchive(String containerId, File archive, String targetPath) throws DockerAccessException {
        try {
            String url = this.urlBuilder.copyArchive(containerId, targetPath);
            this.delegate.put(url, archive, 200);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to copy archive %s to container [%s] with path %s", archive.toPath(), containerId, targetPath);
        }
    }

    @Override
    public void getLogSync(String containerId, LogCallback callback) {
        LogRequestor extractor = new LogRequestor(this.delegate.getHttpClient(), this.urlBuilder, containerId, callback);
        extractor.fetchLogs();
    }

    @Override
    public LogGetHandle getLogAsync(String containerId, LogCallback callback) {
        LogRequestor extractor = new LogRequestor(this.delegate.createBasicClient(), this.urlBuilder, containerId, callback);
        extractor.start();
        return extractor;
    }

    @Override
    public List<Container> getContainersForImage(String image, boolean all) throws DockerAccessException {
        String serverApiVersion = this.getServerApiVersion();
        String url = EnvUtil.greaterOrEqualsVersion((String)serverApiVersion, (String)"1.23") ? this.urlBuilder.listContainers(all, "ancestor", image) : this.urlBuilder.listContainers(all, new String[0]);
        try {
            String response = this.delegate.get(url, 200);
            JsonArray array = JsonFactory.newJsonArray((String)response);
            ArrayList<Container> containers = new ArrayList<Container>();
            for (int i = 0; i < array.size(); ++i) {
                JsonObject element = array.get(i).getAsJsonObject();
                if (!image.equals(element.get("Image").getAsString())) continue;
                containers.add((Container)new ContainersListElement(element));
            }
            return containers;
        }
        catch (IOException e) {
            throw new DockerAccessException(e.getMessage());
        }
    }

    @Override
    public ContainerDetails getContainer(String containerIdOrName) throws DockerAccessException {
        ApacheHttpClientDelegate.HttpBodyAndStatus response = this.inspectContainer(containerIdOrName);
        if (response.getStatusCode() == 404) {
            return null;
        }
        return new ContainerDetails(JsonFactory.newJsonObject((String)response.getBody()));
    }

    @Override
    public ExecDetails getExecContainer(String containerIdOrName) throws DockerAccessException {
        ApacheHttpClientDelegate.HttpBodyAndStatus response = this.inspectExecContainer(containerIdOrName);
        if (response.getStatusCode() == 404) {
            return null;
        }
        return new ExecDetails(JsonFactory.newJsonObject((String)response.getBody()));
    }

    private ApacheHttpClientDelegate.HttpBodyAndStatus inspectContainer(String containerIdOrName) throws DockerAccessException {
        try {
            String url = this.urlBuilder.inspectContainer(containerIdOrName);
            return this.delegate.get(url, new ApacheHttpClientDelegate.BodyAndStatusResponseHandler(), 200, 404);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to retrieve container name for [%s]", containerIdOrName);
        }
    }

    private ApacheHttpClientDelegate.HttpBodyAndStatus inspectExecContainer(String containerIdOrName) throws DockerAccessException {
        try {
            String url = this.urlBuilder.inspectExecContainer(containerIdOrName);
            return this.delegate.get(url, new ApacheHttpClientDelegate.BodyAndStatusResponseHandler(), 200, 404);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to retrieve container name for [%s]", containerIdOrName);
        }
    }

    @Override
    public boolean hasImage(String name) throws DockerAccessException {
        String url = this.urlBuilder.inspectImage(name);
        try {
            return this.delegate.get(url, new ApacheHttpClientDelegate.StatusCodeResponseHandler(), 200, 404) == 200;
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to check image [%s]", name);
        }
    }

    @Override
    public String getImageId(String name) throws DockerAccessException {
        ApacheHttpClientDelegate.HttpBodyAndStatus response = this.inspectImage(name);
        if (response.getStatusCode() == 404) {
            return null;
        }
        JsonObject imageDetails = JsonFactory.newJsonObject((String)response.getBody());
        return imageDetails.get("Id").getAsString().substring(0, 12);
    }

    private ApacheHttpClientDelegate.HttpBodyAndStatus inspectImage(String name) throws DockerAccessException {
        String url = this.urlBuilder.inspectImage(name);
        try {
            return this.delegate.get(url, new ApacheHttpClientDelegate.BodyAndStatusResponseHandler(), 200, 404);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to inspect image [%s]", name);
        }
    }

    @Override
    public void removeContainer(String containerId, boolean removeVolumes) throws DockerAccessException {
        try {
            String url = this.urlBuilder.removeContainer(containerId, removeVolumes);
            this.delegate.delete(url, 204);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to remove container [%s]", containerId);
        }
    }

    @Override
    public void loadImage(String image, File tarArchive) throws DockerAccessException {
        String url = this.urlBuilder.loadImage();
        try {
            this.delegate.post(url, (Object)tarArchive, new ApacheHttpClientDelegate.BodyAndStatusResponseHandler(), 200);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to load %s", tarArchive);
        }
    }

    @Override
    public void pullImage(String image, AuthConfig authConfig, String registry, CreateImageOptions options) throws DockerAccessException {
        String pullUrl = this.urlBuilder.pullImage(options);
        try {
            this.delegate.post(pullUrl, null, this.createAuthHeader(authConfig), this.createPullOrPushResponseHandler(), 200);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to pull '%s'%s", image, registry != null ? " from registry '" + registry + "'" : "");
        }
    }

    @Override
    public void pushImage(String image, AuthConfig authConfig, String registry, int retries) throws DockerAccessException {
        ImageName name = new ImageName(image);
        String pushUrl = this.urlBuilder.pushImage(name, registry);
        TemporaryImageHandler temporaryImageHandler = this.tagTemporaryImage(name, registry);
        DockerAccessException dae = null;
        try {
            this.doPushImage(pushUrl, this.createAuthHeader(authConfig), this.createPullOrPushResponseHandler(), 200, retries);
        }
        catch (IOException e) {
            dae = new DockerAccessException(e, "Unable to push '%s'%s", image, registry != null ? " to registry '" + registry + "'" : "");
            throw dae;
        }
        finally {
            temporaryImageHandler.handle(dae);
        }
    }

    @Override
    public void saveImage(String image, String filename, ArchiveCompression compression) throws DockerAccessException {
        ImageName name = new ImageName(image);
        String url = this.urlBuilder.getImage(name);
        try {
            this.delegate.get(url, this.getImageResponseHandler(filename, compression), 200);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to save '%s' to '%s'", image, filename);
        }
    }

    private ResponseHandler<Object> getImageResponseHandler(String filename, ArchiveCompression compression) {
        return response -> {
            try (InputStream stream = response.getEntity().getContent();
                 OutputStream out = compression.wrapOutputStream((OutputStream)new FileOutputStream(filename));){
                IOUtils.copy((InputStream)stream, (OutputStream)out, (int)65536);
            }
            return null;
        };
    }

    @Override
    public void tag(String sourceImage, String targetImage, boolean force) throws DockerAccessException {
        ImageName source = new ImageName(sourceImage);
        ImageName target = new ImageName(targetImage);
        try {
            String url = this.urlBuilder.tagContainer(source, target, force);
            this.delegate.post(url, 201);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to add tag [%s] to image [%s]", targetImage, sourceImage, e);
        }
    }

    @Override
    public boolean removeImage(String image, boolean ... forceOpt) throws DockerAccessException {
        boolean force = forceOpt != null && forceOpt.length > 0 && forceOpt[0];
        try {
            String url = this.urlBuilder.deleteImage(image, force);
            ApacheHttpClientDelegate.HttpBodyAndStatus response = this.delegate.delete(url, new ApacheHttpClientDelegate.BodyAndStatusResponseHandler(), 200, 404);
            if (this.log.isDebugEnabled()) {
                this.logRemoveResponse(JsonFactory.newJsonArray((String)response.getBody()));
            }
            return response.getStatusCode() == 200;
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to remove image [%s]", image);
        }
    }

    @Override
    public List<Network> listNetworks() throws DockerAccessException {
        String url = this.urlBuilder.listNetworks();
        try {
            String response = this.delegate.get(url, 200);
            JsonArray array = JsonFactory.newJsonArray((String)response);
            ArrayList<Network> networks = new ArrayList<Network>(array.size());
            for (int i = 0; i < array.size(); ++i) {
                networks.add((Network)new NetworksListElement(array.get(i).getAsJsonObject()));
            }
            return networks;
        }
        catch (IOException e) {
            throw new DockerAccessException(e.getMessage());
        }
    }

    @Override
    public String createNetwork(NetworkCreateConfig networkConfig) throws DockerAccessException {
        String createJson = networkConfig.toJson();
        this.log.debug("Network create config: " + createJson, new Object[0]);
        try {
            String url = this.urlBuilder.createNetwork();
            String response = this.delegate.post(url, (Object)createJson, new ApacheHttpClientDelegate.BodyResponseHandler(), 201);
            this.log.debug(response, new Object[0]);
            JsonObject json = JsonFactory.newJsonObject((String)response);
            if (json.has("Warnings")) {
                this.logWarnings(json);
            }
            return json.get("Id").getAsString().substring(0, 12);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to create network for [%s]", networkConfig.getName());
        }
    }

    @Override
    public boolean removeNetwork(String networkId) throws DockerAccessException {
        try {
            String url = this.urlBuilder.removeNetwork(networkId);
            int status = this.delegate.delete(url, 200, 204, 404);
            return status == 200 || status == 204;
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to remove network [%s]", networkId);
        }
    }

    @Override
    public String createVolume(VolumeCreateConfig containerConfig) throws DockerAccessException {
        String createJson = containerConfig.toJson();
        this.log.debug("Volume create config: %s", new Object[]{createJson});
        try {
            String url = this.urlBuilder.createVolume();
            String response = this.delegate.post(url, (Object)createJson, new ApacheHttpClientDelegate.BodyResponseHandler(), 201);
            JsonObject json = JsonFactory.newJsonObject((String)response);
            this.logWarnings(json);
            return json.get("Name").getAsString();
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to create volume for [%s]", containerConfig.getName());
        }
    }

    @Override
    public void removeVolume(String name) throws DockerAccessException {
        try {
            String url = this.urlBuilder.removeVolume(name);
            this.delegate.delete(url, 204, 404);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to remove volume [%s]", name);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void shutdown() {
        try {
            this.delegate.close();
        }
        catch (IOException exp) {
            this.log.error("Error while closing HTTP client: " + exp, new Object[]{exp});
        }
    }

    ApacheHttpClientDelegate createHttpClient(ClientBuilder builder) throws IOException {
        return this.createHttpClient(builder, true);
    }

    ApacheHttpClientDelegate createHttpClient(ClientBuilder builder, boolean pooled) throws IOException {
        return new ApacheHttpClientDelegate(builder, pooled);
    }

    private HcChunkedResponseHandlerWrapper createBuildResponseHandler() {
        return new HcChunkedResponseHandlerWrapper(new BuildJsonResponseHandler(this.log));
    }

    private HcChunkedResponseHandlerWrapper createPullOrPushResponseHandler() {
        return new HcChunkedResponseHandlerWrapper(new PullOrPushResponseJsonHandler(this.log));
    }

    private Map<String, String> createAuthHeader(AuthConfig authConfig) {
        if (authConfig == null) {
            authConfig = AuthConfig.EMPTY_AUTH_CONFIG;
        }
        return Collections.singletonMap("X-Registry-Auth", authConfig.toHeaderValue(this.log));
    }

    private boolean isRetryableErrorCode(int errorCode) {
        return errorCode == 500;
    }

    private void doPushImage(String url, Map<String, String> header, HcChunkedResponseHandlerWrapper handler, int status, int retries) throws IOException {
        for (int i = 0; i <= retries; ++i) {
            try {
                this.delegate.post(url, null, header, handler, 200);
                return;
            }
            catch (HttpResponseException e) {
                if (!this.isRetryableErrorCode(e.getStatusCode()) || i == retries) {
                    throw e;
                }
                this.log.warn("failed to push image to [{}], retrying...", new Object[]{url});
                continue;
            }
        }
    }

    private TemporaryImageHandler tagTemporaryImage(ImageName name, String registry) throws DockerAccessException {
        String targetImage = name.getFullName(registry);
        if (name.hasRegistry() || registry == null) {
            return () -> this.log.info("Temporary image tag skipped. Target image '%s' already has registry set or no registry is available", new Object[]{targetImage});
        }
        String fullName = name.getFullName();
        boolean alreadyHasImage = this.hasImage(targetImage);
        if (alreadyHasImage) {
            this.log.warn("Target image '%s' already exists. Tagging of '%s' will replace existing image", new Object[]{targetImage, fullName});
        }
        this.tag(fullName, targetImage, false);
        return alreadyHasImage ? () -> this.log.info("Tagged image '%s' won't be removed after tagging as it already existed", new Object[]{targetImage}) : new RemovingTemporaryImageHandler(targetImage);
    }

    private void logWarnings(JsonObject body) {
        JsonElement warningsObj;
        if (body.has("Warnings") && !(warningsObj = body.get("Warnings")).isJsonNull()) {
            JsonArray warnings = (JsonArray)warningsObj;
            for (int i = 0; i < warnings.size(); ++i) {
                this.log.warn(warnings.get(i).getAsString(), new Object[0]);
            }
        }
    }

    private void logRemoveResponse(JsonArray logElements) {
        for (int i = 0; i < logElements.size(); ++i) {
            JsonObject entry = logElements.get(i).getAsJsonObject();
            for (Object key : entry.keySet()) {
                this.log.debug("%s: %s", new Object[]{key, entry.get(key.toString())});
            }
        }
    }

    private static boolean isSSL(String url) {
        return url != null && url.toLowerCase().startsWith("https");
    }

    public String fetchApiVersionFromServer(String baseUrl, ApacheHttpClientDelegate delegate) throws IOException {
        HttpGet get = new HttpGet(baseUrl + (baseUrl.endsWith("/") ? "" : "/") + "version");
        get.addHeader("Accept", "*/*");
        get.addHeader("Content-Type", "application/json");
        try (CloseableHttpResponse response = delegate.getHttpClient().execute((HttpUriRequest)get);){
            String string = response.getFirstHeader("Api-Version") != null ? response.getFirstHeader("Api-Version").getValue() : API_VERSION;
            return string;
        }
    }

    private final class RemovingTemporaryImageHandler
    implements TemporaryImageHandler {
        private final String targetImage;

        private RemovingTemporaryImageHandler(String targetImage) {
            this.targetImage = targetImage;
        }

        @Override
        public void handle() throws DockerAccessException {
            boolean imageRemoved = DockerAccessWithHcClient.this.removeImage(this.targetImage, true);
            if (imageRemoved) {
                return;
            }
            throw new DockerAccessException("Image %s could be pushed, but the temporary tag could not be removed", this.targetImage);
        }
    }

    @FunctionalInterface
    private static interface TemporaryImageHandler {
        public void handle() throws DockerAccessException;

        default public void handle(DockerAccessException interruptingError) throws DockerAccessException {
            this.handle();
            if (interruptingError == null) {
                return;
            }
            throw interruptingError;
        }
    }
}

