/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.access;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jkube.kit.build.service.docker.helper.LocalSocketUtil;
import org.eclipse.jkube.kit.build.service.docker.helper.SuffixFileFilter;
import org.eclipse.jkube.kit.common.util.EnvUtil;

public class DockerConnectionDetector {
    final List<DockerHostProvider> dockerHostProviders = new ArrayList<DockerHostProvider>();

    public DockerConnectionDetector(List<DockerHostProvider> externalProviders) {
        this.dockerHostProviders.addAll(this.getDefaultEnvProviders());
        if (externalProviders != null) {
            this.dockerHostProviders.addAll(externalProviders);
        }
        this.dockerHostProviders.sort(new DockerHostProvider.Comparator());
    }

    private Collection<? extends DockerHostProvider> getDefaultEnvProviders() {
        return Arrays.asList(new EnvDockerHostProvider(), new UnixSocketDockerHostProvider(), new WindowsPipeDockerHostProvider());
    }

    public ConnectionParameter detectConnectionParameter(String dockerHost, String certPath) throws IOException {
        if (dockerHost != null) {
            return new ConnectionParameter(dockerHost, certPath);
        }
        for (DockerHostProvider provider : this.dockerHostProviders) {
            ConnectionParameter value = provider.getConnectionParameter(certPath);
            if (value == null) continue;
            return value;
        }
        throw new IllegalArgumentException("No <dockerHost> given, no DOCKER_HOST environment variable, no read/writable '/var/run/docker.sock' or '//./pipe/docker_engine' and no external provider like Docker machine configured");
    }

    public static class ConnectionParameter {
        private final String url;
        private String certPath;

        public ConnectionParameter(String url, String certPath) throws IOException {
            this.url = url != null ? EnvUtil.convertTcpToHttpUrl((String)url) : null;
            this.initCertPath(certPath);
        }

        public String getUrl() {
            return this.url;
        }

        public String getCertPath() {
            return this.certPath;
        }

        private void initCertPath(String certPath) throws IOException {
            File dockerHome;
            String string = this.certPath = certPath != null ? certPath : System.getenv("DOCKER_CERT_PATH");
            if (this.certPath == null && (dockerHome = new File(System.getProperty("user.home") + "/.docker")).isDirectory()) {
                String[] entries = dockerHome.list(SuffixFileFilter.PEM_FILTER);
                if (entries == null) {
                    throw new IOException("Can not read directory " + dockerHome + ". Please check file permissions.");
                }
                if (entries.length > 0) {
                    this.certPath = dockerHome.getAbsolutePath();
                }
            }
        }
    }

    class WindowsPipeDockerHostProvider
    implements DockerHostProvider {
        WindowsPipeDockerHostProvider() {
        }

        @Override
        public ConnectionParameter getConnectionParameter(String certPath) throws IOException {
            File windowsPipe = new File("//./pipe/docker_engine");
            if (windowsPipe.exists()) {
                return new ConnectionParameter("npipe:////./pipe/docker_engine", certPath);
            }
            return null;
        }

        @Override
        public int getPriority() {
            return 50;
        }
    }

    class UnixSocketDockerHostProvider
    implements DockerHostProvider {
        UnixSocketDockerHostProvider() {
        }

        @Override
        public ConnectionParameter getConnectionParameter(String certPath) throws IOException {
            String filePath = "/var/run/docker.sock";
            File unixSocket = new File(filePath);
            if (unixSocket.exists() && unixSocket.canRead() && unixSocket.canWrite() && LocalSocketUtil.canConnectUnixSocket(unixSocket)) {
                return new ConnectionParameter("unix://" + filePath, certPath);
            }
            return null;
        }

        @Override
        public int getPriority() {
            return 55;
        }
    }

    class EnvDockerHostProvider
    implements DockerHostProvider {
        EnvDockerHostProvider() {
        }

        @Override
        public ConnectionParameter getConnectionParameter(String certPath) throws IOException {
            String connect = System.getenv("DOCKER_HOST");
            return connect != null ? new ConnectionParameter(connect, certPath) : null;
        }

        @Override
        public int getPriority() {
            return 100;
        }
    }

    public static interface DockerHostProvider {
        public ConnectionParameter getConnectionParameter(String var1) throws IOException;

        public int getPriority();

        public static class Comparator
        implements java.util.Comparator<DockerHostProvider> {
            @Override
            public int compare(DockerHostProvider o1, DockerHostProvider o2) {
                return o2.getPriority() - o1.getPriority();
            }
        }
    }
}

