/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.helper;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.eclipse.jkube.kit.build.api.helper.DockerFileUtil;
import org.eclipse.jkube.kit.build.service.docker.config.handler.ImageConfigResolver;
import org.eclipse.jkube.kit.build.service.docker.config.handler.property.PropertyConfigHandler;
import org.eclipse.jkube.kit.build.service.docker.config.handler.property.PropertyMode;
import org.eclipse.jkube.kit.build.service.docker.helper.ImageNameFormatter;
import org.eclipse.jkube.kit.common.JKubeConfiguration;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.PropertiesUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;

public class ConfigHelper {
    public static final String EXTERNALCONFIG_ACTIVATION_PROPERTY = "docker.imagePropertyConfiguration";

    private ConfigHelper() {
    }

    private static List<ImageConfiguration> resolveImages(KitLogger logger, List<ImageConfiguration> images, Resolver imageResolver, String imageNameFilter, Customizer imageCustomizer) {
        List<ImageConfiguration> ret = ConfigHelper.resolveConfiguration(imageResolver, images);
        ret = imageCustomizer.customizeConfig(ret);
        List<ImageConfiguration> filtered = ConfigHelper.filterImages(imageNameFilter, ret);
        if (!ret.isEmpty() && filtered.isEmpty() && imageNameFilter != null) {
            List imageNames = ret.stream().map(ImageConfiguration::getName).collect(Collectors.toList());
            logger.warn("None of the resolved images [%s] match the configured filter '%s'", new Object[]{String.join((CharSequence)",", imageNames), imageNameFilter});
        }
        return filtered;
    }

    public static void validateExternalPropertyActivation(JavaProject project, List<ImageConfiguration> images) {
        String prop = ConfigHelper.getExternalConfigActivationProperty(project);
        if (prop == null) {
            return;
        }
        if (images.size() == 1) {
            return;
        }
        int imagesWithoutExternalConfig = 0;
        for (ImageConfiguration image : images) {
            if (PropertyConfigHandler.canCoexistWithOtherPropertyConfiguredImages(image.getExternalConfig())) continue;
            ++imagesWithoutExternalConfig;
        }
        if (imagesWithoutExternalConfig > 1) {
            throw new IllegalStateException("Configuration error: Cannot use property docker.imagePropertyConfiguration on projects with multiple images without explicit image external configuration.");
        }
    }

    public static String getExternalConfigActivationProperty(JavaProject project) {
        Properties properties = JKubeProjectUtil.getPropertiesWithSystemOverrides((JavaProject)project);
        String value = properties.getProperty(EXTERNALCONFIG_ACTIVATION_PROPERTY);
        if (PropertyMode.Skip.name().equalsIgnoreCase(value)) {
            return null;
        }
        return value;
    }

    public static boolean matchesConfiguredImages(String imageList, ImageConfiguration imageConfig) {
        if (imageList == null) {
            return true;
        }
        HashSet<String> imagesAllowed = new HashSet<String>(Arrays.asList(imageList.split("\\s*,\\s*")));
        return imagesAllowed.contains(imageConfig.getName()) || imagesAllowed.contains(imageConfig.getAlias());
    }

    private static List<ImageConfiguration> filterImages(String nameFilter, List<ImageConfiguration> imagesToFilter) {
        ArrayList<ImageConfiguration> ret = new ArrayList<ImageConfiguration>();
        for (ImageConfiguration imageConfig : imagesToFilter) {
            if (!ConfigHelper.matchesConfiguredImages(nameFilter, imageConfig)) continue;
            ret.add(imageConfig);
        }
        return ret;
    }

    private static List<ImageConfiguration> resolveConfiguration(Resolver imageResolver, List<ImageConfiguration> unresolvedImages) {
        ArrayList<ImageConfiguration> ret = new ArrayList<ImageConfiguration>();
        if (unresolvedImages != null) {
            for (ImageConfiguration image : unresolvedImages) {
                ret.addAll(imageResolver.resolve(image));
            }
            ConfigHelper.verifyImageNames(ret);
        }
        return ret;
    }

    private static void verifyImageNames(List<ImageConfiguration> ret) {
        for (ImageConfiguration config : ret) {
            if (config.getName() != null) continue;
            throw new IllegalArgumentException("Configuration error: <image> must have a non-null <name>");
        }
    }

    public static List<ImageConfiguration> initImageConfiguration(Date buildTimeStamp, List<ImageConfiguration> unresolvedImages, ImageConfigResolver imageConfigResolver, KitLogger log, String filter, Customizer customizer, JKubeConfiguration jKubeConfiguration) {
        ImageNameFormatter imageNameFormatter = new ImageNameFormatter(jKubeConfiguration.getProject(), buildTimeStamp);
        List<ImageConfiguration> resolvedImages = ConfigHelper.resolveImages(log, unresolvedImages, image -> imageConfigResolver.resolve(image, jKubeConfiguration.getProject()), filter, customizer);
        ImageConfiguration dockerFileImageConfig = ConfigHelper.createImageConfigurationForSimpleDockerfile(resolvedImages, jKubeConfiguration, imageNameFormatter);
        if (dockerFileImageConfig != null) {
            if (resolvedImages.isEmpty()) {
                resolvedImages.add(dockerFileImageConfig);
            } else {
                resolvedImages.set(0, dockerFileImageConfig);
            }
        }
        for (ImageConfiguration imageConfiguration : resolvedImages) {
            imageConfiguration.setName(imageNameFormatter.format(imageConfiguration.getName()));
            if (imageConfiguration.getBuild() != null) {
                imageConfiguration.getBuild().initAndValidate();
            }
            if (imageConfiguration.getRun() != null) {
                imageConfiguration.getRun().initAndValidate();
            }
            ConfigHelper.printDockerfileInfoIfDockerfileMode(imageConfiguration, log, jKubeConfiguration);
        }
        return resolvedImages;
    }

    private static ImageConfiguration createImageConfigurationForSimpleDockerfile(List<ImageConfiguration> resolvedImages, JKubeConfiguration jKubeConfiguration, ImageNameFormatter imageNameFormatter) {
        if (DockerFileUtil.isSimpleDockerFileMode((File)jKubeConfiguration.getBasedir())) {
            File topDockerfile = DockerFileUtil.getTopLevelDockerfile((File)jKubeConfiguration.getBasedir());
            String defaultImageName = imageNameFormatter.format(PropertiesUtil.getValueFromProperties((Properties)jKubeConfiguration.getProject().getProperties(), (String[])new String[]{"jkube.image.name", "jkube.generator.name"}));
            if (resolvedImages.isEmpty()) {
                return DockerFileUtil.createSimpleDockerfileConfig((File)topDockerfile, (String)defaultImageName);
            }
            if (resolvedImages.size() == 1 && resolvedImages.get(0).getBuildConfiguration() == null) {
                return DockerFileUtil.addSimpleDockerfileConfig((ImageConfiguration)resolvedImages.get(0), (File)topDockerfile);
            }
        }
        return null;
    }

    private static void printDockerfileInfoIfDockerfileMode(ImageConfiguration imageConfiguration, KitLogger log, JKubeConfiguration jKubeConfiguration) {
        BuildConfiguration buildConfiguration = imageConfiguration.getBuildConfiguration();
        if (buildConfiguration != null && buildConfiguration.isDockerFileMode()) {
            log.info("Using Dockerfile: %s", new Object[]{buildConfiguration.getDockerFile().getAbsolutePath()});
            log.info("Using Docker Context Directory: %s", new Object[]{buildConfiguration.getAbsoluteContextDirPath(jKubeConfiguration.getSourceDirectory(), jKubeConfiguration.getBasedir().getAbsolutePath())});
        }
    }

    public static interface NameFormatter {
        public String format(String var1);
    }

    private static interface Resolver {
        public List<ImageConfiguration> resolve(ImageConfiguration var1);
    }

    public static interface Customizer {
        public List<ImageConfiguration> customizeConfig(List<ImageConfiguration> var1);
    }
}

