/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker;

import java.io.IOException;
import org.eclipse.jkube.kit.build.api.auth.AuthConfig;
import org.eclipse.jkube.kit.build.api.helper.RegistryUtil;
import org.eclipse.jkube.kit.build.service.docker.ImagePullManager;
import org.eclipse.jkube.kit.build.service.docker.QueryService;
import org.eclipse.jkube.kit.build.service.docker.access.CreateImageOptions;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccess;
import org.eclipse.jkube.kit.build.service.docker.auth.AuthConfigFactory;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.RegistryConfig;
import org.eclipse.jkube.kit.common.util.EnvUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.ImageName;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;
import org.eclipse.jkube.kit.config.image.build.ImagePullPolicy;

public class RegistryService {
    private final DockerAccess docker;
    private final QueryService queryService;
    private final KitLogger log;

    RegistryService(DockerAccess docker, QueryService queryService, KitLogger log) {
        this.docker = docker;
        this.queryService = queryService;
        this.log = log;
    }

    public void pushImage(ImageConfiguration imageConfig, int retries, RegistryConfig registryConfig, boolean skipTag) throws IOException {
        BuildConfiguration buildConfig = imageConfig.getBuildConfiguration();
        String name = imageConfig.getName();
        if (buildConfig != null) {
            String configuredRegistry = RegistryUtil.getApplicablePushRegistryFrom((ImageConfiguration)imageConfig, (RegistryConfig)registryConfig);
            AuthConfig authConfig = this.createAuthConfig(true, new ImageName(name).inferUser(), configuredRegistry, registryConfig);
            long start = System.currentTimeMillis();
            this.docker.pushImage(name, authConfig, configuredRegistry, retries);
            this.log.info("Pushed %s in %s", new Object[]{name, EnvUtil.formatDurationTill((long)start)});
            if (!skipTag) {
                for (String tag : imageConfig.getBuildConfiguration().getTags()) {
                    if (tag == null) continue;
                    this.docker.pushImage(new ImageName(name, tag).getFullName(), authConfig, configuredRegistry, retries);
                }
            }
        }
    }

    public void pullImageWithPolicy(String image, ImagePullManager pullManager, RegistryConfig registryConfig, BuildConfiguration buildConfiguration) throws IOException {
        if (pullManager.hasAlreadyPulled(image)) {
            return;
        }
        if (!this.imageRequiresPull(this.queryService.hasImage(image), pullManager.getImagePullPolicy(), image)) {
            return;
        }
        ImageName imageName = new ImageName(image);
        long pullStartTime = System.currentTimeMillis();
        String actualRegistry = RegistryUtil.getApplicablePullRegistryFrom((String)image, (RegistryConfig)registryConfig);
        CreateImageOptions createImageOptions = new CreateImageOptions(buildConfiguration.getCreateImageOptions()).fromImage(imageName.getNameWithoutTag(actualRegistry)).tag(imageName.getDigest() != null ? imageName.getDigest() : imageName.getTag());
        this.docker.pullImage(imageName.getFullName(), this.createAuthConfig(false, null, actualRegistry, registryConfig), actualRegistry, createImageOptions);
        this.log.info("Pulled %s in %s", new Object[]{imageName.getFullName(), EnvUtil.formatDurationTill((long)pullStartTime)});
        pullManager.pulled(image);
        if (actualRegistry != null && !imageName.hasRegistry()) {
            this.docker.tag(imageName.getFullName(actualRegistry), image, false);
        }
    }

    private boolean imageRequiresPull(boolean hasImage, ImagePullPolicy pullPolicy, String imageName) throws IOException {
        if (pullPolicy == ImagePullPolicy.Never) {
            if (!hasImage) {
                throw new IOException(String.format("No image '%s' found and pull policy 'Never' is set. Please chose another pull policy or pull the image yourself)", imageName));
            }
            return false;
        }
        if (!hasImage) {
            return true;
        }
        return pullPolicy == ImagePullPolicy.Always;
    }

    private AuthConfig createAuthConfig(boolean isPush, String user, String registry, RegistryConfig config) throws IOException {
        return new AuthConfigFactory(this.log).createAuthConfig(isPush, config.isSkipExtendedAuth(), config.getAuthConfig(), config.getSettings(), user, registry, config.getPasswordDecryptionMethod());
    }
}

