/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.build.api.assembly.AssemblyFiles;
import org.eclipse.jkube.kit.build.service.docker.ArchiveService;
import org.eclipse.jkube.kit.build.service.docker.BuildService;
import org.eclipse.jkube.kit.build.service.docker.watch.CopyFilesTask;
import org.eclipse.jkube.kit.build.service.docker.watch.ExecTask;
import org.eclipse.jkube.kit.build.service.docker.watch.WatchContext;
import org.eclipse.jkube.kit.build.service.docker.watch.WatchException;
import org.eclipse.jkube.kit.common.JKubeConfiguration;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.WatchImageConfiguration;
import org.eclipse.jkube.kit.config.image.WatchMode;

public class WatchService {
    private final ArchiveService archiveService;
    private final BuildService buildService;
    private final KitLogger log;

    public WatchService(ArchiveService archiveService, BuildService buildService, KitLogger log) {
        this.archiveService = archiveService;
        this.buildService = buildService;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void watch(WatchContext context, List<ImageConfiguration> images) throws IOException {
        ScheduledExecutorService executor = null;
        try {
            executor = Executors.newSingleThreadScheduledExecutor();
            for (ImageConfiguration imageConfig : images) {
                ImageWatcher watcher = new ImageWatcher(imageConfig, context);
                long interval = watcher.getInterval();
                WatchMode watchMode = watcher.getWatchMode(imageConfig);
                this.log.info("Watching %s %s", new Object[]{imageConfig.getName(), watchMode != null ? " using " + watchMode.getDescription() : ""});
                ArrayList<String> tasks = new ArrayList<String>();
                if (imageConfig.getBuildConfiguration() != null && imageConfig.getBuildConfiguration().getAssembly() != null) {
                    if (watcher.isCopy()) {
                        this.schedule(executor, this.createCopyWatchTask(watcher, context.getBuildContext()), interval);
                        tasks.add("copying artifacts");
                    }
                    if (watcher.isBuild()) {
                        this.schedule(executor, this.createBuildWatchTask(watcher, context.getBuildContext()), interval);
                        tasks.add("rebuilding");
                    }
                }
                if (tasks.isEmpty()) continue;
                this.log.info("%s: Watch for %s", new Object[]{imageConfig.getDescription(), String.join((CharSequence)" and ", tasks)});
            }
            this.log.info("Waiting ...", new Object[0]);
            this.wait();
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted", new Object[0]);
            Thread.currentThread().interrupt();
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
        }
    }

    private void schedule(ScheduledExecutorService executor, Runnable runnable, long interval) {
        executor.scheduleAtFixedRate(runnable, 0L, interval, TimeUnit.MILLISECONDS);
    }

    private Runnable createCopyWatchTask(ImageWatcher watcher, JKubeConfiguration jKubeConfiguration) throws IOException {
        ImageConfiguration imageConfig = watcher.getImageConfiguration();
        AssemblyFiles files = this.archiveService.getAssemblyFiles(imageConfig, jKubeConfiguration);
        return () -> {
            List entries = files.getUpdatedEntriesAndRefresh();
            if (!entries.isEmpty()) {
                try {
                    this.log.info("%s: Assembly changed. Copying changed files to container...", new Object[]{imageConfig.getDescription()});
                    File changedFilesArchive = this.archiveService.createChangedFilesArchive(entries, files.getAssemblyDirectory(), imageConfig.getName(), jKubeConfiguration);
                    this.copyFilesToContainer(changedFilesArchive, watcher);
                    this.callPostExec(watcher);
                }
                catch (IOException | WatchException e) {
                    this.log.error("%s: Error when copying files: %s", new Object[]{imageConfig.getDescription(), e.getMessage()});
                }
            }
        };
    }

    private void copyFilesToContainer(File changedFilesArchive, ImageWatcher watcher) throws IOException, WatchException {
        CopyFilesTask cft = watcher.getWatchContext().getContainerCopyTask();
        if (cft != null) {
            cft.copy(changedFilesArchive);
            this.log.info("Files successfully copied to the container.", new Object[0]);
        } else {
            this.log.warn("No copy task found for copy mode. Ignoring...", new Object[0]);
        }
    }

    void callPostExec(ImageWatcher watcher) throws IOException, WatchException {
        ExecTask execTask = watcher.getWatchContext().getContainerCommandExecutor();
        if (StringUtils.isNotBlank((CharSequence)watcher.getPostExec()) && execTask != null) {
            this.log.info("jkube.watch.postExec: %n%s", new Object[]{execTask.exec(watcher.getPostExec())});
        }
    }

    Runnable createBuildWatchTask(ImageWatcher watcher, JKubeConfiguration jKubeConfiguration) throws IOException {
        ImageConfiguration imageConfig = watcher.getImageConfiguration();
        AssemblyFiles files = this.archiveService.getAssemblyFiles(imageConfig, jKubeConfiguration);
        if (files.isEmpty()) {
            this.log.error("No assembly files for %s. Are you sure you invoked together with the `package` goal?", new Object[]{imageConfig.getDescription()});
            throw new IOException("No files to watch found for " + imageConfig);
        }
        return () -> {
            List entries = files.getUpdatedEntriesAndRefresh();
            if (entries != null && !entries.isEmpty()) {
                try {
                    this.log.info("%s: Assembly changed. Rebuild ...", new Object[]{imageConfig.getDescription()});
                    if (watcher.getWatchContext().getImageCustomizer() != null) {
                        this.log.info("%s: Customizing the image ...", new Object[]{imageConfig.getDescription()});
                        watcher.getWatchContext().getImageCustomizer().execute(imageConfig);
                    }
                    this.buildService.buildImage(imageConfig, null, jKubeConfiguration);
                    if (watcher.isRun()) {
                        watcher.getWatchContext().getContainerRestarter().execute(watcher);
                    }
                    Optional.ofNullable(watcher.getWatchContext().getPostGoalTask()).ifPresent(Runnable::run);
                }
                catch (Exception e) {
                    this.log.error("%s: Error when rebuilding - %s", new Object[]{imageConfig.getDescription(), e});
                }
            }
        };
    }

    public static class ImageWatcher {
        private final ImageConfiguration imageConfig;
        private final WatchContext watchContext;
        private final WatchMode mode;
        private final long interval;
        private final String postGoal;
        private final String postExec;

        public ImageWatcher(ImageConfiguration imageConfig, WatchContext watchContext) {
            this.imageConfig = imageConfig;
            this.watchContext = watchContext;
            this.interval = this.getWatchInterval(imageConfig);
            this.mode = this.getWatchMode(imageConfig);
            this.postGoal = this.getPostGoal(imageConfig);
            this.postExec = this.getPostExec(imageConfig);
        }

        public long getInterval() {
            return this.interval;
        }

        public String getPostGoal() {
            return this.postGoal;
        }

        public boolean isCopy() {
            return this.mode.isCopy();
        }

        public boolean isBuild() {
            return this.mode.isBuild();
        }

        public boolean isRun() {
            return this.mode.isRun();
        }

        public ImageConfiguration getImageConfiguration() {
            return this.imageConfig;
        }

        public String getImageName() {
            return this.imageConfig.getName();
        }

        public String getPostExec() {
            return this.postExec;
        }

        public WatchContext getWatchContext() {
            return this.watchContext;
        }

        private int getWatchInterval(ImageConfiguration imageConfig) {
            WatchImageConfiguration watchConfig = imageConfig.getWatchConfiguration();
            int applicableInterval = watchConfig != null ? watchConfig.getInterval() : this.watchContext.getWatchInterval();
            return Math.max(applicableInterval, 100);
        }

        private String getPostExec(ImageConfiguration imageConfig) {
            WatchImageConfiguration watchConfig = imageConfig.getWatchConfiguration();
            return watchConfig != null && watchConfig.getPostExec() != null ? watchConfig.getPostExec() : this.watchContext.getWatchPostExec();
        }

        private String getPostGoal(ImageConfiguration imageConfig) {
            WatchImageConfiguration watchConfig = imageConfig.getWatchConfiguration();
            return watchConfig != null && watchConfig.getPostGoal() != null ? watchConfig.getPostGoal() : null;
        }

        private WatchMode getWatchMode(ImageConfiguration imageConfig) {
            WatchImageConfiguration watchConfig = imageConfig.getWatchConfiguration();
            WatchMode watchMode = watchConfig != null ? watchConfig.getMode() : null;
            return watchMode != null ? watchMode : this.watchContext.getWatchMode();
        }
    }
}

