/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.helper;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.build.api.model.Container;
import org.eclipse.jkube.kit.build.api.model.PortMapping;
import org.eclipse.jkube.kit.build.core.GavLabel;
import org.eclipse.jkube.kit.build.service.docker.ServiceHub;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccessException;
import org.eclipse.jkube.kit.build.service.docker.access.ExecException;
import org.eclipse.jkube.kit.build.service.docker.access.log.LogDispatcher;
import org.eclipse.jkube.kit.build.service.docker.access.log.LogOutputSpecFactory;
import org.eclipse.jkube.kit.build.service.docker.helper.ConfigHelper;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.LogConfiguration;
import org.eclipse.jkube.kit.config.image.RunImageConfiguration;
import org.eclipse.jkube.kit.config.image.WaitConfiguration;

public class StartContainerExecutor {
    private String exposeContainerProps;
    private KitLogger log;
    private LogOutputSpecFactory logOutputSpecFactory;
    private ServiceHub hub;
    private boolean follow;
    private String showLogs;
    private String containerNamePattern;
    private Date buildDate;
    private Properties projectProperties;
    private File basedir;
    private ImageConfiguration imageConfig;
    private GavLabel gavLabel;
    private PortMapping portMapping;
    private LogDispatcher dispatcher;

    public String startContainers() throws IOException, ExecException {
        Properties projProperties = this.projectProperties;
        String containerId = this.hub.getRunService().createAndStartContainer(this.imageConfig, this.portMapping, this.gavLabel, projProperties, this.basedir, this.containerNamePattern, this.buildDate);
        this.showLogsIfRequested(containerId);
        this.exposeContainerProps(containerId);
        this.waitAndPostExec(containerId, projProperties);
        return containerId;
    }

    private void exposeContainerProps(String containerId) throws DockerAccessException {
        String propKey = this.getExposedPropertyKeyPart();
        if (StringUtils.isNotEmpty((CharSequence)this.exposeContainerProps) && StringUtils.isNotEmpty((CharSequence)propKey)) {
            Map nets;
            Container container = this.hub.getQueryService().getMandatoryContainer(containerId);
            String prefix = this.addDot(this.exposeContainerProps) + this.addDot(propKey);
            this.projectProperties.put(prefix + "id", containerId);
            String ip = container.getIPAddress();
            if (StringUtils.isNotEmpty((CharSequence)ip)) {
                this.projectProperties.put(prefix + "ip", ip);
            }
            if ((nets = container.getCustomNetworkIpAddresses()) != null) {
                for (Map.Entry entry : nets.entrySet()) {
                    this.projectProperties.put(prefix + this.addDot("net") + this.addDot((String)entry.getKey()) + "ip", entry.getValue());
                }
            }
        }
    }

    String getExposedPropertyKeyPart() {
        String propKey;
        String string = propKey = this.imageConfig.getRunConfiguration() != null ? this.imageConfig.getRunConfiguration().getExposedPropertyKey() : "";
        if (StringUtils.isEmpty((CharSequence)propKey)) {
            propKey = this.imageConfig.getAlias();
        }
        return propKey;
    }

    private String addDot(String part) {
        return part.endsWith(".") ? part : part + ".";
    }

    private void showLogsIfRequested(String containerId) {
        if (this.showLogs()) {
            this.dispatcher.trackContainerLog(containerId, this.logOutputSpecFactory.createSpec(containerId, this.imageConfig));
        }
    }

    private void waitAndPostExec(String containerId, Properties projProperties) throws IOException, ExecException {
        this.hub.getWaitService().wait(this.imageConfig, projProperties, containerId);
        WaitConfiguration waitConfig = this.imageConfig.getRunConfiguration().getWait();
        if (waitConfig != null && waitConfig.getExec() != null && waitConfig.getExec().getPostStart() != null) {
            try {
                this.hub.getRunService().execInContainer(containerId, waitConfig.getExec().getPostStart(), this.imageConfig);
            }
            catch (ExecException exp) {
                if (waitConfig.getExec().isBreakOnError()) {
                    throw exp;
                }
                this.log.warn("Cannot run postStart: %s", new Object[]{exp.getMessage()});
            }
        }
    }

    boolean showLogs() {
        if (StringUtils.isNotBlank((CharSequence)this.showLogs)) {
            if (this.showLogs.equalsIgnoreCase("true")) {
                return true;
            }
            if (this.showLogs.equalsIgnoreCase("false")) {
                return false;
            }
            return ConfigHelper.matchesConfiguredImages(this.showLogs, this.imageConfig);
        }
        RunImageConfiguration runConfig = this.imageConfig.getRunConfiguration();
        if (runConfig != null) {
            LogConfiguration logConfig = runConfig.getLog();
            if (logConfig != null) {
                return logConfig.isActivated();
            }
            return this.follow;
        }
        return false;
    }

    public static StartContainerExecutorBuilder builder() {
        return new StartContainerExecutorBuilder();
    }

    public StartContainerExecutor(String exposeContainerProps, KitLogger log, LogOutputSpecFactory logOutputSpecFactory, ServiceHub hub, boolean follow, String showLogs, String containerNamePattern, Date buildDate, Properties projectProperties, File basedir, ImageConfiguration imageConfig, GavLabel gavLabel, PortMapping portMapping, LogDispatcher dispatcher) {
        this.exposeContainerProps = exposeContainerProps;
        this.log = log;
        this.logOutputSpecFactory = logOutputSpecFactory;
        this.hub = hub;
        this.follow = follow;
        this.showLogs = showLogs;
        this.containerNamePattern = containerNamePattern;
        this.buildDate = buildDate;
        this.projectProperties = projectProperties;
        this.basedir = basedir;
        this.imageConfig = imageConfig;
        this.gavLabel = gavLabel;
        this.portMapping = portMapping;
        this.dispatcher = dispatcher;
    }

    public StartContainerExecutor() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StartContainerExecutor)) {
            return false;
        }
        StartContainerExecutor other = (StartContainerExecutor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$exposeContainerProps = this.exposeContainerProps;
        String other$exposeContainerProps = other.exposeContainerProps;
        if (this$exposeContainerProps == null ? other$exposeContainerProps != null : !this$exposeContainerProps.equals(other$exposeContainerProps)) {
            return false;
        }
        KitLogger this$log = this.log;
        KitLogger other$log = other.log;
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        LogOutputSpecFactory this$logOutputSpecFactory = this.logOutputSpecFactory;
        LogOutputSpecFactory other$logOutputSpecFactory = other.logOutputSpecFactory;
        if (this$logOutputSpecFactory == null ? other$logOutputSpecFactory != null : !this$logOutputSpecFactory.equals(other$logOutputSpecFactory)) {
            return false;
        }
        ServiceHub this$hub = this.hub;
        ServiceHub other$hub = other.hub;
        if (this$hub == null ? other$hub != null : !this$hub.equals(other$hub)) {
            return false;
        }
        if (this.follow != other.follow) {
            return false;
        }
        String this$showLogs = this.showLogs;
        String other$showLogs = other.showLogs;
        if (this$showLogs == null ? other$showLogs != null : !this$showLogs.equals(other$showLogs)) {
            return false;
        }
        String this$containerNamePattern = this.containerNamePattern;
        String other$containerNamePattern = other.containerNamePattern;
        if (this$containerNamePattern == null ? other$containerNamePattern != null : !this$containerNamePattern.equals(other$containerNamePattern)) {
            return false;
        }
        Date this$buildDate = this.buildDate;
        Date other$buildDate = other.buildDate;
        if (this$buildDate == null ? other$buildDate != null : !((Object)this$buildDate).equals(other$buildDate)) {
            return false;
        }
        Properties this$projectProperties = this.projectProperties;
        Properties other$projectProperties = other.projectProperties;
        if (this$projectProperties == null ? other$projectProperties != null : !((Object)this$projectProperties).equals(other$projectProperties)) {
            return false;
        }
        File this$basedir = this.basedir;
        File other$basedir = other.basedir;
        if (this$basedir == null ? other$basedir != null : !((Object)this$basedir).equals(other$basedir)) {
            return false;
        }
        ImageConfiguration this$imageConfig = this.imageConfig;
        ImageConfiguration other$imageConfig = other.imageConfig;
        if (this$imageConfig == null ? other$imageConfig != null : !this$imageConfig.equals(other$imageConfig)) {
            return false;
        }
        GavLabel this$gavLabel = this.gavLabel;
        GavLabel other$gavLabel = other.gavLabel;
        if (this$gavLabel == null ? other$gavLabel != null : !((Object)this$gavLabel).equals(other$gavLabel)) {
            return false;
        }
        PortMapping this$portMapping = this.portMapping;
        PortMapping other$portMapping = other.portMapping;
        if (this$portMapping == null ? other$portMapping != null : !this$portMapping.equals(other$portMapping)) {
            return false;
        }
        LogDispatcher this$dispatcher = this.dispatcher;
        LogDispatcher other$dispatcher = other.dispatcher;
        return !(this$dispatcher == null ? other$dispatcher != null : !this$dispatcher.equals(other$dispatcher));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StartContainerExecutor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $exposeContainerProps = this.exposeContainerProps;
        result = result * 59 + ($exposeContainerProps == null ? 43 : $exposeContainerProps.hashCode());
        KitLogger $log = this.log;
        result = result * 59 + ($log == null ? 43 : $log.hashCode());
        LogOutputSpecFactory $logOutputSpecFactory = this.logOutputSpecFactory;
        result = result * 59 + ($logOutputSpecFactory == null ? 43 : $logOutputSpecFactory.hashCode());
        ServiceHub $hub = this.hub;
        result = result * 59 + ($hub == null ? 43 : $hub.hashCode());
        result = result * 59 + (this.follow ? 79 : 97);
        String $showLogs = this.showLogs;
        result = result * 59 + ($showLogs == null ? 43 : $showLogs.hashCode());
        String $containerNamePattern = this.containerNamePattern;
        result = result * 59 + ($containerNamePattern == null ? 43 : $containerNamePattern.hashCode());
        Date $buildDate = this.buildDate;
        result = result * 59 + ($buildDate == null ? 43 : ((Object)$buildDate).hashCode());
        Properties $projectProperties = this.projectProperties;
        result = result * 59 + ($projectProperties == null ? 43 : ((Object)$projectProperties).hashCode());
        File $basedir = this.basedir;
        result = result * 59 + ($basedir == null ? 43 : ((Object)$basedir).hashCode());
        ImageConfiguration $imageConfig = this.imageConfig;
        result = result * 59 + ($imageConfig == null ? 43 : $imageConfig.hashCode());
        GavLabel $gavLabel = this.gavLabel;
        result = result * 59 + ($gavLabel == null ? 43 : ((Object)$gavLabel).hashCode());
        PortMapping $portMapping = this.portMapping;
        result = result * 59 + ($portMapping == null ? 43 : $portMapping.hashCode());
        LogDispatcher $dispatcher = this.dispatcher;
        result = result * 59 + ($dispatcher == null ? 43 : $dispatcher.hashCode());
        return result;
    }

    public static class StartContainerExecutorBuilder {
        private String exposeContainerProps;
        private KitLogger log;
        private LogOutputSpecFactory logOutputSpecFactory;
        private ServiceHub hub;
        private boolean follow;
        private String showLogs;
        private String containerNamePattern;
        private Date buildDate;
        private Properties projectProperties;
        private File basedir;
        private ImageConfiguration imageConfig;
        private GavLabel gavLabel;
        private PortMapping portMapping;
        private LogDispatcher dispatcher;

        StartContainerExecutorBuilder() {
        }

        public StartContainerExecutorBuilder exposeContainerProps(String exposeContainerProps) {
            this.exposeContainerProps = exposeContainerProps;
            return this;
        }

        public StartContainerExecutorBuilder log(KitLogger log) {
            this.log = log;
            return this;
        }

        public StartContainerExecutorBuilder logOutputSpecFactory(LogOutputSpecFactory logOutputSpecFactory) {
            this.logOutputSpecFactory = logOutputSpecFactory;
            return this;
        }

        public StartContainerExecutorBuilder hub(ServiceHub hub) {
            this.hub = hub;
            return this;
        }

        public StartContainerExecutorBuilder follow(boolean follow) {
            this.follow = follow;
            return this;
        }

        public StartContainerExecutorBuilder showLogs(String showLogs) {
            this.showLogs = showLogs;
            return this;
        }

        public StartContainerExecutorBuilder containerNamePattern(String containerNamePattern) {
            this.containerNamePattern = containerNamePattern;
            return this;
        }

        public StartContainerExecutorBuilder buildDate(Date buildDate) {
            this.buildDate = buildDate;
            return this;
        }

        public StartContainerExecutorBuilder projectProperties(Properties projectProperties) {
            this.projectProperties = projectProperties;
            return this;
        }

        public StartContainerExecutorBuilder basedir(File basedir) {
            this.basedir = basedir;
            return this;
        }

        public StartContainerExecutorBuilder imageConfig(ImageConfiguration imageConfig) {
            this.imageConfig = imageConfig;
            return this;
        }

        public StartContainerExecutorBuilder gavLabel(GavLabel gavLabel) {
            this.gavLabel = gavLabel;
            return this;
        }

        public StartContainerExecutorBuilder portMapping(PortMapping portMapping) {
            this.portMapping = portMapping;
            return this;
        }

        public StartContainerExecutorBuilder dispatcher(LogDispatcher dispatcher) {
            this.dispatcher = dispatcher;
            return this;
        }

        public StartContainerExecutor build() {
            return new StartContainerExecutor(this.exposeContainerProps, this.log, this.logOutputSpecFactory, this.hub, this.follow, this.showLogs, this.containerNamePattern, this.buildDate, this.projectProperties, this.basedir, this.imageConfig, this.gavLabel, this.portMapping, this.dispatcher);
        }

        public String toString() {
            return "StartContainerExecutor.StartContainerExecutorBuilder(exposeContainerProps=" + this.exposeContainerProps + ", log=" + this.log + ", logOutputSpecFactory=" + this.logOutputSpecFactory + ", hub=" + this.hub + ", follow=" + this.follow + ", showLogs=" + this.showLogs + ", containerNamePattern=" + this.containerNamePattern + ", buildDate=" + this.buildDate + ", projectProperties=" + this.projectProperties + ", basedir=" + this.basedir + ", imageConfig=" + this.imageConfig + ", gavLabel=" + this.gavLabel + ", portMapping=" + this.portMapping + ", dispatcher=" + this.dispatcher + ")";
        }
    }
}

