/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jkube.kit.build.service.docker.QueryService;
import org.eclipse.jkube.kit.build.service.docker.access.DockerAccessException;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;

public class StartOrderResolver {
    public static final int MAX_RESOLVE_RETRIES = 10;
    private final QueryService queryService;
    private final List<ImageConfiguration> secondPass;
    private final Set<String> processedImages;

    public static List<ImageConfiguration> resolve(QueryService queryService, List<ImageConfiguration> convertToResolvables) {
        return new StartOrderResolver(queryService).resolve(convertToResolvables);
    }

    private StartOrderResolver(QueryService queryService) {
        this.queryService = queryService;
        this.secondPass = new ArrayList<ImageConfiguration>();
        this.processedImages = new HashSet<String>();
    }

    private List<ImageConfiguration> resolve(List<ImageConfiguration> images) {
        ArrayList<ImageConfiguration> resolved = new ArrayList<ImageConfiguration>();
        for (ImageConfiguration config : images) {
            List<String> volumesOrLinks = this.extractDependentImagesFor(config);
            if (volumesOrLinks == null) {
                this.updateProcessedImages(config);
                resolved.add(config);
                continue;
            }
            this.secondPass.add(config);
        }
        return this.secondPass.isEmpty() ? resolved : this.resolveRemaining(resolved);
    }

    private List<ImageConfiguration> resolveRemaining(List<ImageConfiguration> ret) {
        int retries = 10;
        String error = null;
        try {
            do {
                this.resolveImageDependencies(ret);
            } while (!this.secondPass.isEmpty() && retries-- > 0);
        }
        catch (DockerAccessException | ResolveSteadyStateException e) {
            error = "Cannot resolve image dependencies for start order\n" + this.remainingImagesDescription();
        }
        if (retries == 0 && !this.secondPass.isEmpty()) {
            error = "Cannot resolve image dependencies after 10 passes\n" + this.remainingImagesDescription();
        }
        if (error != null) {
            throw new IllegalStateException(error);
        }
        return ret;
    }

    private void updateProcessedImages(ImageConfiguration config) {
        this.processedImages.add(config.getName());
        if (config.getAlias() != null) {
            this.processedImages.add(config.getAlias());
        }
    }

    private String remainingImagesDescription() {
        StringBuilder ret = new StringBuilder();
        ret.append("Unresolved images:\n");
        for (ImageConfiguration config : this.secondPass) {
            ret.append("* ").append(config.getAlias()).append(" depends on ").append(String.join((CharSequence)",", config.getDependencies().toArray(new String[0]))).append("\n");
        }
        return ret.toString();
    }

    private void resolveImageDependencies(List<ImageConfiguration> resolved) throws DockerAccessException, ResolveSteadyStateException {
        boolean changed = false;
        Iterator<ImageConfiguration> iterator = this.secondPass.iterator();
        while (iterator.hasNext()) {
            ImageConfiguration config = iterator.next();
            if (!this.hasRequiredDependencies(config)) continue;
            this.updateProcessedImages(config);
            resolved.add(config);
            changed = true;
            iterator.remove();
        }
        if (!changed) {
            throw new ResolveSteadyStateException();
        }
    }

    private boolean hasRequiredDependencies(ImageConfiguration config) throws DockerAccessException {
        List<String> dependencies = this.extractDependentImagesFor(config);
        if (dependencies == null) {
            return false;
        }
        for (String dependency : dependencies) {
            if (this.processedImages.contains(dependency) || this.queryService.hasContainer(dependency)) continue;
            return false;
        }
        return true;
    }

    private List<String> extractDependentImagesFor(ImageConfiguration config) {
        LinkedHashSet ret = new LinkedHashSet(config.getDependencies());
        return ret.isEmpty() ? null : new ArrayList(ret);
    }

    private static class ResolveSteadyStateException
    extends Exception {
        private ResolveSteadyStateException() {
        }
    }
}

