/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.jkube.kit.build.api.assembly.ArchiverCustomizer;
import org.eclipse.jkube.kit.build.api.assembly.AssemblyFiles;
import org.eclipse.jkube.kit.build.api.assembly.AssemblyManager;
import org.eclipse.jkube.kit.common.AssemblyFileEntry;
import org.eclipse.jkube.kit.common.JKubeConfiguration;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;

public class ArchiveService {
    private final KitLogger log;
    private AssemblyManager assemblyManager;

    public ArchiveService(AssemblyManager assemblyManager, KitLogger log) {
        this.log = log;
        this.assemblyManager = assemblyManager;
    }

    public File createDockerBuildArchive(ImageConfiguration imageConfig, JKubeConfiguration params) throws IOException {
        return this.createDockerBuildArchive(imageConfig, params, null);
    }

    public File createDockerBuildArchive(ImageConfiguration imageConfig, JKubeConfiguration params, ArchiverCustomizer customizer) throws IOException {
        File ret = this.createArchive(imageConfig.getName(), imageConfig.getBuildConfiguration(), params, this.log, customizer);
        this.log.info("%s: Created docker source tar %s", new Object[]{imageConfig.getDescription(), ret});
        return ret;
    }

    public AssemblyFiles getAssemblyFiles(ImageConfiguration imageConfig, JKubeConfiguration jKubeConfiguration) throws IOException {
        try {
            return this.assemblyManager.getAssemblyFiles(imageConfig, jKubeConfiguration);
        }
        catch (IOException e) {
            throw new IOException("Cannot extract assembly files for image " + imageConfig.getName() + ": " + e.getMessage(), e);
        }
    }

    public File createChangedFilesArchive(List<AssemblyFileEntry> entries, File assemblyDir, String imageName, JKubeConfiguration jKubeConfiguration) throws IOException {
        return this.assemblyManager.createChangedFilesArchive(entries, assemblyDir, imageName, jKubeConfiguration);
    }

    File createArchive(String imageName, BuildConfiguration buildConfig, JKubeConfiguration params, KitLogger log) throws IOException {
        return this.createArchive(imageName, buildConfig, params, log, null);
    }

    File createArchive(String imageName, BuildConfiguration buildConfig, JKubeConfiguration params, KitLogger log, ArchiverCustomizer customizer) throws IOException {
        return this.assemblyManager.createDockerTarArchive(imageName, params, buildConfig, log, customizer);
    }
}

