/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.service.jib;

import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.event.progress.ProgressEventHandler;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.KitLogger;
import org.fusesource.jansi.Ansi;

public class JibLogger
implements Consumer<LogEvent> {
    private static final String HEADER = "Executing tasks:";
    private static final int PROGRESS_BAR_COUNT = 30;
    public static final String JIB_LOG_PREFIX = "JIB> ";
    final KitLogger logger;
    private final PrintStream out;

    public JibLogger(KitLogger logger) {
        this(logger, System.out);
    }

    public JibLogger(KitLogger logger, PrintStream out) {
        this.logger = logger;
        this.out = out;
    }

    @Override
    public void accept(LogEvent logEvent) {
        if (logEvent.getLevel() != LogEvent.Level.DEBUG || this.logger.isVerboseEnabled() || this.logger.isDebugEnabled()) {
            this.out.println(Ansi.ansi().cursorUpLine(1).eraseLine().a(JIB_LOG_PREFIX).a(StringUtils.rightPad((String)logEvent.getMessage(), (int)120)).a("\n"));
        }
    }

    ProgressEventHandler progressEventHandler() {
        return new ProgressEventHandler(update -> {
            List<String> progressDisplay = JibLogger.generateProgressDisplay(update.getProgress(), (List<String>)update.getUnfinishedLeafTasks());
            if (progressDisplay.size() > 2 && progressDisplay.stream().allMatch(Objects::nonNull)) {
                String progressBar = progressDisplay.get(1);
                String task = progressDisplay.get(2);
                this.out.println(Ansi.ansi().cursorUpLine(1).eraseLine().a(JIB_LOG_PREFIX).a(progressBar).a(" ").a(task));
            }
        });
    }

    void updateFinished() {
        this.out.println(JIB_LOG_PREFIX + JibLogger.generateProgressBar(1.0));
    }

    private static List<String> generateProgressDisplay(double progress, List<String> unfinishedLeafTasks) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(HEADER);
        lines.add(JibLogger.generateProgressBar(progress));
        for (String task : unfinishedLeafTasks) {
            lines.add("> " + task);
        }
        return lines;
    }

    private static String generateProgressBar(double progress) {
        StringBuilder progressBar = new StringBuilder();
        progressBar.append('[');
        int barsToDisplay = (int)Math.round(30.0 * progress);
        for (int barIndex = 0; barIndex < 30; ++barIndex) {
            progressBar.append(barIndex < barsToDisplay ? (char)'=' : ' ');
        }
        return progressBar.append(']').append(String.format(" %.1f", progress * 100.0)).append("% complete").toString();
    }
}

