/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.service.jib;

import com.google.cloud.tools.jib.api.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.api.Jib;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.RegistryException;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.api.TarImage;
import com.google.cloud.tools.jib.api.buildplan.Platform;
import com.google.cloud.tools.jib.event.events.ProgressEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.jkube.kit.build.api.assembly.AssemblyManager;
import org.eclipse.jkube.kit.build.api.assembly.BuildDirs;
import org.eclipse.jkube.kit.build.api.auth.AuthConfig;
import org.eclipse.jkube.kit.build.api.auth.AuthConfigFactory;
import org.eclipse.jkube.kit.build.api.helper.RegistryUtil;
import org.eclipse.jkube.kit.common.JKubeConfiguration;
import org.eclipse.jkube.kit.common.JKubeException;
import org.eclipse.jkube.kit.common.RegistryConfig;
import org.eclipse.jkube.kit.common.archive.ArchiveCompression;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.ImageName;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;
import org.eclipse.jkube.kit.service.jib.JibLogger;
import org.eclipse.jkube.kit.service.jib.JibServiceUtil;

public class JibService
implements AutoCloseable {
    private static final long JIB_EXECUTOR_SHUTDOWN_TIMEOUT_SECONDS = 10L;
    private final JibLogger jibLogger;
    private final AuthConfigFactory authConfigFactory;
    private final JKubeConfiguration configuration;
    private final ImageConfiguration imageConfiguration;
    private final ExecutorService executorService;

    public JibService(JibLogger jibLogger, AuthConfigFactory authConfigFactory, JKubeConfiguration configuration, ImageConfiguration imageConfiguration) {
        this.jibLogger = jibLogger;
        this.authConfigFactory = authConfigFactory;
        this.configuration = configuration;
        this.imageConfiguration = JibService.prependPushRegistry(imageConfiguration, configuration);
        this.executorService = Executors.newCachedThreadPool();
    }

    @Override
    public void close() {
        try {
            this.executorService.shutdown();
            if (!this.executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new JKubeException("Thread Interrupted", (Throwable)e);
        }
    }

    public final ImageName getImageName() {
        return new ImageName(this.imageConfiguration.getName());
    }

    public final List<File> build() {
        ArrayList<File> generatedTarballs = new ArrayList<File>();
        for (Platform platform : JibServiceUtil.platforms(this.imageConfiguration)) {
            JibContainerBuilder from = this.assembleFrom();
            from.setPlatforms(Collections.singleton(platform));
            File jibImageTarArchive = this.getJibImageTarArchive(platform);
            Containerizer to = Containerizer.to((TarImage)TarImage.at((Path)jibImageTarArchive.toPath()).named(JibServiceUtil.toImageReference(this.imageConfiguration)));
            this.containerize(from, to);
            generatedTarballs.add(jibImageTarArchive);
        }
        return generatedTarballs;
    }

    public final void push() {
        JibContainerBuilder from;
        Set<Platform> platforms = JibServiceUtil.platforms(this.imageConfiguration);
        if (platforms.size() > 1) {
            from = this.assembleFrom();
            from.setPlatforms(platforms);
        } else {
            from = Jib.from((TarImage)TarImage.at((Path)this.getJibImageTarArchive(platforms.iterator().next()).toPath()));
        }
        Containerizer to = Containerizer.to((RegistryImage)JibServiceUtil.toRegistryImage(this.getImageName().getFullName(), this.getPushRegistryCredentials()));
        this.containerize(from, to);
    }

    private JibContainerBuilder assembleFrom() {
        BuildDirs buildDirs = new BuildDirs(this.imageConfiguration.getName(), this.configuration);
        String pullRegistry = RegistryUtil.getApplicablePullRegistryFrom((String)this.imageConfiguration.getBuildConfiguration().getFrom(), (RegistryConfig)this.configuration.getPullRegistryConfig());
        Credential pullRegistryCredential = this.getPullRegistryCredentials();
        JibContainerBuilder from = JibServiceUtil.containerFromImageConfiguration(this.imageConfiguration, pullRegistry, pullRegistryCredential);
        try {
            AssemblyManager assemblyManager = AssemblyManager.getInstance();
            Map layers = assemblyManager.copyFilesToFinalTarballDirectory(this.configuration, buildDirs, AssemblyManager.getAssemblyConfiguration((BuildConfiguration)this.imageConfiguration.getBuildConfiguration(), (JKubeConfiguration)this.configuration));
            JibServiceUtil.layers(buildDirs, layers).forEach(arg_0 -> ((JibContainerBuilder)from).addFileEntriesLayer(arg_0));
            assemblyManager.createDockerTarArchive(this.imageConfiguration.getName(), this.configuration, this.imageConfiguration.getBuildConfiguration(), this.jibLogger.logger, null);
            return from;
        }
        catch (IOException ex) {
            throw new JKubeException("Unable to build the image tarball: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private void containerize(JibContainerBuilder from, Containerizer to) {
        to.setAllowInsecureRegistries(true);
        to.setExecutorService(this.executorService);
        to.addEventHandler(LogEvent.class, (Consumer)this.jibLogger);
        to.addEventHandler(ProgressEvent.class, (Consumer)this.jibLogger.progressEventHandler());
        if (this.imageConfiguration.getBuildConfiguration().getTags() != null) {
            this.imageConfiguration.getBuildConfiguration().getTags().forEach(arg_0 -> ((Containerizer)to).withAdditionalTag(arg_0));
        }
        from.setCreationTime(Instant.now());
        try {
            from.containerize(to);
            this.jibLogger.updateFinished();
        }
        catch (CacheDirectoryCreationException | RegistryException | IOException | ExecutionException ex) {
            throw new JKubeException("Unable to containerize image using Jib: " + ex.getMessage(), ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new JKubeException("Thread Interrupted", (Throwable)ex);
        }
    }

    private File getJibImageTarArchive(Platform platform) {
        BuildDirs buildDirs = new BuildDirs(this.imageConfiguration.getName(), this.configuration);
        return new File(buildDirs.getTemporaryRootDirectory(), String.format("jib-image.%s-%s.%s", platform.getOs(), platform.getArchitecture(), ArchiveCompression.none.getFileSuffix()));
    }

    private Credential getPullRegistryCredentials() {
        RegistryConfig registryConfig = this.configuration.getPullRegistryConfig();
        String pullRegistry = RegistryUtil.getApplicablePullRegistryFrom((String)this.imageConfiguration.getBuildConfiguration().getFrom(), (RegistryConfig)registryConfig);
        return this.getCredentials(false, registryConfig, pullRegistry);
    }

    private Credential getPushRegistryCredentials() {
        RegistryConfig registryConfig = this.configuration.getPushRegistryConfig();
        String pushRegistry = RegistryUtil.getApplicablePushRegistryFrom((ImageConfiguration)this.imageConfiguration, (RegistryConfig)registryConfig);
        return this.getCredentials(true, registryConfig, pushRegistry);
    }

    private Credential getCredentials(boolean isPush, RegistryConfig registryConfig, String registry) {
        try {
            AuthConfig standardAuthConfig = this.authConfigFactory.createAuthConfig(isPush, registryConfig.isSkipExtendedAuth(), registryConfig.getAuthConfig(), registryConfig.getSettings(), null, registry, registryConfig.getPasswordDecryptionMethod());
            Credential credentials = null;
            if (standardAuthConfig != null) {
                credentials = Credential.from((String)standardAuthConfig.getUsername(), (String)standardAuthConfig.getPassword());
            }
            return credentials;
        }
        catch (IOException exception) {
            throw new JKubeException("Error when getting registry credentials", (Throwable)exception);
        }
    }

    private static ImageConfiguration prependPushRegistry(ImageConfiguration imageConfiguration, JKubeConfiguration configuration) {
        ImageConfiguration.ImageConfigurationBuilder icBuilder = imageConfiguration.toBuilder();
        ImageName imageName = new ImageName(imageConfiguration.getName());
        String pushRegistry = RegistryUtil.getApplicablePushRegistryFrom((ImageConfiguration)imageConfiguration, (RegistryConfig)configuration.getPushRegistryConfig());
        if (!imageName.hasRegistry() && pushRegistry != null) {
            icBuilder.name(imageName.getFullName(pushRegistry));
            icBuilder.registry(pushRegistry);
        }
        return icBuilder.build();
    }
}

