/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.service.jib;

import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.InvalidImageReferenceException;
import com.google.cloud.tools.jib.api.Jib;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.api.buildplan.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.buildplan.FileEntriesLayer;
import com.google.cloud.tools.jib.api.buildplan.FilePermissions;
import com.google.cloud.tools.jib.api.buildplan.ImageFormat;
import com.google.cloud.tools.jib.api.buildplan.Platform;
import com.google.cloud.tools.jib.api.buildplan.Port;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.build.api.assembly.BuildDirs;
import org.eclipse.jkube.kit.common.Arguments;
import org.eclipse.jkube.kit.common.Assembly;
import org.eclipse.jkube.kit.common.AssemblyFileEntry;
import org.eclipse.jkube.kit.common.JKubeException;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.ImageName;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;

public class JibServiceUtil {
    private static final String BUSYBOX = "busybox:latest";
    private static final Platform DEFAULT_PLATFORM = new Platform("amd64", "linux");

    private JibServiceUtil() {
    }

    public static JibContainerBuilder containerFromImageConfiguration(ImageConfiguration imageConfiguration, String pullRegistry, Credential pullRegistryCredential) {
        String baseImage = JibServiceUtil.getBaseImage(imageConfiguration, pullRegistry);
        JibContainerBuilder containerBuilder = baseImage.equals(ImageReference.scratch() + ":latest") ? Jib.fromScratch() : Jib.from((RegistryImage)JibServiceUtil.toRegistryImage(baseImage, pullRegistryCredential));
        containerBuilder.setFormat(ImageFormat.Docker);
        if (imageConfiguration.getBuildConfiguration() != null) {
            BuildConfiguration bic = imageConfiguration.getBuildConfiguration();
            Optional.ofNullable(bic.getEntryPoint()).map(Arguments::asStrings).ifPresent(arg_0 -> ((JibContainerBuilder)containerBuilder).setEntrypoint(arg_0));
            Optional.ofNullable(bic.getEnv()).ifPresent(arg_0 -> ((JibContainerBuilder)containerBuilder).setEnvironment(arg_0));
            Optional.ofNullable(bic.getPorts()).map(Collection::stream).map(s -> s.map(Integer::parseInt).map(Port::tcp)).map(s -> s.collect(Collectors.toSet())).ifPresent(arg_0 -> ((JibContainerBuilder)containerBuilder).setExposedPorts(arg_0));
            Optional.ofNullable(bic.getLabels()).map(Map::entrySet).ifPresent(labels -> labels.forEach(l -> {
                if (l.getKey() != null && l.getValue() != null) {
                    containerBuilder.addLabel((String)l.getKey(), (String)l.getValue());
                }
            }));
            Optional.ofNullable(bic.getCmd()).map(Arguments::asStrings).ifPresent(arg_0 -> ((JibContainerBuilder)containerBuilder).setProgramArguments(arg_0));
            Optional.ofNullable(bic.getUser()).ifPresent(arg_0 -> ((JibContainerBuilder)containerBuilder).setUser(arg_0));
            Optional.ofNullable(bic.getVolumes()).map(Collection::stream).map(s -> s.map(AbsoluteUnixPath::get)).map(s -> s.collect(Collectors.toSet())).ifPresent(arg_0 -> ((JibContainerBuilder)containerBuilder).setVolumes(arg_0));
            Optional.ofNullable(bic.getWorkdir()).filter(((Predicate<String>)String::isEmpty).negate()).map(AbsoluteUnixPath::get).ifPresent(arg_0 -> ((JibContainerBuilder)containerBuilder).setWorkingDirectory(arg_0));
        }
        return containerBuilder;
    }

    static RegistryImage toRegistryImage(String imageReference, Credential credential) {
        try {
            RegistryImage registryImage = RegistryImage.named((String)imageReference);
            if (credential != null && !credential.getUsername().isEmpty() && !credential.getPassword().isEmpty()) {
                registryImage.addCredential(credential.getUsername(), credential.getPassword());
            }
            return registryImage;
        }
        catch (InvalidImageReferenceException e) {
            throw new JKubeException("Invalid image reference: " + imageReference, (Throwable)e);
        }
    }

    static ImageReference toImageReference(ImageConfiguration imageConfiguration) {
        try {
            return ImageReference.parse((String)imageConfiguration.getName());
        }
        catch (InvalidImageReferenceException e) {
            throw new JKubeException("Invalid image reference: " + imageConfiguration.getName(), (Throwable)e);
        }
    }

    static Set<Platform> platforms(ImageConfiguration imageConfiguration) {
        List targetPlatforms = Optional.ofNullable(imageConfiguration).map(ImageConfiguration::getBuildConfiguration).map(BuildConfiguration::getPlatforms).orElse(Collections.emptyList());
        LinkedHashSet<Platform> ret = new LinkedHashSet<Platform>();
        for (String targetPlatform : targetPlatforms) {
            int slashIndex = targetPlatform.indexOf(47);
            if (slashIndex < 0) continue;
            String os = targetPlatform.substring(0, slashIndex);
            String arch = targetPlatform.substring(slashIndex + 1);
            ret.add(new Platform(arch, os));
        }
        if (ret.isEmpty()) {
            ret.add(DEFAULT_PLATFORM);
        }
        return ret;
    }

    public static String getBaseImage(ImageConfiguration imageConfiguration, String optionalRegistry) {
        String baseImage = Optional.ofNullable(imageConfiguration).map(ImageConfiguration::getBuildConfiguration).map(BuildConfiguration::getFrom).filter(((Predicate<String>)String::isEmpty).negate()).orElse(BUSYBOX);
        return new ImageName(baseImage).getFullName(optionalRegistry);
    }

    public static List<FileEntriesLayer> layers(BuildDirs buildDirs, Map<Assembly, List<AssemblyFileEntry>> layers) {
        ArrayList<FileEntriesLayer> fileEntriesLayers = new ArrayList<FileEntriesLayer>();
        for (Map.Entry<Assembly, List<AssemblyFileEntry>> layer : layers.entrySet()) {
            Path outputPath;
            FileEntriesLayer.Builder fel = FileEntriesLayer.builder();
            String layerId = layer.getKey().getId();
            if (StringUtils.isBlank((CharSequence)layerId)) {
                outputPath = buildDirs.getOutputDirectory().toPath();
            } else {
                fel.setName(layerId);
                outputPath = new File(buildDirs.getOutputDirectory(), layerId).toPath();
            }
            for (AssemblyFileEntry afe : layer.getValue()) {
                Path source = afe.getSource().toPath();
                AbsoluteUnixPath target = AbsoluteUnixPath.get((String)StringUtils.prependIfMissing((String)FilenameUtils.separatorsToUnix((String)outputPath.relativize(afe.getDest().toPath()).normalize().toString()), (CharSequence)"/", (CharSequence[])new CharSequence[0]));
                FilePermissions permissions = StringUtils.isNotBlank((CharSequence)afe.getFileMode()) ? FilePermissions.fromOctalString((String)StringUtils.right((String)afe.getFileMode(), (int)3)) : FileEntriesLayer.DEFAULT_FILE_PERMISSIONS_PROVIDER.get(source, target);
                fel.addEntry(source, target, permissions);
            }
            fileEntriesLayers.add(fel.build());
        }
        return fileEntriesLayers;
    }
}

