/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.AnsiUtil;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

public class AnsiLogger
implements KitLogger {
    public static final String DEFAULT_LOG_PREFIX = "DOCKER> ";
    private static final int NON_ANSI_UPDATE_PERIOD = 80;
    private final Log log;
    private final String prefix;
    private final boolean batchMode;
    private final KitLogger fallbackLogger;
    private boolean isVerbose = false;
    private List<KitLogger.LogVerboseCategory> verboseModes = null;
    private final ThreadLocal<Map<String, Integer>> imageLines = new ThreadLocal();
    private final ThreadLocal<AtomicInteger> updateCount = new ThreadLocal();
    private boolean useAnsi;

    public AnsiLogger(Log log, boolean useColor, String verbose) {
        this(log, useColor, verbose, false);
    }

    public AnsiLogger(Log log, boolean useColor, String verbose, boolean batchMode) {
        this(log, useColor, verbose, batchMode, DEFAULT_LOG_PREFIX);
    }

    public AnsiLogger(Log log, boolean useColor, String verbose, boolean batchMode, String prefix) {
        this.log = log;
        this.prefix = prefix;
        this.batchMode = batchMode;
        this.fallbackLogger = new KitLogger.StdoutLogger();
        this.checkVerboseLoggingEnabled(verbose);
        this.initializeColor(useColor);
    }

    public void debug(String message, Object ... params) {
        if (this.isDebugEnabled() && AnsiLogger.isAnsiConsoleInstalled()) {
            this.log.debug((CharSequence)(this.prefix + AnsiUtil.format((String)message, (Object[])params)));
        } else if (this.isDebugEnabled()) {
            this.fallbackLogger.debug(message, params);
        }
    }

    public void info(String message, Object ... params) {
        if (AnsiLogger.isAnsiConsoleInstalled()) {
            this.log.info((CharSequence)this.colored(message, AnsiUtil.Color.INFO, params));
        } else {
            this.fallbackLogger.info(message, params);
        }
    }

    public void verbose(KitLogger.LogVerboseCategory logVerboseCategory, String message, Object ... params) {
        boolean logVerbose;
        boolean bl = logVerbose = this.isVerbose && this.verboseModes != null && this.verboseModes.contains(logVerboseCategory);
        if (logVerbose && AnsiLogger.isAnsiConsoleInstalled()) {
            this.log.info((CharSequence)Ansi.ansi().fgBright(Ansi.Color.BLACK).a(this.prefix).a(AnsiUtil.format((String)message, (Object[])params)).reset().toString());
        } else {
            this.fallbackLogger.info(message, params);
        }
    }

    public void warn(String format, Object ... params) {
        if (AnsiLogger.isAnsiConsoleInstalled()) {
            this.log.warn((CharSequence)this.colored(format, AnsiUtil.Color.WARNING, params));
        } else {
            this.fallbackLogger.warn(format, params);
        }
    }

    public void error(String message, Object ... params) {
        if (AnsiLogger.isAnsiConsoleInstalled()) {
            this.log.error((CharSequence)this.colored(message, AnsiUtil.Color.ERROR, params));
        } else {
            this.fallbackLogger.error(message, params);
        }
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isVerboseEnabled() {
        return this.isVerbose;
    }

    public void progressStart() {
        if (!this.batchMode && this.log.isInfoEnabled()) {
            this.imageLines.remove();
            this.updateCount.remove();
            this.imageLines.set(new HashMap());
            this.updateCount.set(new AtomicInteger());
        }
    }

    public void progressUpdate(String layerId, String status, String progressMessage) {
        if (!this.batchMode && this.log.isInfoEnabled() && StringUtils.isNotEmpty((String)layerId)) {
            if (this.useAnsi && AnsiLogger.isAnsiConsoleInstalled()) {
                this.updateAnsiProgress(layerId, status, progressMessage);
            } else {
                this.updateNonAnsiProgress();
            }
            this.flush();
        }
    }

    private void updateAnsiProgress(String imageId, String status, String progressMessage) {
        Map<String, Integer> imgLineMap = this.imageLines.get();
        Integer line = imgLineMap.get(imageId);
        int diff = 0;
        if (line == null) {
            line = imgLineMap.size();
            imgLineMap.put(imageId, line);
        } else {
            diff = imgLineMap.size() - line;
        }
        if (diff > 0) {
            this.print(Ansi.ansi().cursorUp(diff).eraseLine(Ansi.Erase.ALL).toString());
        }
        String progress = progressMessage != null ? progressMessage : "";
        String msg = Ansi.ansi().fg(AnsiUtil.Color.PROGRESS_ID.ansiColor).a(imageId).reset().a(": ").fg(AnsiUtil.Color.PROGRESS_STATUS.ansiColor).a(StringUtils.rightPad((String)status, (int)11) + " ").fg(AnsiUtil.Color.PROGRESS_BAR.ansiColor).a(progress).toString();
        this.println(msg);
        if (diff > 0) {
            this.print(Ansi.ansi().cursorDown(diff - 1).toString());
        }
    }

    private void updateNonAnsiProgress() {
        AtomicInteger count = this.updateCount.get();
        int nr = count.getAndIncrement();
        if (nr % 80 == 0) {
            this.print("#");
        }
        if (nr > 0 && nr % 6400 == 0) {
            this.print("\n");
        }
    }

    public void progressFinished() {
        if (!this.batchMode && this.log.isInfoEnabled()) {
            this.imageLines.remove();
            this.print(Ansi.ansi().reset().toString());
            if (!this.useAnsi) {
                this.println("");
            }
        }
    }

    private void flush() {
        System.out.flush();
    }

    private void initializeColor(boolean useColor) {
        boolean bl = this.useAnsi = useColor && !this.log.isDebugEnabled();
        if (this.useAnsi) {
            AnsiConsole.systemInstall();
            Ansi.setEnabled((boolean)true);
        } else {
            Ansi.setEnabled((boolean)false);
        }
    }

    private void println(String txt) {
        System.out.println(txt);
    }

    private void print(String txt) {
        System.out.print(txt);
    }

    private String colored(String message, AnsiUtil.Color color, Object ... params) {
        return AnsiUtil.colored((String)(this.prefix + message), (AnsiUtil.Color)color, (Object[])params);
    }

    private void checkVerboseLoggingEnabled(String verbose) {
        if (verbose == null || verbose.equalsIgnoreCase("false")) {
            this.isVerbose = false;
            return;
        }
        if (verbose.equalsIgnoreCase("all")) {
            this.isVerbose = true;
            this.verboseModes = Arrays.asList(KitLogger.LogVerboseCategory.values());
            return;
        }
        if (verbose.isEmpty() || verbose.equalsIgnoreCase("true")) {
            this.isVerbose = true;
            this.verboseModes = Collections.singletonList(KitLogger.LogVerboseCategory.BUILD);
            return;
        }
        this.verboseModes = this.getVerboseModesFromString(verbose);
        this.isVerbose = true;
    }

    private List<KitLogger.LogVerboseCategory> getVerboseModesFromString(String groups) {
        ArrayList<KitLogger.LogVerboseCategory> ret = new ArrayList<KitLogger.LogVerboseCategory>();
        for (String group : groups.split(",")) {
            try {
                ret.add(KitLogger.LogVerboseCategory.valueOf((String)group.toUpperCase()));
            }
            catch (Exception exp) {
                this.log.info((CharSequence)("log: Unknown verbosity group " + groups + ". Ignoring..."));
            }
        }
        return ret;
    }

    private static boolean isAnsiConsoleInstalled() {
        try {
            AnsiConsole.class.getMethod("isInstalled", new Class[0]);
            return AnsiConsole.isInstalled();
        }
        catch (NoSuchMethodException ex) {
            return true;
        }
    }
}

