/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MavenConfigurationExtractor {
    private MavenConfigurationExtractor() {
    }

    public static Map<String, Object> extract(Xpp3Dom root) {
        if (root == null) {
            return new HashMap<String, Object>();
        }
        return MavenConfigurationExtractor.getElement(root);
    }

    private static Map<String, Object> getElement(Xpp3Dom element) {
        Xpp3Dom[] currentElements;
        HashMap<String, Object> conf = new HashMap<String, Object>();
        for (Xpp3Dom currentElement : currentElements = element.getChildren()) {
            if (MavenConfigurationExtractor.isSimpleType(currentElement)) {
                if (MavenConfigurationExtractor.isAListOfElements(conf, currentElement)) {
                    MavenConfigurationExtractor.addAsList(conf, currentElement);
                    continue;
                }
                conf.put(currentElement.getName(), currentElement.getValue());
                continue;
            }
            conf.put(currentElement.getName(), MavenConfigurationExtractor.getElement(currentElement));
        }
        return conf;
    }

    private static void addAsList(Map<String, Object> conf, Xpp3Dom currentElement) {
        Object insertedValue = conf.get(currentElement.getName());
        if (insertedValue instanceof List) {
            ((List)insertedValue).add(currentElement.getValue());
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add((String)insertedValue);
            list.add(currentElement.getValue());
            conf.put(currentElement.getName(), list);
        }
    }

    private static boolean isAListOfElements(Map<String, Object> conf, Xpp3Dom currentElement) {
        return conf.containsKey(currentElement.getName());
    }

    private static boolean isSimpleType(Xpp3Dom currentElement) {
        return currentElement.getChildCount() == 0;
    }
}

