/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.RepositorySystemSession;

public class MojoExecutionService {
    private final MavenProject project;
    private final MavenSession session;
    private final BuildPluginManager pluginManager;

    public MojoExecutionService(MavenProject project, MavenSession session, BuildPluginManager pluginManager) {
        this.project = project;
        this.session = session;
        this.pluginManager = pluginManager;
    }

    public void callPluginGoal(String fullGoal) {
        String[] parts = this.splitGoalSpec(fullGoal);
        Plugin plugin = this.project.getPlugin(parts[0]);
        String goal = parts[1];
        if (plugin == null) {
            throw new IllegalStateException("No goal " + fullGoal + " found in pom.xml");
        }
        try {
            PluginDescriptor pluginDescriptor;
            MojoDescriptor mojoDescriptor;
            String executionId = null;
            if (goal != null && !goal.isEmpty() && goal.indexOf(35) > -1) {
                int pos = goal.indexOf(35);
                executionId = goal.substring(pos + 1);
                goal = goal.substring(0, pos);
            }
            if ((mojoDescriptor = (pluginDescriptor = this.getPluginDescriptor(this.project, plugin)).getMojo(goal)) == null) {
                throw new MojoExecutionException("Could not find goal '" + goal + "' in plugin " + plugin.getGroupId() + ":" + plugin.getArtifactId() + ":" + plugin.getVersion());
            }
            MojoExecution exec = this.getMojoExecution(executionId, mojoDescriptor);
            this.pluginManager.executeMojo(this.session, exec);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to execute mojo", e);
        }
    }

    private MojoExecution getMojoExecution(String executionId, MojoDescriptor mojoDescriptor) {
        if (executionId != null) {
            return new MojoExecution(mojoDescriptor, executionId);
        }
        return new MojoExecution(mojoDescriptor, this.toXpp3Dom(mojoDescriptor.getMojoConfiguration()));
    }

    PluginDescriptor getPluginDescriptor(MavenProject project, Plugin plugin) throws InvocationTargetException, IllegalAccessException, MojoFailureException {
        try {
            Method loadPlugin = this.pluginManager.getClass().getMethod("loadPluginDescriptor", plugin.getClass(), project.getClass(), this.session.getClass());
            return (PluginDescriptor)loadPlugin.invoke((Object)this.pluginManager, plugin, project, this.session);
        }
        catch (NoSuchMethodException exp) {
            try {
                RepositorySystemSession repositorySession = this.session.getRepositorySession();
                Method loadPlugin = this.pluginManager.getClass().getMethod("loadPlugin", Plugin.class, List.class, RepositorySystemSession.class);
                return (PluginDescriptor)loadPlugin.invoke((Object)this.pluginManager, plugin, project.getRemotePluginRepositories(), repositorySession);
            }
            catch (NoSuchMethodException exp2) {
                throw new MojoFailureException("Cannot load plugin descriptor for plugin " + plugin.getGroupId() + ":" + plugin.getArtifactId(), (Throwable)exp2);
            }
        }
    }

    private String[] splitGoalSpec(String fullGoal) {
        String[] parts = StringUtils.split((String)fullGoal, (String)":");
        if (parts.length != 3) {
            throw new IllegalStateException("Cannot parse " + fullGoal + " as a maven plugin goal. It must be fully qualified as in <groupId>:<artifactId>:<goal>");
        }
        return new String[]{parts[0] + ":" + parts[1], parts[2]};
    }

    private Xpp3Dom toXpp3Dom(PlexusConfiguration config) {
        Xpp3Dom result = new Xpp3Dom(config.getName());
        result.setValue(config.getValue(null));
        for (String string : config.getAttributeNames()) {
            result.setAttribute(string, config.getAttribute(string));
        }
        for (String string : config.getChildren()) {
            result.addChild(this.toXpp3Dom((PlexusConfiguration)string));
        }
        return result;
    }
}

