/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class MapUtil {
    private MapUtil() {
    }

    public static void putIfAbsent(Map<String, String> map, String name, String value) {
        if (map != null && !map.containsKey(name)) {
            map.put(name, value);
        }
    }

    public static void mergeIfAbsent(Map<String, String> map, Map<String, String> toMerge) {
        for (Map.Entry<String, String> entry : toMerge.entrySet()) {
            MapUtil.putIfAbsent(map, entry.getKey(), entry.getValue());
        }
    }

    public static <K, V> Map<K, V> mergeMaps(Map<K, V> map1, Map<K, V> map2) {
        HashMap<K, V> answer = new HashMap<K, V>();
        if (map2 != null) {
            answer.putAll(map2);
        }
        if (map1 != null) {
            answer.putAll(map1);
        }
        return answer;
    }

    public static void putAllIfNotNull(Map<String, String> ret, Map<String, String> toPut) {
        if (toPut != null) {
            ret.putAll(toPut);
        }
    }

    public static Map<String, Object> getFlattenedMap(Map<?, ?> source) {
        return MapUtil.buildFlattenedMap(source, null);
    }

    private static Map<String, Object> buildFlattenedMap(Map<?, ?> source, String keyPrefix) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<?, ?> entry : source.entrySet()) {
            String key = MapUtil.applicableKey(String.valueOf(entry.getKey()), keyPrefix);
            Object value = entry.getValue();
            if (value instanceof Map) {
                result.putAll(MapUtil.buildFlattenedMap((Map)value, key));
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                int count = 0;
                for (Object object : collection) {
                    result.putAll(MapUtil.buildFlattenedMap(Collections.singletonMap("[" + count++ + "]", object), key));
                }
                continue;
            }
            result.put(key, value != null ? value.toString() : "");
        }
        return result;
    }

    private static String applicableKey(String key, String keyPrefix) {
        if (StringUtils.isNotBlank((CharSequence)keyPrefix)) {
            key = key.startsWith("[") ? keyPrefix + key : keyPrefix + "." + key;
        }
        return key;
    }
}

