/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringBootConfigurationHelper {
    private static final Logger LOG = LoggerFactory.getLogger(SpringBootConfigurationHelper.class);
    public static final String SPRING_BOOT_GROUP_ID = "org.springframework.boot";
    public static final String SPRING_BOOT_ARTIFACT_ID = "spring-boot";
    public static final String SPRING_BOOT_DEVTOOLS_ARTIFACT_ID = "spring-boot-devtools";
    public static final String SPRING_BOOT_MAVEN_PLUGIN_ARTIFACT_ID = "spring-boot-maven-plugin";
    public static final String DEV_TOOLS_REMOTE_SECRET = "spring.devtools.remote.secret";
    public static final String DEV_TOOLS_REMOTE_SECRET_ENV = "SPRING_DEVTOOLS_REMOTE_SECRET";
    private static final String[] MANAGEMENT_PORT = new String[]{"management.port", "management.server.port"};
    private static final String[] SERVER_PORT = new String[]{"server.port", "server.port"};
    private static final String[] SERVER_KEYSTORE = new String[]{"server.ssl.key-store", "server.ssl.key-store"};
    private static final String[] MANAGEMENT_KEYSTORE = new String[]{"management.ssl.key-store", "management.server.ssl.key-store"};
    private static final String[] SERVLET_PATH = new String[]{"server.servlet-path", "server.servlet.path"};
    private static final String[] SERVER_CONTEXT_PATH = new String[]{"server.context-path", "server.servlet.context-path"};
    private static final String[] MANAGEMENT_CONTEXT_PATH = new String[]{"management.context-path", "management.server.servlet.context-path"};
    private static final String[] ACTUATOR_BASE_PATH = new String[]{"", "management.endpoints.web.base-path"};
    private static final String[] ACTUATOR_DEFAULT_BASE_PATH = new String[]{"", "/actuator"};
    private int propertyOffset;
    private static final int DEFAULT_SERVER_PORT = 8080;

    public SpringBootConfigurationHelper(Optional<String> springBootVersion) {
        this.propertyOffset = this.propertyOffset(springBootVersion);
    }

    public String getManagementPortPropertyKey() {
        return this.lookup(MANAGEMENT_PORT);
    }

    public Integer getManagementPort(Properties properties) {
        String value = properties.getProperty(this.getManagementPortPropertyKey());
        return value != null ? Integer.valueOf(Integer.parseInt(value)) : null;
    }

    public String getServerPortPropertyKey() {
        return this.lookup(SERVER_PORT);
    }

    public Integer getServerPort(Properties properties) {
        String value = properties.getProperty(this.getServerPortPropertyKey());
        return value != null ? Integer.parseInt(value) : 8080;
    }

    public String getServerKeystorePropertyKey() {
        return this.lookup(SERVER_KEYSTORE);
    }

    public String getManagementKeystorePropertyKey() {
        return this.lookup(MANAGEMENT_KEYSTORE);
    }

    public String getServletPathPropertyKey() {
        return this.lookup(SERVLET_PATH);
    }

    public String getServerContextPathPropertyKey() {
        return this.lookup(SERVER_CONTEXT_PATH);
    }

    public String getManagementContextPathPropertyKey() {
        return this.lookup(MANAGEMENT_CONTEXT_PATH);
    }

    public String getActuatorBasePathPropertyKey() {
        return this.lookup(ACTUATOR_BASE_PATH);
    }

    public String getActuatorDefaultBasePath() {
        return this.lookup(ACTUATOR_DEFAULT_BASE_PATH);
    }

    private String lookup(String[] keys) {
        return keys[this.propertyOffset];
    }

    private int propertyOffset(Optional<String> springBootVersion) {
        Optional<Integer> majorVersion = this.majorVersion(springBootVersion);
        int idx = majorVersion.map(v -> v - 1).orElse(0);
        idx = Math.min(idx, 1);
        idx = Math.max(idx, 0);
        return idx;
    }

    private Optional<Integer> majorVersion(Optional<String> version) {
        if (version.isPresent()) {
            try {
                return Optional.of(Integer.parseInt(version.get().substring(0, version.get().indexOf(46))));
            }
            catch (Exception e) {
                LOG.warn("Cannot spring boot major version from {}", version);
            }
        }
        return Optional.empty();
    }
}

