/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.PropertiesUtil;
import org.eclipse.jkube.kit.common.util.YamlUtil;

public class SpringBootUtil {
    private SpringBootUtil() {
    }

    public static Properties getSpringBootApplicationProperties(URLClassLoader compileClassLoader) {
        return SpringBootUtil.getSpringBootApplicationProperties(null, compileClassLoader);
    }

    public static Properties getSpringBootApplicationProperties(String springActiveProfile, URLClassLoader compileClassLoader) {
        URL ymlResource = compileClassLoader.findResource("application.yml");
        URL propertiesResource = compileClassLoader.findResource("application.properties");
        Properties props = SpringBootUtil.getPropertiesFromApplicationYamlResource(springActiveProfile, ymlResource);
        props.putAll((Map<?, ?>)PropertiesUtil.getPropertiesFromResource(propertiesResource));
        return props;
    }

    public static Properties getPropertiesFromApplicationYamlResource(String springActiveProfile, URL ymlResource) {
        return YamlUtil.getPropertiesFromYamlResource(springActiveProfile, ymlResource);
    }

    public static Optional<String> getSpringBootDevToolsVersion(JavaProject mavenProject) {
        return SpringBootUtil.getSpringBootVersion(mavenProject);
    }

    public static Optional<String> getSpringBootVersion(JavaProject mavenProject) {
        return Optional.ofNullable(JKubeProjectUtil.getAnyDependencyVersionWithGroupId(mavenProject, "org.springframework.boot"));
    }

    public static String getSpringBootActiveProfile(JavaProject project) {
        if (project != null && project.getProperties() != null && project.getProperties().get("spring.profiles.active") != null) {
            return project.getProperties().get("spring.profiles.active").toString();
        }
        return null;
    }
}

