/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.HasMetadataComparator;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.openshift.api.model.Template;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.ResourceFileType;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.kit.common.util.OpenshiftHelper;

public class ResourceUtil {
    private ResourceUtil() {
    }

    public static List<HasMetadata> deserializeKubernetesListOrTemplate(File manifest) throws IOException {
        if (!manifest.isFile() || !manifest.exists()) {
            return Collections.emptyList();
        }
        ArrayList<HasMetadata> kubernetesResources = new ArrayList<HasMetadata>();
        try (InputStream fis = Files.newInputStream(manifest.toPath(), new OpenOption[0]);){
            kubernetesResources.addAll(ResourceUtil.split(Serialization.unmarshal((InputStream)fis, Collections.emptyMap())));
        }
        kubernetesResources.sort((Comparator<HasMetadata>)new HasMetadataComparator());
        return kubernetesResources;
    }

    private static List<HasMetadata> split(Object resource) throws IOException {
        if (resource instanceof Collection) {
            ArrayList<HasMetadata> collectionItems = new ArrayList<HasMetadata>();
            for (Object item : (Collection)resource) {
                collectionItems.addAll(ResourceUtil.split(item));
            }
            return collectionItems;
        }
        if (resource instanceof KubernetesList) {
            return ((KubernetesList)resource).getItems();
        }
        if (resource instanceof Template) {
            return Optional.ofNullable(OpenshiftHelper.processTemplatesLocally((Template)resource, false)).map(KubernetesList::getItems).orElse(Collections.emptyList());
        }
        if (resource instanceof HasMetadata) {
            return Collections.singletonList((HasMetadata)resource);
        }
        return Collections.emptyList();
    }

    public static <T extends KubernetesResource> T load(File file, Class<T> clazz) throws IOException {
        return (T)((KubernetesResource)Serialization.unmarshal((InputStream)Files.newInputStream(file.toPath(), new OpenOption[0]), clazz));
    }

    public static File save(File file, Object data) throws IOException {
        return ResourceUtil.save(file, data, ResourceFileType.fromFile(file));
    }

    public static File save(File file, Object data, ResourceFileType type) throws IOException {
        boolean hasExtension = FilenameUtils.indexOfExtension((String)file.getAbsolutePath()) != -1;
        File output = hasExtension ? file : type.addExtensionIfMissing(file);
        FileUtil.createDirectory(file.getParentFile());
        ResourceUtil.getObjectMapper(type).writeValue(output, data);
        return output;
    }

    public static String toJson(Object resource) throws JsonProcessingException {
        return ResourceUtil.serializeAsString(resource, ResourceFileType.json);
    }

    private static String serializeAsString(Object resource, ResourceFileType resourceFileType) throws JsonProcessingException {
        return ResourceUtil.getObjectMapper(resourceFileType).writeValueAsString(resource);
    }

    private static ObjectMapper getObjectMapper(ResourceFileType resourceFileType) {
        return resourceFileType.getObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).disable(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS).disable(SerializationFeature.WRITE_NULL_MAP_VALUES);
    }

    public static List<File> getFinalResourceDirs(File resourceDir, String environmentAsCommaSeparateStr) {
        ArrayList<File> resourceDirs = new ArrayList<File>();
        if (resourceDir != null && StringUtils.isNotBlank((CharSequence)environmentAsCommaSeparateStr)) {
            String[] environments;
            for (String environment : environments = environmentAsCommaSeparateStr.split(",")) {
                resourceDirs.add(new File(resourceDir, environment.trim()));
            }
        } else if (StringUtils.isBlank((CharSequence)environmentAsCommaSeparateStr)) {
            resourceDirs.add(resourceDir);
        }
        return resourceDirs;
    }

    static {
        Serialization.UNMATCHED_FIELD_TYPE_MODULE.setRestrictToTemplates(false);
        Serialization.UNMATCHED_FIELD_TYPE_MODULE.setLogWarnings(false);
        for (ObjectMapper mapper : new ObjectMapper[]{Serialization.jsonMapper(), Serialization.yamlMapper()}) {
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
        ((YAMLFactory)Serialization.yamlMapper().getFactory()).configure(YAMLGenerator.Feature.MINIMIZE_QUOTES, true).configure(YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS, true);
    }
}

