/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;

public class JKubeFileInterpolator {
    public static final String DEFAULT_FILTER = "${*}";

    private JKubeFileInterpolator() {
    }

    public static String interpolate(File file, Properties properties, String filter) throws IOException {
        StringBuilder ret = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                ret.append(JKubeFileInterpolator.interpolate(line, properties, filter != null ? filter : DEFAULT_FILTER)).append(System.lineSeparator());
            }
        }
        return ret.toString();
    }

    public static String interpolate(String line, Properties properties, String filter) {
        return JKubeFileInterpolator.interpolate(line, properties, JKubeFileInterpolator.getExpressionMarkersFromFilter(filter));
    }

    static String interpolate(String line, Properties properties, Map<String, String> expressionMarkers) {
        return JKubeFileInterpolator.checkForPropertiesInLine(line, properties, expressionMarkers);
    }

    static Map<String, String> getExpressionMarkersFromFilter(String filter) {
        HashMap<String, String> expressionMarkers = new HashMap<String, String>();
        if (filter != null && !filter.isEmpty() && !filter.equalsIgnoreCase("false")) {
            String[] filterParts;
            if (filter.length() == 1) {
                expressionMarkers.put(filter, filter);
            }
            if (filter.length() > 1 && filter.contains("*") && (filterParts = filter.split("\\*")).length == 2) {
                expressionMarkers.put(filterParts[0], filterParts[1]);
            }
        }
        return expressionMarkers;
    }

    private static String checkForPropertiesInLine(String line, Properties properties, Map<String, String> delimiters) {
        String value;
        for (String property : properties.stringPropertyNames()) {
            value = JKubeFileInterpolator.checkPropertyWithDelimiters(line, property, JKubeFileInterpolator.getPropertyAsMap(properties), delimiters);
            if (StringUtils.isEmpty((CharSequence)value)) continue;
            line = value;
        }
        for (String property : System.getProperties().stringPropertyNames()) {
            value = JKubeFileInterpolator.checkPropertyWithDelimiters(line, property, JKubeFileInterpolator.getPropertyAsMap(properties), delimiters);
            if (StringUtils.isEmpty((CharSequence)value)) continue;
            line = value;
        }
        Map<String, String> environmentVariables = System.getenv();
        for (Map.Entry<String, String> e : environmentVariables.entrySet()) {
            String value2 = JKubeFileInterpolator.checkPropertyWithDelimiters(line, e.getKey(), environmentVariables, delimiters);
            if (StringUtils.isEmpty((CharSequence)value2)) continue;
            line = value2;
        }
        return line;
    }

    private static String checkPropertyWithDelimiters(String line, String property, Map<String, String> properties, Map<String, String> expressionMarkers) {
        for (Map.Entry<String, String> delimiter : expressionMarkers.entrySet()) {
            String searchPhrase = !property.contains(delimiter.getKey()) && !property.contains(delimiter.getValue()) ? delimiter.getKey() + property + delimiter.getValue() : property;
            if (line == null || !line.contains(searchPhrase)) continue;
            if (JKubeFileInterpolator.isExpressionCycle(properties, expressionMarkers, property)) {
                throw new IllegalArgumentException("Expression cycle detected, aborting.");
            }
            return JKubeFileInterpolator.replaceWithEscapeStr(line, searchPhrase, properties.get(property));
        }
        return "";
    }

    private static boolean isExpressionCycle(Map<String, String> properties, Map<String, String> expressionMarkers, String property) {
        String value = properties.get(property);
        if (properties.get(value) != null) {
            return true;
        }
        if (value != null) {
            value = JKubeFileInterpolator.parsePropertyKey(value, expressionMarkers);
        }
        return properties.get(value) != null;
    }

    private static String parsePropertyKey(String property, Map<String, String> expressionMarkers) {
        for (Map.Entry<String, String> entry : expressionMarkers.entrySet()) {
            if (!property.contains(entry.getKey())) continue;
            property = property.substring(entry.getKey().length(), property.length() - entry.getValue().length());
        }
        return property;
    }

    private static Map<String, String> getPropertyAsMap(Properties properties) {
        HashMap<String, String> propertyAsMap = new HashMap<String, String>();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            if (v instanceof String) {
                propertyAsMap.put((String)k, (String)v);
            }
        }));
        return propertyAsMap;
    }

    private static String replaceWithEscapeStr(String line, String searchPhrase, String value) {
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        while (i < line.length()) {
            String searchSubStr;
            if (line.charAt(i) == searchPhrase.charAt(0) && i + searchPhrase.length() <= line.length() && searchPhrase.equals(searchSubStr = line.substring(i, i + searchPhrase.length()))) {
                stringBuilder.append(value);
                i += searchPhrase.length();
                continue;
            }
            stringBuilder.append(line.charAt(i));
            ++i;
        }
        return stringBuilder.toString();
    }
}

