/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class RegistryServerConfiguration
implements Serializable {
    private static final long serialVersionUID = -5916500916284810117L;
    private String id;
    private String username;
    private String password;
    private Map<String, Object> configuration;

    public static RegistryServerConfiguration getServer(List<RegistryServerConfiguration> settings, String serverId) {
        if (settings != null && !StringUtils.isBlank((CharSequence)serverId)) {
            for (RegistryServerConfiguration registryServerConfiguration : settings) {
                if (!registryServerConfiguration.getId().equalsIgnoreCase(serverId)) continue;
                return registryServerConfiguration;
            }
        }
        return null;
    }

    public static List<RegistryServerConfiguration> fetchListFromMap(Map<String, AbstractMap.SimpleEntry<AbstractMap.SimpleEntry<String, String>, Map<String, Object>>> registryServerConfigurationMap) {
        ArrayList<RegistryServerConfiguration> registryServerConfigurationList = new ArrayList<RegistryServerConfiguration>();
        for (Map.Entry<String, AbstractMap.SimpleEntry<AbstractMap.SimpleEntry<String, String>, Map<String, Object>>> entry : registryServerConfigurationMap.entrySet()) {
            registryServerConfigurationList.add(new RegistryServerConfiguration(entry.getKey(), entry.getValue().getKey().getKey(), entry.getValue().getKey().getValue(), entry.getValue().getValue()));
        }
        return registryServerConfigurationList;
    }

    public static RegistryServerConfigurationBuilder builder() {
        return new RegistryServerConfigurationBuilder();
    }

    public RegistryServerConfiguration(String id, String username, String password, Map<String, Object> configuration) {
        this.id = id;
        this.username = username;
        this.password = password;
        this.configuration = configuration;
    }

    public RegistryServerConfiguration() {
    }

    public String getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setConfiguration(Map<String, Object> configuration) {
        this.configuration = configuration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegistryServerConfiguration)) {
            return false;
        }
        RegistryServerConfiguration other = (RegistryServerConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        Map<String, Object> this$configuration = this.getConfiguration();
        Map<String, Object> other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegistryServerConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        Map<String, Object> $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        return result;
    }

    public static class RegistryServerConfigurationBuilder {
        private String id;
        private String username;
        private String password;
        private Map<String, Object> configuration;

        RegistryServerConfigurationBuilder() {
        }

        public RegistryServerConfigurationBuilder id(String id) {
            this.id = id;
            return this;
        }

        public RegistryServerConfigurationBuilder username(String username) {
            this.username = username;
            return this;
        }

        public RegistryServerConfigurationBuilder password(String password) {
            this.password = password;
            return this;
        }

        public RegistryServerConfigurationBuilder configuration(Map<String, Object> configuration) {
            this.configuration = configuration;
            return this;
        }

        public RegistryServerConfiguration build() {
            return new RegistryServerConfiguration(this.id, this.username, this.password, this.configuration);
        }

        public String toString() {
            return "RegistryServerConfiguration.RegistryServerConfigurationBuilder(id=" + this.id + ", username=" + this.username + ", password=" + this.password + ", configuration=" + this.configuration + ")";
        }
    }
}

