/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class AsyncUtil {
    private AsyncUtil() {
    }

    public static <T> CompletableFuture<T> async(Callable<T> callable) {
        CompletableFuture future = new CompletableFuture();
        CompletableFuture.runAsync(() -> {
            try {
                future.complete(callable.call());
            }
            catch (Exception ex) {
                future.completeExceptionally(ex);
            }
        }, ExecutorServiceHolder.INSTANCE);
        future.whenComplete((result, throwable) -> {
            if (!future.isDone()) {
                future.cancel(true);
            }
        });
        return future;
    }

    public static <T> Function<Predicate<T>, CompletableFuture<T>> await(Supplier<T> supplier) {
        return predicate -> AsyncUtil.async(() -> AsyncUtil.lambda$null$2(predicate, (Supplier)supplier));
    }

    private static /* synthetic */ Object lambda$null$2(Predicate predicate, Supplier supplier) throws Exception {
        Object ret;
        while (!predicate.test(ret = supplier.get())) {
            Thread.sleep(100L);
        }
        return ret;
    }

    private static class ExecutorServiceHolder {
        public static final ExecutorService INSTANCE = Executors.newCachedThreadPool();

        private ExecutorServiceHolder() {
        }
    }
}

