/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class EnvUtil {
    public static final String MAVEN_PROPERTY_REGEXP = "\\s*\\$\\{\\s*([^}]+)\\s*}\\s*$";
    public static final String DOCKER_HTTP_PORT = "2375";
    public static final String PROPERTY_COMBINE_POLICY_SUFFIX = "_combine";
    private static final String COMMA = ",";
    private static final String WHITESPACE = " ";
    private static final String COMMA_WHITESPACE = ", ";
    private static UnaryOperator<String> envGetter = System::getenv;
    private static UnaryOperator<String> propertyGetter = System::getProperty;
    private static final Function<String, String[]> SPLIT_ON_LAST_COLON = element -> {
        int colon = element.lastIndexOf(58);
        if (colon < 0) {
            return new String[]{element, element};
        }
        return new String[]{element.substring(0, colon), element.substring(colon + 1)};
    };
    private static final Function<String, List<String>> COMMA_SPLITTER = input -> Arrays.stream(input.split(COMMA)).filter(StringUtils::isNotBlank).map(StringUtils::trim).collect(Collectors.toList());

    private EnvUtil() {
    }

    public static void overrideEnvGetter(UnaryOperator<String> getter) {
        envGetter = getter;
    }

    public static void overridePropertyGetter(UnaryOperator<String> propsGetter) {
        propertyGetter = propsGetter;
    }

    public static String convertTcpToHttpUrl(String connect) {
        String protocol = connect.contains(":2375") ? "http:" : "https:";
        return connect.replaceFirst("^tcp:", protocol);
    }

    public static String extractLargerVersion(String versionA, String versionB) {
        if (versionB == null || versionA == null) {
            return versionA == null ? versionB : versionA;
        }
        boolean isVersionAValid = EnvUtil.isValid(versionA);
        boolean isVersionBValid = EnvUtil.isValid(versionB);
        if (!isVersionAValid && !isVersionBValid) {
            return null;
        }
        if (isVersionAValid && isVersionBValid) {
            String[] partsA = versionA.split("\\.");
            String[] partsB = versionB.split("\\.");
            for (int i = 0; i < Math.min(partsA.length, partsB.length); ++i) {
                int pB;
                int pA = Integer.parseInt(partsA[i]);
                if (pA > (pB = Integer.parseInt(partsB[i]))) {
                    return versionA;
                }
                if (pB <= pA) continue;
                return versionB;
            }
            return partsA.length > partsB.length ? versionA : versionB;
        }
        return isVersionAValid ? versionA : versionB;
    }

    private static boolean isValid(String version) {
        if (StringUtils.isNotBlank((CharSequence)version) && version.contains(".")) {
            try {
                version = version.replace(".", "");
                Integer.parseInt(version);
                return true;
            }
            catch (NumberFormatException exception) {
                return false;
            }
        }
        return false;
    }

    public static boolean greaterOrEqualsVersion(String versionA, String versionB) {
        String largerVersion = EnvUtil.extractLargerVersion(versionA, versionB);
        return largerVersion != null && largerVersion.equals(versionA);
    }

    public static List<String[]> splitOnLastColon(List<String> listToSplit) {
        if (listToSplit != null) {
            return listToSplit.stream().map(SPLIT_ON_LAST_COLON).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Nonnull
    public static List<String> removeEmptyEntries(@Nullable List<String> input) {
        if (input == null) {
            return Collections.emptyList();
        }
        return input.stream().filter(StringUtils::isNotBlank).map(StringUtils::trim).collect(Collectors.toList());
    }

    @Nonnull
    public static List<String> splitAtCommasAndTrim(Iterable<String> input) {
        if (input == null) {
            return Collections.emptyList();
        }
        return StreamSupport.stream(input.spliterator(), false).filter(StringUtils::isNotBlank).map(COMMA_SPLITTER).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static String[] splitOnSpaceWithEscape(String toSplit) {
        String[] split = toSplit.split("(?<!" + Pattern.quote("\\") + ")\\s+");
        String[] res = new String[split.length];
        for (int i = 0; i < split.length; ++i) {
            res[i] = split[i].replaceAll("\\\\ ", WHITESPACE);
        }
        return res;
    }

    public static String stringJoin(List list, String separator) {
        StringBuilder ret = new StringBuilder();
        boolean first = true;
        for (Object o : list) {
            if (!first) {
                ret.append(separator);
            }
            ret.append(o);
            first = false;
        }
        return ret.toString();
    }

    public static Map<String, String> extractFromPropertiesAsMap(String prefix, Properties properties) {
        HashMap<String, String> ret = new HashMap<String, String>();
        Enumeration<?> names = properties.propertyNames();
        String prefixP = prefix + ".";
        while (names.hasMoreElements()) {
            String mapKey;
            String propName = (String)names.nextElement();
            if (!EnvUtil.propMatchesPrefix(prefixP, propName) || PROPERTY_COMBINE_POLICY_SUFFIX.equals(mapKey = propName.substring(prefixP.length()))) continue;
            ret.put(mapKey, properties.getProperty(propName));
        }
        return ret.size() > 0 ? ret : null;
    }

    public static List<String> extractFromPropertiesAsList(String prefix, Properties properties) {
        TreeMap<Integer, String> orderedMap = new TreeMap<Integer, String>();
        ArrayList<String> rest = new ArrayList<String>();
        Enumeration<?> names = properties.propertyNames();
        String prefixP = prefix + ".";
        while (names.hasMoreElements()) {
            String index;
            String key = (String)names.nextElement();
            if (!EnvUtil.propMatchesPrefix(prefixP, key) || PROPERTY_COMBINE_POLICY_SUFFIX.equals(index = key.substring(prefixP.length()))) continue;
            String value = properties.getProperty(key);
            try {
                Integer nrIndex = Integer.parseInt(index);
                orderedMap.put(nrIndex, value);
            }
            catch (NumberFormatException exp) {
                rest.add(value);
            }
        }
        ArrayList<String> ret = new ArrayList<String>(orderedMap.values());
        ret.addAll(rest);
        return !ret.isEmpty() ? ret : null;
    }

    public static String extractMavenPropertyName(String propName) {
        Matcher matcher = Pattern.compile(MAVEN_PROPERTY_REGEXP).matcher(propName);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String fixupPath(String path) {
        Pattern pattern = Pattern.compile("^(?i)([A-Z]):(.*)$");
        Matcher matcher = pattern.matcher(path);
        if (matcher.matches()) {
            String result = "/" + matcher.group(1).toLowerCase() + matcher.group(2);
            return result.replace("\\", "/");
        }
        return path;
    }

    public static String formatDurationTill(long start) {
        long duration = System.currentTimeMillis() - start;
        StringBuilder res = new StringBuilder();
        TimeUnit current = TimeUnit.HOURS;
        while (duration > 0L) {
            long temp = current.convert(duration, TimeUnit.MILLISECONDS);
            if (temp > 0L) {
                duration -= current.toMillis(temp);
                res.append(temp).append(WHITESPACE).append(current.name().toLowerCase());
                if (temp < 2L) {
                    res.deleteCharAt(res.length() - 1);
                }
                res.append(COMMA_WHITESPACE);
            }
            if (current == TimeUnit.SECONDS) break;
            current = TimeUnit.values()[current.ordinal() - 1];
        }
        if (res.lastIndexOf(COMMA_WHITESPACE) < 0) {
            return duration + WHITESPACE + TimeUnit.MILLISECONDS.name().toLowerCase();
        }
        res.deleteCharAt(res.length() - 2);
        int i = res.lastIndexOf(COMMA_WHITESPACE);
        if (i > 0) {
            res.deleteCharAt(i);
            res.insert(i, " and");
        }
        return res.toString();
    }

    private static boolean propMatchesPrefix(String prefix, String key) {
        return key.startsWith(prefix) && key.length() >= prefix.length();
    }

    public static String firstRegistryOf(String ... checkFirst) {
        for (String registry : checkFirst) {
            if (registry == null) continue;
            return registry;
        }
        return EnvUtil.getEnv("DOCKER_REGISTRY");
    }

    public static String ensureRegistryHttpUrl(String registry) {
        if (registry.toLowerCase().startsWith("http")) {
            return registry;
        }
        return "https://" + registry;
    }

    public static File prepareAbsoluteOutputDirPath(String outputDirectory, String projectBaseDir, String dir, String path) {
        return EnvUtil.prepareAbsolutePath(projectBaseDir, new File(outputDirectory, dir).toString(), path);
    }

    public static File prepareAbsoluteSourceDirPath(String sourceDirectory, String projectBaseDir, String path) {
        return EnvUtil.prepareAbsolutePath(projectBaseDir, sourceDirectory, path);
    }

    private static File prepareAbsolutePath(String projectBaseDir, String directory, String path) {
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(new File(projectBaseDir, directory), path);
    }

    public static void storeTimestamp(File tsFile, Date buildDate) throws IOException {
        try {
            Files.deleteIfExists(tsFile.toPath());
            File dir = tsFile.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) {
                throw new IOException("Cannot create directory " + dir);
            }
            Files.write(tsFile.toPath(), Long.toString(buildDate.getTime()).getBytes(StandardCharsets.US_ASCII), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IOException("Cannot create " + tsFile + " for storing time " + buildDate.getTime(), e);
        }
    }

    public static Date loadTimestamp(File tsFile) throws IOException {
        try {
            if (tsFile.exists()) {
                String ts = new String(Files.readAllBytes(tsFile.toPath()), StandardCharsets.US_ASCII);
                return new Date(Long.parseLong(ts));
            }
            return null;
        }
        catch (IOException e) {
            throw new IOException("Cannot read timestamp " + tsFile, e);
        }
    }

    public static boolean isWindows() {
        return EnvUtil.getProperty("os.name").toLowerCase().contains("windows");
    }

    public static File getUserHome() {
        String homeDir = EnvUtil.getProperty("user.home");
        if (homeDir == null) {
            homeDir = EnvUtil.getEnv("HOME");
        }
        return new File(homeDir);
    }

    public static String getEnv(String variableName) {
        return (String)envGetter.apply(variableName);
    }

    public static String getProperty(String propertyName) {
        return (String)propertyGetter.apply(propertyName);
    }

    public static String getEnvVarOrSystemProperty(String varName, String defaultValue) {
        return EnvUtil.getEnvVarOrSystemProperty(varName, varName, defaultValue);
    }

    public static String getEnvVarOrSystemProperty(String envVarName, String systemProperty, String defaultValue) {
        String ret = EnvUtil.getEnv(envVarName);
        if (StringUtils.isNotBlank((CharSequence)ret)) {
            return ret;
        }
        return Optional.ofNullable(EnvUtil.getProperty(systemProperty)).orElse(defaultValue);
    }

    public static String getProcessorArchitecture() {
        return EnvUtil.getProperty("os.arch");
    }

    public static boolean isMacOs() {
        return EnvUtil.getProperty("os.name").toLowerCase().contains("mac");
    }

    public static File findBinaryFileInUserPath(String binaryName) {
        String userPath = EnvUtil.getEnv("PATH");
        if (userPath != null) {
            return Arrays.stream(userPath.split(File.pathSeparator)).map(p -> new File((String)p, binaryName)).filter(f -> f.isFile() && f.exists()).findFirst().orElse(null);
        }
        return null;
    }
}

