/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.Dependency;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.Plugin;
import org.eclipse.jkube.kit.common.util.ClassUtil;

public class JKubeProjectUtil {
    public static final int MAX_RESOURCE_NAME_LENGTH = 63;

    private JKubeProjectUtil() {
    }

    public static <T> Optional<T> iterateOverListWithCondition(List<T> dependencyList, Predicate<? super T> condition) {
        if (dependencyList == null) {
            return Optional.empty();
        }
        return dependencyList.stream().filter(Objects::nonNull).filter(condition).findFirst();
    }

    public static String getAnyDependencyVersionWithGroupId(JavaProject jkubeProject, String groupId) {
        Optional<Dependency> value = JKubeProjectUtil.iterateOverListWithCondition(jkubeProject.getDependencies(), dependency -> dependency.getGroupId().equals(groupId));
        return value.map(Dependency::getVersion).orElse(null);
    }

    public static Plugin getPlugin(JavaProject javaProject, String groupId, String artifactId) {
        Optional<Plugin> value = JKubeProjectUtil.iterateOverListWithCondition(javaProject.getPlugins(), plugin -> plugin.getGroupId().equals(groupId) && plugin.getArtifactId().equals(artifactId));
        return value.orElse(null);
    }

    public static Plugin getPlugin(JavaProject jkubeProject, String artifactId) {
        Optional<Plugin> value = JKubeProjectUtil.iterateOverListWithCondition(jkubeProject.getPlugins(), plugin -> plugin.getArtifactId().equals(artifactId));
        return value.orElse(null);
    }

    public static boolean hasPlugin(JavaProject jkubeProject, String groupId, String artifactId) {
        return JKubeProjectUtil.getPlugin(jkubeProject, groupId, artifactId) != null;
    }

    public static boolean hasPluginOfAnyArtifactId(JavaProject jkubeProject, String artifactId) {
        return JKubeProjectUtil.getPlugin(jkubeProject, artifactId) != null;
    }

    public static boolean hasGradlePlugin(JavaProject javaProject, String pluginClassName) {
        return Optional.ofNullable(javaProject.getGradlePlugins()).map(classes -> classes.contains(pluginClassName)).orElse(false);
    }

    public static boolean hasDependency(JavaProject jkubeProject, String groupId, String artifactId) {
        return JKubeProjectUtil.getDependency(jkubeProject, groupId, artifactId) != null;
    }

    public static boolean hasTransitiveDependency(JavaProject javaProject, String groupId, String artifactId) {
        return JKubeProjectUtil.getTransitiveDependency(javaProject, groupId, artifactId) != null;
    }

    public static boolean hasDependencyWithGroupId(JavaProject project, String groupId) {
        return Optional.ofNullable(project).map(JavaProject::getDependencies).map(deps -> deps.stream().anyMatch(dep -> Objects.equals(dep.getGroupId(), groupId))).orElse(false);
    }

    public static Dependency getTransitiveDependency(JavaProject javaProject, String groupId, String artifactId) {
        return JKubeProjectUtil.getDependencyByGroupArtifact(javaProject.getDependenciesWithTransitive(), groupId, artifactId);
    }

    public static Dependency getDependency(JavaProject jkubeProject, String groupId, String artifactId) {
        return JKubeProjectUtil.getDependencyByGroupArtifact(jkubeProject.getDependencies(), groupId, artifactId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasResource(JavaProject project, String ... paths) throws IOException {
        try (URLClassLoader compileClassLoader = JKubeProjectUtil.getClassLoader(project);){
            String[] stringArray = paths;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                if (compileClassLoader.getResource(path) != null) {
                    boolean bl = true;
                    return bl;
                }
                ++n2;
            }
            return false;
        }
        catch (NullPointerException e) {
            throw new IOException("Path to resource was null", e);
        }
    }

    public static Properties getPropertiesWithSystemOverrides(JavaProject project) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)project.getProperties());
        properties.putAll((Map<?, ?>)System.getProperties());
        return properties;
    }

    public static File getFinalOutputArtifact(JavaProject jkubeProject) {
        String inferredArtifactName = jkubeProject.getBuildFinalName() == null ? String.format("%s-%s.%s", jkubeProject.getArtifactId(), jkubeProject.getVersion(), jkubeProject.getPackaging()) : String.format("%s.%s", jkubeProject.getBuildFinalName(), jkubeProject.getPackaging());
        File inferredArtifact = new File(jkubeProject.getBuildDirectory(), inferredArtifactName);
        if (inferredArtifact.exists()) {
            return inferredArtifact;
        }
        if (jkubeProject.getArtifact() != null && jkubeProject.getArtifact().exists()) {
            return jkubeProject.getArtifact();
        }
        return null;
    }

    public static String createDefaultResourceName(String artifactId, String ... suffixes) {
        String suffix = StringUtils.join((Object[])suffixes, (String)"-");
        String ret = artifactId + (suffix.length() > 0 ? "-" + suffix : "");
        if (ret.length() > 63) {
            ret = ret.substring(0, 63);
        }
        return ret.toLowerCase();
    }

    public static URLClassLoader getClassLoader(JavaProject jKubeProject) {
        return ClassUtil.createClassLoader(jKubeProject.getCompileClassPathElements(), jKubeProject.getOutputDirectory().getAbsolutePath());
    }

    public static String getProperty(String key, JavaProject project) {
        String value = System.getProperty(key);
        if (value == null) {
            value = project.getProperties().getProperty(key);
        }
        return value;
    }

    public static File resolveArtifact(JavaProject project, String groupId, String artifactId, String version, String type) {
        File artifact = project.getDependencies().stream().filter(d -> d.getGroupId().equals(groupId) && d.getArtifactId().equals(artifactId) && d.getVersion().equals(version) && d.getType().equals(type)).findFirst().map(Dependency::getFile).orElse(null);
        if (artifact == null) {
            throw new IllegalStateException("Cannot find artifact " + String.format("%s-%s.%s", artifactId, version, type) + " within the resolved resources");
        }
        return artifact;
    }

    private static Dependency getDependencyByGroupArtifact(List<Dependency> dependencyList, String groupId, String artifactId) {
        if (dependencyList != null) {
            return JKubeProjectUtil.iterateOverListWithCondition(dependencyList, dependency -> Objects.equals(dependency.getGroupId(), groupId) && Objects.equals(dependency.getArtifactId(), artifactId)).orElse(null);
        }
        return null;
    }
}

