/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.archive;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.eclipse.jkube.kit.common.util.FileUtil;

public class ArchiveDecompressor {
    private static final String ERROR_MESSAGE = "Unsupported archive file provided";

    private ArchiveDecompressor() {
    }

    public static void extractArchive(File inputFile, File targetDirectory) throws IOException {
        try (InputStream fis = Files.newInputStream(inputFile.toPath(), new OpenOption[0]);){
            ArchiveDecompressor.extractArchive(fis, targetDirectory);
        }
    }

    public static void extractArchive(InputStream archiveInputStream, File targetDirectory) throws IOException {
        block14: {
            try (BufferedInputStream bis = new BufferedInputStream(archiveInputStream);){
                if (ArchiveDecompressor.isCompressedFile(bis)) {
                    ArchiveDecompressor.extractCompressedFile(bis, targetDirectory);
                    break block14;
                }
                if (ArchiveDecompressor.isArchive(bis)) {
                    ArchiveDecompressor.extractArchiveContents(bis, targetDirectory);
                    break block14;
                }
                throw new IllegalArgumentException(ERROR_MESSAGE);
            }
        }
    }

    private static void extractCompressedFile(InputStream is, File targetDirectory) throws IOException {
        block27: {
            try (CompressorInputStream cis = new CompressorStreamFactory().createCompressorInputStream(is);
                 BufferedInputStream bis = new BufferedInputStream((InputStream)cis);){
                if (ArchiveDecompressor.isArchive(bis)) {
                    ArchiveDecompressor.extractArchiveContents(bis, targetDirectory);
                    break block27;
                }
                throw new IllegalArgumentException(ERROR_MESSAGE);
            }
            catch (CompressorException ex) {
                throw new IllegalArgumentException(ERROR_MESSAGE, ex);
            }
        }
    }

    private static void extractArchiveContents(InputStream is, File targetDirectory) throws IOException {
        if (targetDirectory.exists() && !targetDirectory.isDirectory()) {
            throw new IllegalArgumentException("Target directory is not a directory");
        }
        if (targetDirectory.exists()) {
            FileUtil.cleanDirectory(targetDirectory);
        }
        FileUtil.createDirectory(targetDirectory);
        try (ArchiveInputStream ais = new ArchiveStreamFactory().createArchiveInputStream(is);){
            ArchiveEntry entry;
            while ((entry = ais.getNextEntry()) != null) {
                File extractTo = new File(targetDirectory, ArchiveDecompressor.fileName(entry.getName()));
                if (!extractTo.getCanonicalFile().toPath().startsWith(targetDirectory.getCanonicalFile().toPath())) continue;
                if (entry.isDirectory()) {
                    FileUtil.createDirectory(extractTo);
                    continue;
                }
                Files.copy((InputStream)ais, extractTo.toPath(), new CopyOption[0]);
            }
        }
        catch (ArchiveException ex) {
            throw new IllegalArgumentException(ERROR_MESSAGE, ex);
        }
    }

    private static boolean isCompressedFile(InputStream inputStream) {
        try {
            CompressorStreamFactory.detect((InputStream)inputStream);
            return true;
        }
        catch (CompressorException ex) {
            return false;
        }
    }

    private static boolean isArchive(InputStream inputStream) {
        try {
            ArchiveStreamFactory.detect((InputStream)inputStream);
            return true;
        }
        catch (ArchiveException ex) {
            return false;
        }
    }

    private static String fileName(String originalName) {
        return originalName.replace('/', File.separatorChar);
    }
}

