/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import java.util.Optional;
import java.util.Properties;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.SpringBootUtil;

public class SpringBootConfiguration {
    private static final String DEFAULT_SERVER_PORT = "8080";
    private Integer managementPort;
    private Integer serverPort;
    private String serverKeystore;
    private String managementKeystore;
    private String servletPath;
    private String serverContextPath;
    private String managementContextPath;
    private String actuatorBasePath;
    private String actuatorDefaultBasePath;
    private boolean managementHealthProbesEnabled;

    public static SpringBootConfiguration from(JavaProject project) {
        Properties properties = SpringBootUtil.getSpringBootApplicationProperties(SpringBootUtil.getSpringBootActiveProfile(project), JKubeProjectUtil.getClassLoader(project));
        int majorVersion = SpringBootUtil.getSpringBootVersion(project).map(semVer -> {
            try {
                return Integer.parseInt(semVer.substring(0, semVer.indexOf(46)));
            }
            catch (Exception e) {
                return null;
            }
        }).orElse(1);
        SpringBootConfigurationBuilder configBuilder = SpringBootConfiguration.builder();
        configBuilder.managementPort(Optional.ofNullable(properties.getProperty("management.port")).map(Integer::parseInt).orElse(null)).serverPort(Integer.parseInt(properties.getProperty("server.port", DEFAULT_SERVER_PORT))).serverKeystore(properties.getProperty("server.ssl.key-store")).managementHealthProbesEnabled(Boolean.parseBoolean(properties.getProperty("management.health.probes.enabled"))).managementKeystore(properties.getProperty("management.ssl.key-store")).servletPath(properties.getProperty("server.servlet-path")).serverContextPath(properties.getProperty("server.context-path")).managementContextPath(properties.getProperty("management.context-path")).actuatorBasePath("").actuatorDefaultBasePath("");
        if (majorVersion > 1) {
            configBuilder.managementPort(Optional.ofNullable(properties.getProperty("management.server.port")).map(Integer::parseInt).orElse(null)).managementKeystore(properties.getProperty("management.server.ssl.key-store")).servletPath(properties.getProperty("server.servlet.path")).serverContextPath(properties.getProperty("server.servlet.context-path")).managementContextPath(properties.getProperty("management.server.servlet.context-path")).actuatorBasePath(properties.getProperty("management.endpoints.web.base-path")).actuatorDefaultBasePath("/actuator");
        }
        if (majorVersion == 3) {
            configBuilder.servletPath(properties.getProperty("spring.mvc.servlet.path")).managementContextPath(properties.getProperty("management.server.base-path"));
        }
        return configBuilder.build();
    }

    SpringBootConfiguration(Integer managementPort, Integer serverPort, String serverKeystore, String managementKeystore, String servletPath, String serverContextPath, String managementContextPath, String actuatorBasePath, String actuatorDefaultBasePath, boolean managementHealthProbesEnabled) {
        this.managementPort = managementPort;
        this.serverPort = serverPort;
        this.serverKeystore = serverKeystore;
        this.managementKeystore = managementKeystore;
        this.servletPath = servletPath;
        this.serverContextPath = serverContextPath;
        this.managementContextPath = managementContextPath;
        this.actuatorBasePath = actuatorBasePath;
        this.actuatorDefaultBasePath = actuatorDefaultBasePath;
        this.managementHealthProbesEnabled = managementHealthProbesEnabled;
    }

    public static SpringBootConfigurationBuilder builder() {
        return new SpringBootConfigurationBuilder();
    }

    public Integer getManagementPort() {
        return this.managementPort;
    }

    public Integer getServerPort() {
        return this.serverPort;
    }

    public String getServerKeystore() {
        return this.serverKeystore;
    }

    public String getManagementKeystore() {
        return this.managementKeystore;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getServerContextPath() {
        return this.serverContextPath;
    }

    public String getManagementContextPath() {
        return this.managementContextPath;
    }

    public String getActuatorBasePath() {
        return this.actuatorBasePath;
    }

    public String getActuatorDefaultBasePath() {
        return this.actuatorDefaultBasePath;
    }

    public boolean isManagementHealthProbesEnabled() {
        return this.managementHealthProbesEnabled;
    }

    public static class SpringBootConfigurationBuilder {
        private Integer managementPort;
        private Integer serverPort;
        private String serverKeystore;
        private String managementKeystore;
        private String servletPath;
        private String serverContextPath;
        private String managementContextPath;
        private String actuatorBasePath;
        private String actuatorDefaultBasePath;
        private boolean managementHealthProbesEnabled;

        SpringBootConfigurationBuilder() {
        }

        public SpringBootConfigurationBuilder managementPort(Integer managementPort) {
            this.managementPort = managementPort;
            return this;
        }

        public SpringBootConfigurationBuilder serverPort(Integer serverPort) {
            this.serverPort = serverPort;
            return this;
        }

        public SpringBootConfigurationBuilder serverKeystore(String serverKeystore) {
            this.serverKeystore = serverKeystore;
            return this;
        }

        public SpringBootConfigurationBuilder managementKeystore(String managementKeystore) {
            this.managementKeystore = managementKeystore;
            return this;
        }

        public SpringBootConfigurationBuilder servletPath(String servletPath) {
            this.servletPath = servletPath;
            return this;
        }

        public SpringBootConfigurationBuilder serverContextPath(String serverContextPath) {
            this.serverContextPath = serverContextPath;
            return this;
        }

        public SpringBootConfigurationBuilder managementContextPath(String managementContextPath) {
            this.managementContextPath = managementContextPath;
            return this;
        }

        public SpringBootConfigurationBuilder actuatorBasePath(String actuatorBasePath) {
            this.actuatorBasePath = actuatorBasePath;
            return this;
        }

        public SpringBootConfigurationBuilder actuatorDefaultBasePath(String actuatorDefaultBasePath) {
            this.actuatorDefaultBasePath = actuatorDefaultBasePath;
            return this;
        }

        public SpringBootConfigurationBuilder managementHealthProbesEnabled(boolean managementHealthProbesEnabled) {
            this.managementHealthProbesEnabled = managementHealthProbesEnabled;
            return this;
        }

        public SpringBootConfiguration build() {
            return new SpringBootConfiguration(this.managementPort, this.serverPort, this.serverKeystore, this.managementKeystore, this.servletPath, this.serverContextPath, this.managementContextPath, this.actuatorBasePath, this.actuatorDefaultBasePath, this.managementHealthProbesEnabled);
        }

        public String toString() {
            return "SpringBootConfiguration.SpringBootConfigurationBuilder(managementPort=" + this.managementPort + ", serverPort=" + this.serverPort + ", serverKeystore=" + this.serverKeystore + ", managementKeystore=" + this.managementKeystore + ", servletPath=" + this.servletPath + ", serverContextPath=" + this.serverContextPath + ", managementContextPath=" + this.managementContextPath + ", actuatorBasePath=" + this.actuatorBasePath + ", actuatorDefaultBasePath=" + this.actuatorDefaultBasePath + ", managementHealthProbesEnabled=" + this.managementHealthProbesEnabled + ")";
        }
    }
}

