/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.eclipse.jkube.kit.common.util.EnvUtil;

public class Arguments
implements Serializable {
    private static final long serialVersionUID = -7896288279513401758L;
    private String shell;
    private List<String> exec;
    private List<String> execInlined;

    public void set(String shell) {
        this.setShell(shell);
    }

    public Arguments() {
        this(null, null, null);
    }

    public Arguments(String shell, List<String> exec, List<String> execInlined) {
        this.shell = shell;
        this.exec = exec;
        this.execInlined = Optional.ofNullable(execInlined).orElse(new ArrayList());
    }

    public List<String> getExec() {
        return Optional.ofNullable(this.exec).orElse(this.execInlined);
    }

    public void validate() {
        int valueSources = 0;
        if (this.shell != null) {
            ++valueSources;
        }
        if (this.exec != null && !this.exec.isEmpty()) {
            ++valueSources;
        }
        if (!this.execInlined.isEmpty()) {
            ++valueSources;
        }
        if (valueSources != 1) {
            throw new IllegalArgumentException("Argument conflict: either shell or args should be specified and only in one form.");
        }
    }

    public List<String> asStrings() {
        if (this.shell != null) {
            return Arrays.asList(EnvUtil.splitOnSpaceWithEscape(this.shell));
        }
        if (this.exec != null) {
            return Collections.unmodifiableList(this.exec);
        }
        return Collections.unmodifiableList(this.execInlined);
    }

    @Generated
    public static ArgumentsBuilder builder() {
        return new ArgumentsBuilder();
    }

    @Generated
    public String getShell() {
        return this.shell;
    }

    @Generated
    public List<String> getExecInlined() {
        return this.execInlined;
    }

    @Generated
    public void setShell(String shell) {
        this.shell = shell;
    }

    @Generated
    public void setExec(List<String> exec) {
        this.exec = exec;
    }

    @Generated
    public void setExecInlined(List<String> execInlined) {
        this.execInlined = execInlined;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Arguments)) {
            return false;
        }
        Arguments other = (Arguments)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$shell = this.getShell();
        String other$shell = other.getShell();
        if (this$shell == null ? other$shell != null : !this$shell.equals(other$shell)) {
            return false;
        }
        List<String> this$exec = this.getExec();
        List<String> other$exec = other.getExec();
        if (this$exec == null ? other$exec != null : !((Object)this$exec).equals(other$exec)) {
            return false;
        }
        List<String> this$execInlined = this.getExecInlined();
        List<String> other$execInlined = other.getExecInlined();
        return !(this$execInlined == null ? other$execInlined != null : !((Object)this$execInlined).equals(other$execInlined));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Arguments;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $shell = this.getShell();
        result = result * 59 + ($shell == null ? 43 : $shell.hashCode());
        List<String> $exec = this.getExec();
        result = result * 59 + ($exec == null ? 43 : ((Object)$exec).hashCode());
        List<String> $execInlined = this.getExecInlined();
        result = result * 59 + ($execInlined == null ? 43 : ((Object)$execInlined).hashCode());
        return result;
    }

    @Generated
    public static class ArgumentsBuilder {
        @Generated
        private String shell;
        @Generated
        private ArrayList<String> exec;
        @Generated
        private ArrayList<String> execInlined;

        @Generated
        ArgumentsBuilder() {
        }

        @Generated
        public ArgumentsBuilder shell(String shell) {
            this.shell = shell;
            return this;
        }

        @Generated
        public ArgumentsBuilder execArgument(String execArgument) {
            if (this.exec == null) {
                this.exec = new ArrayList();
            }
            this.exec.add(execArgument);
            return this;
        }

        @Generated
        public ArgumentsBuilder exec(Collection<? extends String> exec) {
            if (exec == null) {
                throw new NullPointerException("exec cannot be null");
            }
            if (this.exec == null) {
                this.exec = new ArrayList();
            }
            this.exec.addAll(exec);
            return this;
        }

        @Generated
        public ArgumentsBuilder clearExec() {
            if (this.exec != null) {
                this.exec.clear();
            }
            return this;
        }

        @Generated
        public ArgumentsBuilder execInlinedArgument(String execInlinedArgument) {
            if (this.execInlined == null) {
                this.execInlined = new ArrayList();
            }
            this.execInlined.add(execInlinedArgument);
            return this;
        }

        @Generated
        public ArgumentsBuilder execInlined(Collection<? extends String> execInlined) {
            if (execInlined == null) {
                throw new NullPointerException("execInlined cannot be null");
            }
            if (this.execInlined == null) {
                this.execInlined = new ArrayList();
            }
            this.execInlined.addAll(execInlined);
            return this;
        }

        @Generated
        public ArgumentsBuilder clearExecInlined() {
            if (this.execInlined != null) {
                this.execInlined.clear();
            }
            return this;
        }

        @Generated
        public Arguments build() {
            List<String> execInlined;
            List<String> exec;
            switch (this.exec == null ? 0 : this.exec.size()) {
                case 0: {
                    exec = Collections.emptyList();
                    break;
                }
                case 1: {
                    exec = Collections.singletonList(this.exec.get(0));
                    break;
                }
                default: {
                    exec = Collections.unmodifiableList(new ArrayList<String>(this.exec));
                }
            }
            switch (this.execInlined == null ? 0 : this.execInlined.size()) {
                case 0: {
                    execInlined = Collections.emptyList();
                    break;
                }
                case 1: {
                    execInlined = Collections.singletonList(this.execInlined.get(0));
                    break;
                }
                default: {
                    execInlined = Collections.unmodifiableList(new ArrayList<String>(this.execInlined));
                }
            }
            return new Arguments(this.shell, exec, execInlined);
        }

        @Generated
        public String toString() {
            return "Arguments.ArgumentsBuilder(shell=" + this.shell + ", exec=" + this.exec + ", execInlined=" + this.execInlined + ")";
        }
    }
}

