/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common;

import java.io.PrintStream;

public interface KitLogger {
    public void debug(String var1, Object ... var2);

    public void info(String var1, Object ... var2);

    default public void verbose(String format, Object ... params) {
        if (this.isVerboseEnabled()) {
            this.info(format, params);
        }
    }

    public void warn(String var1, Object ... var2);

    public void error(String var1, Object ... var2);

    public boolean isDebugEnabled();

    default public boolean isVerboseEnabled() {
        return false;
    }

    default public void progressStart() {
    }

    default public void progressUpdate(String layerId, String status, String progressMessage) {
    }

    default public void progressFinished() {
    }

    public static enum LogVerboseCategory {
        BUILD("build"),
        API("api");

        private final String category;

        private LogVerboseCategory(String category) {
            this.category = category;
        }

        public String getValue() {
            return this.category;
        }
    }

    public static class SilentLogger
    implements KitLogger {
        @Override
        public void debug(String format, Object ... params) {
        }

        @Override
        public void info(String format, Object ... params) {
        }

        @Override
        public void warn(String format, Object ... params) {
        }

        @Override
        public void error(String format, Object ... params) {
        }

        @Override
        public boolean isDebugEnabled() {
            return false;
        }
    }

    public static class StdoutLogger
    extends PrintStreamLogger {
        public StdoutLogger() {
            super(System.out);
        }
    }

    public static class PrintStreamLogger
    implements KitLogger {
        private final PrintStream out;

        public PrintStreamLogger(PrintStream out) {
            this.out = out;
        }

        @Override
        public void debug(String format, Object ... params) {
            this.out.printf("[DEBUG] " + format + "%n", params);
        }

        @Override
        public void info(String format, Object ... params) {
            this.out.printf("[INFO] " + format + "%n", params);
        }

        @Override
        public void warn(String format, Object ... params) {
            this.out.printf("[WARN] " + format + "%n", params);
        }

        @Override
        public void error(String format, Object ... params) {
            this.out.printf("[ERROR] " + format + "%n", params);
        }

        @Override
        public boolean isDebugEnabled() {
            return true;
        }
    }
}

