/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.IoUtil;

public class FileUtil {
    private FileUtil() {
    }

    public static File createTempDirectory() {
        try {
            return Files.createTempDirectory("jkube", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static File getRelativePath(File baseDir, File file) {
        Path baseDirPath = Paths.get(baseDir.getAbsolutePath(), new String[0]);
        Path filePath = Paths.get(file.getAbsolutePath(), new String[0]);
        return baseDirPath.relativize(filePath).toFile();
    }

    public static String stripPrefix(String text, String prefix) {
        if (text.startsWith(prefix)) {
            return text.substring(prefix.length());
        }
        return text;
    }

    public static String stripPostfix(String text, String postfix) {
        if (text.endsWith(postfix)) {
            return text.substring(0, text.length() - postfix.length());
        }
        return text;
    }

    public static String getAbsolutePath(String fileName) {
        return Paths.get(fileName, new String[0]).toAbsolutePath().toString();
    }

    public static String getAbsolutePath(URL url) {
        try {
            return url != null ? Paths.get(url.toURI()).toAbsolutePath().toString() : null;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static void downloadRemotes(File outputDirectory, List<String> remotes, KitLogger log) {
        if (!outputDirectory.exists()) {
            try {
                Files.createDirectories(outputDirectory.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        remotes.stream().map(remote -> {
            try {
                return new URL((String)remote);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }).forEach(url -> {
            try {
                IoUtil.download(log, url, new File(outputDirectory, FileUtil.getOutputName(url)));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        });
    }

    private static String getOutputName(URL url) {
        String path = url.getPath();
        int slashIndex = path.lastIndexOf(47);
        if (slashIndex >= 0) {
            return path.substring(slashIndex + 1);
        }
        throw new IllegalArgumentException(String.format("URL %s should contain a name file to be downloaded.", url));
    }

    public static void cleanDirectory(File directoryFile) throws IOException {
        Path directory = Paths.get(directoryFile.getAbsolutePath(), new String[0]);
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static String getRelativeFilePath(String oldFilePath, String newFilePath) {
        if (StringUtils.isEmpty((CharSequence)oldFilePath) || StringUtils.isEmpty((CharSequence)newFilePath)) {
            return "";
        }
        Path oldPath = new File(oldFilePath).toPath();
        Path newPath = new File(newFilePath).toPath();
        if (!Objects.equals(oldPath.getRoot(), newPath.getRoot())) {
            return null;
        }
        StringBuilder relativeFilePath = new StringBuilder();
        relativeFilePath.append(oldPath.relativize(newPath));
        if (newFilePath.endsWith(File.separator)) {
            relativeFilePath.append(File.separator);
        }
        return relativeFilePath.toString();
    }

    public static void copy(File sourceFile, File targetFile) throws IOException {
        FileUtil.copy(Paths.get(sourceFile.getAbsolutePath(), new String[0]), Paths.get(targetFile.getAbsolutePath(), new String[0]));
    }

    public static void copy(Path sourcePath, Path targetPath) throws IOException {
        Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
    }

    public static void copyDirectoryIfNotExists(File sourceDir, File targetDir) throws IOException {
        if (targetDir.exists() && targetDir.isDirectory() && !FileUtil.isDirEmpty(targetDir.toPath())) {
            return;
        }
        Path sourcePath = sourceDir.toPath();
        try (Stream<Path> sourceTree = Files.walk(sourcePath, new FileVisitOption[0]);){
            for (Path source : sourceTree.collect(Collectors.toList())) {
                Path target = targetDir.toPath().resolve(sourcePath.relativize(source));
                FileUtils.forceMkdir((File)target.toFile());
                Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    private static boolean isDirEmpty(Path directory) throws IOException {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(directory);){
            boolean bl = !dirStream.iterator().hasNext();
            return bl;
        }
    }

    public static String trimWildcardCharactersFromPath(String filePath) {
        if (!filePath.endsWith("*")) {
            return filePath;
        }
        int charIndex = filePath.length() - 1;
        while (filePath.charAt(charIndex) == '*') {
            --charIndex;
        }
        return filePath.substring(0, charIndex);
    }

    public static List<File> listFilesAndDirsRecursivelyInDirectory(File directory) {
        return FileUtils.listFilesAndDirs((File)directory, (IOFileFilter)new RegexFileFilter("^(.*?)"), (IOFileFilter)DirectoryFileFilter.DIRECTORY).stream().filter(f -> !f.equals(directory)).collect(Collectors.toList());
    }

    public static void createDirectory(File directory) throws IOException {
        FileUtils.forceMkdir((File)directory);
        if (!directory.exists()) {
            throw new IOException("Failed to create directory: " + directory.getAbsolutePath());
        }
    }
}

