/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.RegistryConfig;
import org.eclipse.jkube.kit.common.access.ClusterConfiguration;

public class JKubeConfiguration
implements Serializable {
    private static final long serialVersionUID = 7459084747241070651L;
    private JavaProject project;
    private ClusterConfiguration clusterConfiguration;
    private String sourceDirectory;
    private String outputDirectory;
    private Map<String, String> buildArgs;
    private RegistryConfig pullRegistryConfig;
    private RegistryConfig pushRegistryConfig;
    private List<JavaProject> reactorProjects;

    public File getBasedir() {
        return this.project.getBaseDirectory();
    }

    public Properties getProperties() {
        return this.project.getProperties();
    }

    public File inOutputDir(String path) {
        return this.inDir(this.getOutputDirectory(), path);
    }

    public File inSourceDir(String path) {
        return this.inDir(this.getSourceDirectory(), path);
    }

    public File inDir(String dir, String path) {
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        File absoluteSourceDir = new File(this.getBasedir(), dir);
        return new File(absoluteSourceDir, path);
    }

    @Generated
    public static JKubeConfigurationBuilder builder() {
        return new JKubeConfigurationBuilder();
    }

    @Generated
    public JKubeConfigurationBuilder toBuilder() {
        return new JKubeConfigurationBuilder().project(this.project).clusterConfiguration(this.clusterConfiguration).sourceDirectory(this.sourceDirectory).outputDirectory(this.outputDirectory).buildArgs(this.buildArgs).pullRegistryConfig(this.pullRegistryConfig).pushRegistryConfig(this.pushRegistryConfig).reactorProjects(this.reactorProjects);
    }

    @Generated
    public JKubeConfiguration(JavaProject project, ClusterConfiguration clusterConfiguration, String sourceDirectory, String outputDirectory, Map<String, String> buildArgs, RegistryConfig pullRegistryConfig, RegistryConfig pushRegistryConfig, List<JavaProject> reactorProjects) {
        this.project = project;
        this.clusterConfiguration = clusterConfiguration;
        this.sourceDirectory = sourceDirectory;
        this.outputDirectory = outputDirectory;
        this.buildArgs = buildArgs;
        this.pullRegistryConfig = pullRegistryConfig;
        this.pushRegistryConfig = pushRegistryConfig;
        this.reactorProjects = reactorProjects;
    }

    @Generated
    public JKubeConfiguration() {
    }

    @Generated
    public JavaProject getProject() {
        return this.project;
    }

    @Generated
    public ClusterConfiguration getClusterConfiguration() {
        return this.clusterConfiguration;
    }

    @Generated
    public String getSourceDirectory() {
        return this.sourceDirectory;
    }

    @Generated
    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    @Generated
    public Map<String, String> getBuildArgs() {
        return this.buildArgs;
    }

    @Generated
    public RegistryConfig getPullRegistryConfig() {
        return this.pullRegistryConfig;
    }

    @Generated
    public RegistryConfig getPushRegistryConfig() {
        return this.pushRegistryConfig;
    }

    @Generated
    public List<JavaProject> getReactorProjects() {
        return this.reactorProjects;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JKubeConfiguration)) {
            return false;
        }
        JKubeConfiguration other = (JKubeConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JavaProject this$project = this.getProject();
        JavaProject other$project = other.getProject();
        if (this$project == null ? other$project != null : !((Object)this$project).equals(other$project)) {
            return false;
        }
        ClusterConfiguration this$clusterConfiguration = this.getClusterConfiguration();
        ClusterConfiguration other$clusterConfiguration = other.getClusterConfiguration();
        if (this$clusterConfiguration == null ? other$clusterConfiguration != null : !((Object)this$clusterConfiguration).equals(other$clusterConfiguration)) {
            return false;
        }
        String this$sourceDirectory = this.getSourceDirectory();
        String other$sourceDirectory = other.getSourceDirectory();
        if (this$sourceDirectory == null ? other$sourceDirectory != null : !this$sourceDirectory.equals(other$sourceDirectory)) {
            return false;
        }
        String this$outputDirectory = this.getOutputDirectory();
        String other$outputDirectory = other.getOutputDirectory();
        if (this$outputDirectory == null ? other$outputDirectory != null : !this$outputDirectory.equals(other$outputDirectory)) {
            return false;
        }
        Map<String, String> this$buildArgs = this.getBuildArgs();
        Map<String, String> other$buildArgs = other.getBuildArgs();
        if (this$buildArgs == null ? other$buildArgs != null : !((Object)this$buildArgs).equals(other$buildArgs)) {
            return false;
        }
        RegistryConfig this$pullRegistryConfig = this.getPullRegistryConfig();
        RegistryConfig other$pullRegistryConfig = other.getPullRegistryConfig();
        if (this$pullRegistryConfig == null ? other$pullRegistryConfig != null : !((Object)this$pullRegistryConfig).equals(other$pullRegistryConfig)) {
            return false;
        }
        RegistryConfig this$pushRegistryConfig = this.getPushRegistryConfig();
        RegistryConfig other$pushRegistryConfig = other.getPushRegistryConfig();
        if (this$pushRegistryConfig == null ? other$pushRegistryConfig != null : !((Object)this$pushRegistryConfig).equals(other$pushRegistryConfig)) {
            return false;
        }
        List<JavaProject> this$reactorProjects = this.getReactorProjects();
        List<JavaProject> other$reactorProjects = other.getReactorProjects();
        return !(this$reactorProjects == null ? other$reactorProjects != null : !((Object)this$reactorProjects).equals(other$reactorProjects));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JKubeConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JavaProject $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : ((Object)$project).hashCode());
        ClusterConfiguration $clusterConfiguration = this.getClusterConfiguration();
        result = result * 59 + ($clusterConfiguration == null ? 43 : ((Object)$clusterConfiguration).hashCode());
        String $sourceDirectory = this.getSourceDirectory();
        result = result * 59 + ($sourceDirectory == null ? 43 : $sourceDirectory.hashCode());
        String $outputDirectory = this.getOutputDirectory();
        result = result * 59 + ($outputDirectory == null ? 43 : $outputDirectory.hashCode());
        Map<String, String> $buildArgs = this.getBuildArgs();
        result = result * 59 + ($buildArgs == null ? 43 : ((Object)$buildArgs).hashCode());
        RegistryConfig $pullRegistryConfig = this.getPullRegistryConfig();
        result = result * 59 + ($pullRegistryConfig == null ? 43 : ((Object)$pullRegistryConfig).hashCode());
        RegistryConfig $pushRegistryConfig = this.getPushRegistryConfig();
        result = result * 59 + ($pushRegistryConfig == null ? 43 : ((Object)$pushRegistryConfig).hashCode());
        List<JavaProject> $reactorProjects = this.getReactorProjects();
        result = result * 59 + ($reactorProjects == null ? 43 : ((Object)$reactorProjects).hashCode());
        return result;
    }

    @Generated
    public static class JKubeConfigurationBuilder {
        @Generated
        private JavaProject project;
        @Generated
        private ClusterConfiguration clusterConfiguration;
        @Generated
        private String sourceDirectory;
        @Generated
        private String outputDirectory;
        @Generated
        private Map<String, String> buildArgs;
        @Generated
        private RegistryConfig pullRegistryConfig;
        @Generated
        private RegistryConfig pushRegistryConfig;
        @Generated
        private List<JavaProject> reactorProjects;

        @Generated
        JKubeConfigurationBuilder() {
        }

        @Generated
        public JKubeConfigurationBuilder project(JavaProject project) {
            this.project = project;
            return this;
        }

        @Generated
        public JKubeConfigurationBuilder clusterConfiguration(ClusterConfiguration clusterConfiguration) {
            this.clusterConfiguration = clusterConfiguration;
            return this;
        }

        @Generated
        public JKubeConfigurationBuilder sourceDirectory(String sourceDirectory) {
            this.sourceDirectory = sourceDirectory;
            return this;
        }

        @Generated
        public JKubeConfigurationBuilder outputDirectory(String outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        @Generated
        public JKubeConfigurationBuilder buildArgs(Map<String, String> buildArgs) {
            this.buildArgs = buildArgs;
            return this;
        }

        @Generated
        public JKubeConfigurationBuilder pullRegistryConfig(RegistryConfig pullRegistryConfig) {
            this.pullRegistryConfig = pullRegistryConfig;
            return this;
        }

        @Generated
        public JKubeConfigurationBuilder pushRegistryConfig(RegistryConfig pushRegistryConfig) {
            this.pushRegistryConfig = pushRegistryConfig;
            return this;
        }

        @Generated
        public JKubeConfigurationBuilder reactorProjects(List<JavaProject> reactorProjects) {
            this.reactorProjects = reactorProjects;
            return this;
        }

        @Generated
        public JKubeConfiguration build() {
            return new JKubeConfiguration(this.project, this.clusterConfiguration, this.sourceDirectory, this.outputDirectory, this.buildArgs, this.pullRegistryConfig, this.pushRegistryConfig, this.reactorProjects);
        }

        @Generated
        public String toString() {
            return "JKubeConfiguration.JKubeConfigurationBuilder(project=" + this.project + ", clusterConfiguration=" + this.clusterConfiguration + ", sourceDirectory=" + this.sourceDirectory + ", outputDirectory=" + this.outputDirectory + ", buildArgs=" + this.buildArgs + ", pullRegistryConfig=" + this.pullRegistryConfig + ", pushRegistryConfig=" + this.pushRegistryConfig + ", reactorProjects=" + this.reactorProjects + ")";
        }
    }
}

