/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common;

import java.io.File;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.eclipse.jkube.kit.common.Dependency;
import org.eclipse.jkube.kit.common.Maintainer;
import org.eclipse.jkube.kit.common.Plugin;

public class JavaProject
implements Serializable {
    private static final long serialVersionUID = 6438404976521622633L;
    private String name;
    private String groupId;
    private String artifactId;
    private String version;
    private File outputDirectory;
    private File baseDirectory;
    private File buildDirectory;
    private File buildPackageDirectory;
    private Properties properties;
    private List<String> compileClassPathElements;
    private List<Dependency> dependencies;
    private List<Dependency> dependenciesWithTransitive;
    private List<Plugin> plugins;
    private List<String> gradlePlugins;
    private String site;
    private String description;
    private String organizationName;
    private String documentationUrl;
    private LocalDate buildDate;
    private String buildFinalName;
    private File artifact;
    private String packaging;
    private String issueManagementSystem;
    private String issueManagementUrl;
    private String url;
    private String scmUrl;
    private String scmTag;
    private List<Maintainer> maintainers;

    public boolean isSnapshot() {
        return this.version != null && this.version.toUpperCase(Locale.ROOT).endsWith("-SNAPSHOT");
    }

    public JavaProject(String name, String groupId, String artifactId, String version, File outputDirectory, File baseDirectory, File buildDirectory, File buildPackageDirectory, Properties properties, List<String> compileClassPathElements, List<Dependency> dependencies, List<Dependency> dependenciesWithTransitive, List<Plugin> plugins, List<String> gradlePlugins, String site, String description, String organizationName, String documentationUrl, LocalDate buildDate, String buildFinalName, File artifact, String packaging, String issueManagementSystem, String issueManagementUrl, String url, String scmUrl, String scmTag, List<Maintainer> maintainers) {
        this.name = name;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.outputDirectory = outputDirectory;
        this.baseDirectory = baseDirectory;
        this.buildDirectory = buildDirectory;
        this.properties = Optional.ofNullable(properties).orElse(new Properties());
        this.compileClassPathElements = compileClassPathElements;
        this.dependencies = dependencies;
        this.dependenciesWithTransitive = dependenciesWithTransitive;
        this.plugins = plugins;
        this.gradlePlugins = gradlePlugins;
        this.site = site;
        this.description = description;
        this.organizationName = organizationName;
        this.documentationUrl = documentationUrl;
        this.buildDate = Optional.ofNullable(buildDate).orElse(LocalDate.now());
        this.buildFinalName = buildFinalName;
        this.artifact = artifact;
        this.packaging = packaging;
        this.issueManagementSystem = issueManagementSystem;
        this.issueManagementUrl = issueManagementUrl;
        this.url = url;
        this.scmUrl = scmUrl;
        this.scmTag = scmTag;
        this.buildPackageDirectory = buildPackageDirectory;
        this.maintainers = maintainers;
    }

    @Generated
    public static JavaProjectBuilder builder() {
        return new JavaProjectBuilder();
    }

    @Generated
    public JavaProjectBuilder toBuilder() {
        JavaProjectBuilder builder = new JavaProjectBuilder().name(this.name).groupId(this.groupId).artifactId(this.artifactId).version(this.version).outputDirectory(this.outputDirectory).baseDirectory(this.baseDirectory).buildDirectory(this.buildDirectory).buildPackageDirectory(this.buildPackageDirectory).properties(this.properties).dependenciesWithTransitive(this.dependenciesWithTransitive).site(this.site).description(this.description).organizationName(this.organizationName).documentationUrl(this.documentationUrl).buildDate(this.buildDate).buildFinalName(this.buildFinalName).artifact(this.artifact).packaging(this.packaging).issueManagementSystem(this.issueManagementSystem).issueManagementUrl(this.issueManagementUrl).url(this.url).scmUrl(this.scmUrl).scmTag(this.scmTag);
        if (this.compileClassPathElements != null) {
            builder.compileClassPathElements(this.compileClassPathElements);
        }
        if (this.dependencies != null) {
            builder.dependencies(this.dependencies);
        }
        if (this.plugins != null) {
            builder.plugins(this.plugins);
        }
        if (this.gradlePlugins != null) {
            builder.gradlePlugins(this.gradlePlugins);
        }
        if (this.maintainers != null) {
            builder.maintainers(this.maintainers);
        }
        return builder;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Generated
    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    @Generated
    public File getBuildDirectory() {
        return this.buildDirectory;
    }

    @Generated
    public File getBuildPackageDirectory() {
        return this.buildPackageDirectory;
    }

    @Generated
    public Properties getProperties() {
        return this.properties;
    }

    @Generated
    public List<String> getCompileClassPathElements() {
        return this.compileClassPathElements;
    }

    @Generated
    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    @Generated
    public List<Dependency> getDependenciesWithTransitive() {
        return this.dependenciesWithTransitive;
    }

    @Generated
    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    @Generated
    public List<String> getGradlePlugins() {
        return this.gradlePlugins;
    }

    @Generated
    public String getSite() {
        return this.site;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getOrganizationName() {
        return this.organizationName;
    }

    @Generated
    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    @Generated
    public LocalDate getBuildDate() {
        return this.buildDate;
    }

    @Generated
    public String getBuildFinalName() {
        return this.buildFinalName;
    }

    @Generated
    public File getArtifact() {
        return this.artifact;
    }

    @Generated
    public String getPackaging() {
        return this.packaging;
    }

    @Generated
    public String getIssueManagementSystem() {
        return this.issueManagementSystem;
    }

    @Generated
    public String getIssueManagementUrl() {
        return this.issueManagementUrl;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getScmUrl() {
        return this.scmUrl;
    }

    @Generated
    public String getScmTag() {
        return this.scmTag;
    }

    @Generated
    public List<Maintainer> getMaintainers() {
        return this.maintainers;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Generated
    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Generated
    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    @Generated
    public void setBuildDirectory(File buildDirectory) {
        this.buildDirectory = buildDirectory;
    }

    @Generated
    public void setBuildPackageDirectory(File buildPackageDirectory) {
        this.buildPackageDirectory = buildPackageDirectory;
    }

    @Generated
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Generated
    public void setCompileClassPathElements(List<String> compileClassPathElements) {
        this.compileClassPathElements = compileClassPathElements;
    }

    @Generated
    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    @Generated
    public void setDependenciesWithTransitive(List<Dependency> dependenciesWithTransitive) {
        this.dependenciesWithTransitive = dependenciesWithTransitive;
    }

    @Generated
    public void setPlugins(List<Plugin> plugins) {
        this.plugins = plugins;
    }

    @Generated
    public void setGradlePlugins(List<String> gradlePlugins) {
        this.gradlePlugins = gradlePlugins;
    }

    @Generated
    public void setSite(String site) {
        this.site = site;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    @Generated
    public void setDocumentationUrl(String documentationUrl) {
        this.documentationUrl = documentationUrl;
    }

    @Generated
    public void setBuildDate(LocalDate buildDate) {
        this.buildDate = buildDate;
    }

    @Generated
    public void setBuildFinalName(String buildFinalName) {
        this.buildFinalName = buildFinalName;
    }

    @Generated
    public void setArtifact(File artifact) {
        this.artifact = artifact;
    }

    @Generated
    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    @Generated
    public void setIssueManagementSystem(String issueManagementSystem) {
        this.issueManagementSystem = issueManagementSystem;
    }

    @Generated
    public void setIssueManagementUrl(String issueManagementUrl) {
        this.issueManagementUrl = issueManagementUrl;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setScmUrl(String scmUrl) {
        this.scmUrl = scmUrl;
    }

    @Generated
    public void setScmTag(String scmTag) {
        this.scmTag = scmTag;
    }

    @Generated
    public void setMaintainers(List<Maintainer> maintainers) {
        this.maintainers = maintainers;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaProject)) {
            return false;
        }
        JavaProject other = (JavaProject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        File this$outputDirectory = this.getOutputDirectory();
        File other$outputDirectory = other.getOutputDirectory();
        if (this$outputDirectory == null ? other$outputDirectory != null : !((Object)this$outputDirectory).equals(other$outputDirectory)) {
            return false;
        }
        File this$baseDirectory = this.getBaseDirectory();
        File other$baseDirectory = other.getBaseDirectory();
        if (this$baseDirectory == null ? other$baseDirectory != null : !((Object)this$baseDirectory).equals(other$baseDirectory)) {
            return false;
        }
        File this$buildDirectory = this.getBuildDirectory();
        File other$buildDirectory = other.getBuildDirectory();
        if (this$buildDirectory == null ? other$buildDirectory != null : !((Object)this$buildDirectory).equals(other$buildDirectory)) {
            return false;
        }
        File this$buildPackageDirectory = this.getBuildPackageDirectory();
        File other$buildPackageDirectory = other.getBuildPackageDirectory();
        if (this$buildPackageDirectory == null ? other$buildPackageDirectory != null : !((Object)this$buildPackageDirectory).equals(other$buildPackageDirectory)) {
            return false;
        }
        Properties this$properties = this.getProperties();
        Properties other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        List<String> this$compileClassPathElements = this.getCompileClassPathElements();
        List<String> other$compileClassPathElements = other.getCompileClassPathElements();
        if (this$compileClassPathElements == null ? other$compileClassPathElements != null : !((Object)this$compileClassPathElements).equals(other$compileClassPathElements)) {
            return false;
        }
        List<Dependency> this$dependencies = this.getDependencies();
        List<Dependency> other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
            return false;
        }
        List<Dependency> this$dependenciesWithTransitive = this.getDependenciesWithTransitive();
        List<Dependency> other$dependenciesWithTransitive = other.getDependenciesWithTransitive();
        if (this$dependenciesWithTransitive == null ? other$dependenciesWithTransitive != null : !((Object)this$dependenciesWithTransitive).equals(other$dependenciesWithTransitive)) {
            return false;
        }
        List<Plugin> this$plugins = this.getPlugins();
        List<Plugin> other$plugins = other.getPlugins();
        if (this$plugins == null ? other$plugins != null : !((Object)this$plugins).equals(other$plugins)) {
            return false;
        }
        List<String> this$gradlePlugins = this.getGradlePlugins();
        List<String> other$gradlePlugins = other.getGradlePlugins();
        if (this$gradlePlugins == null ? other$gradlePlugins != null : !((Object)this$gradlePlugins).equals(other$gradlePlugins)) {
            return false;
        }
        String this$site = this.getSite();
        String other$site = other.getSite();
        if (this$site == null ? other$site != null : !this$site.equals(other$site)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$organizationName = this.getOrganizationName();
        String other$organizationName = other.getOrganizationName();
        if (this$organizationName == null ? other$organizationName != null : !this$organizationName.equals(other$organizationName)) {
            return false;
        }
        String this$documentationUrl = this.getDocumentationUrl();
        String other$documentationUrl = other.getDocumentationUrl();
        if (this$documentationUrl == null ? other$documentationUrl != null : !this$documentationUrl.equals(other$documentationUrl)) {
            return false;
        }
        LocalDate this$buildDate = this.getBuildDate();
        LocalDate other$buildDate = other.getBuildDate();
        if (this$buildDate == null ? other$buildDate != null : !((Object)this$buildDate).equals(other$buildDate)) {
            return false;
        }
        String this$buildFinalName = this.getBuildFinalName();
        String other$buildFinalName = other.getBuildFinalName();
        if (this$buildFinalName == null ? other$buildFinalName != null : !this$buildFinalName.equals(other$buildFinalName)) {
            return false;
        }
        File this$artifact = this.getArtifact();
        File other$artifact = other.getArtifact();
        if (this$artifact == null ? other$artifact != null : !((Object)this$artifact).equals(other$artifact)) {
            return false;
        }
        String this$packaging = this.getPackaging();
        String other$packaging = other.getPackaging();
        if (this$packaging == null ? other$packaging != null : !this$packaging.equals(other$packaging)) {
            return false;
        }
        String this$issueManagementSystem = this.getIssueManagementSystem();
        String other$issueManagementSystem = other.getIssueManagementSystem();
        if (this$issueManagementSystem == null ? other$issueManagementSystem != null : !this$issueManagementSystem.equals(other$issueManagementSystem)) {
            return false;
        }
        String this$issueManagementUrl = this.getIssueManagementUrl();
        String other$issueManagementUrl = other.getIssueManagementUrl();
        if (this$issueManagementUrl == null ? other$issueManagementUrl != null : !this$issueManagementUrl.equals(other$issueManagementUrl)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$scmUrl = this.getScmUrl();
        String other$scmUrl = other.getScmUrl();
        if (this$scmUrl == null ? other$scmUrl != null : !this$scmUrl.equals(other$scmUrl)) {
            return false;
        }
        String this$scmTag = this.getScmTag();
        String other$scmTag = other.getScmTag();
        if (this$scmTag == null ? other$scmTag != null : !this$scmTag.equals(other$scmTag)) {
            return false;
        }
        List<Maintainer> this$maintainers = this.getMaintainers();
        List<Maintainer> other$maintainers = other.getMaintainers();
        return !(this$maintainers == null ? other$maintainers != null : !((Object)this$maintainers).equals(other$maintainers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JavaProject;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        File $outputDirectory = this.getOutputDirectory();
        result = result * 59 + ($outputDirectory == null ? 43 : ((Object)$outputDirectory).hashCode());
        File $baseDirectory = this.getBaseDirectory();
        result = result * 59 + ($baseDirectory == null ? 43 : ((Object)$baseDirectory).hashCode());
        File $buildDirectory = this.getBuildDirectory();
        result = result * 59 + ($buildDirectory == null ? 43 : ((Object)$buildDirectory).hashCode());
        File $buildPackageDirectory = this.getBuildPackageDirectory();
        result = result * 59 + ($buildPackageDirectory == null ? 43 : ((Object)$buildPackageDirectory).hashCode());
        Properties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        List<String> $compileClassPathElements = this.getCompileClassPathElements();
        result = result * 59 + ($compileClassPathElements == null ? 43 : ((Object)$compileClassPathElements).hashCode());
        List<Dependency> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        List<Dependency> $dependenciesWithTransitive = this.getDependenciesWithTransitive();
        result = result * 59 + ($dependenciesWithTransitive == null ? 43 : ((Object)$dependenciesWithTransitive).hashCode());
        List<Plugin> $plugins = this.getPlugins();
        result = result * 59 + ($plugins == null ? 43 : ((Object)$plugins).hashCode());
        List<String> $gradlePlugins = this.getGradlePlugins();
        result = result * 59 + ($gradlePlugins == null ? 43 : ((Object)$gradlePlugins).hashCode());
        String $site = this.getSite();
        result = result * 59 + ($site == null ? 43 : $site.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $organizationName = this.getOrganizationName();
        result = result * 59 + ($organizationName == null ? 43 : $organizationName.hashCode());
        String $documentationUrl = this.getDocumentationUrl();
        result = result * 59 + ($documentationUrl == null ? 43 : $documentationUrl.hashCode());
        LocalDate $buildDate = this.getBuildDate();
        result = result * 59 + ($buildDate == null ? 43 : ((Object)$buildDate).hashCode());
        String $buildFinalName = this.getBuildFinalName();
        result = result * 59 + ($buildFinalName == null ? 43 : $buildFinalName.hashCode());
        File $artifact = this.getArtifact();
        result = result * 59 + ($artifact == null ? 43 : ((Object)$artifact).hashCode());
        String $packaging = this.getPackaging();
        result = result * 59 + ($packaging == null ? 43 : $packaging.hashCode());
        String $issueManagementSystem = this.getIssueManagementSystem();
        result = result * 59 + ($issueManagementSystem == null ? 43 : $issueManagementSystem.hashCode());
        String $issueManagementUrl = this.getIssueManagementUrl();
        result = result * 59 + ($issueManagementUrl == null ? 43 : $issueManagementUrl.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $scmUrl = this.getScmUrl();
        result = result * 59 + ($scmUrl == null ? 43 : $scmUrl.hashCode());
        String $scmTag = this.getScmTag();
        result = result * 59 + ($scmTag == null ? 43 : $scmTag.hashCode());
        List<Maintainer> $maintainers = this.getMaintainers();
        result = result * 59 + ($maintainers == null ? 43 : ((Object)$maintainers).hashCode());
        return result;
    }

    @Generated
    public static class JavaProjectBuilder {
        @Generated
        private String name;
        @Generated
        private String groupId;
        @Generated
        private String artifactId;
        @Generated
        private String version;
        @Generated
        private File outputDirectory;
        @Generated
        private File baseDirectory;
        @Generated
        private File buildDirectory;
        @Generated
        private File buildPackageDirectory;
        @Generated
        private Properties properties;
        @Generated
        private ArrayList<String> compileClassPathElements;
        @Generated
        private ArrayList<Dependency> dependencies;
        @Generated
        private List<Dependency> dependenciesWithTransitive;
        @Generated
        private ArrayList<Plugin> plugins;
        @Generated
        private ArrayList<String> gradlePlugins;
        @Generated
        private String site;
        @Generated
        private String description;
        @Generated
        private String organizationName;
        @Generated
        private String documentationUrl;
        @Generated
        private LocalDate buildDate;
        @Generated
        private String buildFinalName;
        @Generated
        private File artifact;
        @Generated
        private String packaging;
        @Generated
        private String issueManagementSystem;
        @Generated
        private String issueManagementUrl;
        @Generated
        private String url;
        @Generated
        private String scmUrl;
        @Generated
        private String scmTag;
        @Generated
        private ArrayList<Maintainer> maintainers;

        @Generated
        JavaProjectBuilder() {
        }

        @Generated
        public JavaProjectBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public JavaProjectBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Generated
        public JavaProjectBuilder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Generated
        public JavaProjectBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public JavaProjectBuilder outputDirectory(File outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        @Generated
        public JavaProjectBuilder baseDirectory(File baseDirectory) {
            this.baseDirectory = baseDirectory;
            return this;
        }

        @Generated
        public JavaProjectBuilder buildDirectory(File buildDirectory) {
            this.buildDirectory = buildDirectory;
            return this;
        }

        @Generated
        public JavaProjectBuilder buildPackageDirectory(File buildPackageDirectory) {
            this.buildPackageDirectory = buildPackageDirectory;
            return this;
        }

        @Generated
        public JavaProjectBuilder properties(Properties properties) {
            this.properties = properties;
            return this;
        }

        @Generated
        public JavaProjectBuilder compileClassPathElement(String compileClassPathElement) {
            if (this.compileClassPathElements == null) {
                this.compileClassPathElements = new ArrayList();
            }
            this.compileClassPathElements.add(compileClassPathElement);
            return this;
        }

        @Generated
        public JavaProjectBuilder compileClassPathElements(Collection<? extends String> compileClassPathElements) {
            if (compileClassPathElements == null) {
                throw new NullPointerException("compileClassPathElements cannot be null");
            }
            if (this.compileClassPathElements == null) {
                this.compileClassPathElements = new ArrayList();
            }
            this.compileClassPathElements.addAll(compileClassPathElements);
            return this;
        }

        @Generated
        public JavaProjectBuilder clearCompileClassPathElements() {
            if (this.compileClassPathElements != null) {
                this.compileClassPathElements.clear();
            }
            return this;
        }

        @Generated
        public JavaProjectBuilder dependency(Dependency dependency) {
            if (this.dependencies == null) {
                this.dependencies = new ArrayList();
            }
            this.dependencies.add(dependency);
            return this;
        }

        @Generated
        public JavaProjectBuilder dependencies(Collection<? extends Dependency> dependencies) {
            if (dependencies == null) {
                throw new NullPointerException("dependencies cannot be null");
            }
            if (this.dependencies == null) {
                this.dependencies = new ArrayList();
            }
            this.dependencies.addAll(dependencies);
            return this;
        }

        @Generated
        public JavaProjectBuilder clearDependencies() {
            if (this.dependencies != null) {
                this.dependencies.clear();
            }
            return this;
        }

        @Generated
        public JavaProjectBuilder dependenciesWithTransitive(List<Dependency> dependenciesWithTransitive) {
            this.dependenciesWithTransitive = dependenciesWithTransitive;
            return this;
        }

        @Generated
        public JavaProjectBuilder plugin(Plugin plugin) {
            if (this.plugins == null) {
                this.plugins = new ArrayList();
            }
            this.plugins.add(plugin);
            return this;
        }

        @Generated
        public JavaProjectBuilder plugins(Collection<? extends Plugin> plugins) {
            if (plugins == null) {
                throw new NullPointerException("plugins cannot be null");
            }
            if (this.plugins == null) {
                this.plugins = new ArrayList();
            }
            this.plugins.addAll(plugins);
            return this;
        }

        @Generated
        public JavaProjectBuilder clearPlugins() {
            if (this.plugins != null) {
                this.plugins.clear();
            }
            return this;
        }

        @Generated
        public JavaProjectBuilder gradlePlugin(String gradlePlugin) {
            if (this.gradlePlugins == null) {
                this.gradlePlugins = new ArrayList();
            }
            this.gradlePlugins.add(gradlePlugin);
            return this;
        }

        @Generated
        public JavaProjectBuilder gradlePlugins(Collection<? extends String> gradlePlugins) {
            if (gradlePlugins == null) {
                throw new NullPointerException("gradlePlugins cannot be null");
            }
            if (this.gradlePlugins == null) {
                this.gradlePlugins = new ArrayList();
            }
            this.gradlePlugins.addAll(gradlePlugins);
            return this;
        }

        @Generated
        public JavaProjectBuilder clearGradlePlugins() {
            if (this.gradlePlugins != null) {
                this.gradlePlugins.clear();
            }
            return this;
        }

        @Generated
        public JavaProjectBuilder site(String site) {
            this.site = site;
            return this;
        }

        @Generated
        public JavaProjectBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public JavaProjectBuilder organizationName(String organizationName) {
            this.organizationName = organizationName;
            return this;
        }

        @Generated
        public JavaProjectBuilder documentationUrl(String documentationUrl) {
            this.documentationUrl = documentationUrl;
            return this;
        }

        @Generated
        public JavaProjectBuilder buildDate(LocalDate buildDate) {
            this.buildDate = buildDate;
            return this;
        }

        @Generated
        public JavaProjectBuilder buildFinalName(String buildFinalName) {
            this.buildFinalName = buildFinalName;
            return this;
        }

        @Generated
        public JavaProjectBuilder artifact(File artifact) {
            this.artifact = artifact;
            return this;
        }

        @Generated
        public JavaProjectBuilder packaging(String packaging) {
            this.packaging = packaging;
            return this;
        }

        @Generated
        public JavaProjectBuilder issueManagementSystem(String issueManagementSystem) {
            this.issueManagementSystem = issueManagementSystem;
            return this;
        }

        @Generated
        public JavaProjectBuilder issueManagementUrl(String issueManagementUrl) {
            this.issueManagementUrl = issueManagementUrl;
            return this;
        }

        @Generated
        public JavaProjectBuilder url(String url) {
            this.url = url;
            return this;
        }

        @Generated
        public JavaProjectBuilder scmUrl(String scmUrl) {
            this.scmUrl = scmUrl;
            return this;
        }

        @Generated
        public JavaProjectBuilder scmTag(String scmTag) {
            this.scmTag = scmTag;
            return this;
        }

        @Generated
        public JavaProjectBuilder maintainer(Maintainer maintainer) {
            if (this.maintainers == null) {
                this.maintainers = new ArrayList();
            }
            this.maintainers.add(maintainer);
            return this;
        }

        @Generated
        public JavaProjectBuilder maintainers(Collection<? extends Maintainer> maintainers) {
            if (maintainers == null) {
                throw new NullPointerException("maintainers cannot be null");
            }
            if (this.maintainers == null) {
                this.maintainers = new ArrayList();
            }
            this.maintainers.addAll(maintainers);
            return this;
        }

        @Generated
        public JavaProjectBuilder clearMaintainers() {
            if (this.maintainers != null) {
                this.maintainers.clear();
            }
            return this;
        }

        @Generated
        public JavaProject build() {
            List<Maintainer> maintainers;
            List<String> gradlePlugins;
            List<Plugin> plugins;
            List<Dependency> dependencies;
            List<String> compileClassPathElements;
            switch (this.compileClassPathElements == null ? 0 : this.compileClassPathElements.size()) {
                case 0: {
                    compileClassPathElements = Collections.emptyList();
                    break;
                }
                case 1: {
                    compileClassPathElements = Collections.singletonList(this.compileClassPathElements.get(0));
                    break;
                }
                default: {
                    compileClassPathElements = Collections.unmodifiableList(new ArrayList<String>(this.compileClassPathElements));
                }
            }
            switch (this.dependencies == null ? 0 : this.dependencies.size()) {
                case 0: {
                    dependencies = Collections.emptyList();
                    break;
                }
                case 1: {
                    dependencies = Collections.singletonList(this.dependencies.get(0));
                    break;
                }
                default: {
                    dependencies = Collections.unmodifiableList(new ArrayList<Dependency>(this.dependencies));
                }
            }
            switch (this.plugins == null ? 0 : this.plugins.size()) {
                case 0: {
                    plugins = Collections.emptyList();
                    break;
                }
                case 1: {
                    plugins = Collections.singletonList(this.plugins.get(0));
                    break;
                }
                default: {
                    plugins = Collections.unmodifiableList(new ArrayList<Plugin>(this.plugins));
                }
            }
            switch (this.gradlePlugins == null ? 0 : this.gradlePlugins.size()) {
                case 0: {
                    gradlePlugins = Collections.emptyList();
                    break;
                }
                case 1: {
                    gradlePlugins = Collections.singletonList(this.gradlePlugins.get(0));
                    break;
                }
                default: {
                    gradlePlugins = Collections.unmodifiableList(new ArrayList<String>(this.gradlePlugins));
                }
            }
            switch (this.maintainers == null ? 0 : this.maintainers.size()) {
                case 0: {
                    maintainers = Collections.emptyList();
                    break;
                }
                case 1: {
                    maintainers = Collections.singletonList(this.maintainers.get(0));
                    break;
                }
                default: {
                    maintainers = Collections.unmodifiableList(new ArrayList<Maintainer>(this.maintainers));
                }
            }
            return new JavaProject(this.name, this.groupId, this.artifactId, this.version, this.outputDirectory, this.baseDirectory, this.buildDirectory, this.buildPackageDirectory, this.properties, compileClassPathElements, dependencies, this.dependenciesWithTransitive, plugins, gradlePlugins, this.site, this.description, this.organizationName, this.documentationUrl, this.buildDate, this.buildFinalName, this.artifact, this.packaging, this.issueManagementSystem, this.issueManagementUrl, this.url, this.scmUrl, this.scmTag, maintainers);
        }

        @Generated
        public String toString() {
            return "JavaProject.JavaProjectBuilder(name=" + this.name + ", groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + ", outputDirectory=" + this.outputDirectory + ", baseDirectory=" + this.baseDirectory + ", buildDirectory=" + this.buildDirectory + ", buildPackageDirectory=" + this.buildPackageDirectory + ", properties=" + this.properties + ", compileClassPathElements=" + this.compileClassPathElements + ", dependencies=" + this.dependencies + ", dependenciesWithTransitive=" + this.dependenciesWithTransitive + ", plugins=" + this.plugins + ", gradlePlugins=" + this.gradlePlugins + ", site=" + this.site + ", description=" + this.description + ", organizationName=" + this.organizationName + ", documentationUrl=" + this.documentationUrl + ", buildDate=" + this.buildDate + ", buildFinalName=" + this.buildFinalName + ", artifact=" + this.artifact + ", packaging=" + this.packaging + ", issueManagementSystem=" + this.issueManagementSystem + ", issueManagementUrl=" + this.issueManagementUrl + ", url=" + this.url + ", scmUrl=" + this.scmUrl + ", scmTag=" + this.scmTag + ", maintainers=" + this.maintainers + ")";
        }
    }
}

