/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.URIish;

public class GitUtil {
    private GitUtil() {
    }

    public static Repository getGitRepository(File currentDir) throws IOException {
        File gitFolder = GitUtil.findGitFolder(currentDir);
        if (gitFolder == null) {
            return null;
        }
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        return ((FileRepositoryBuilder)((FileRepositoryBuilder)builder.readEnvironment()).setGitDir(gitFolder)).build();
    }

    public static File findGitFolder(File basedir) {
        File gitDir = new File(basedir, ".git");
        if (gitDir.exists() && gitDir.isDirectory()) {
            return gitDir;
        }
        File parent = basedir.getParentFile();
        if (parent != null) {
            return GitUtil.findGitFolder(parent);
        }
        return null;
    }

    public static String getGitCommitId(Repository repository) throws GitAPIException {
        if (repository != null) {
            return StreamSupport.stream(new Git(repository).log().call().spliterator(), false).map(AnyObjectId::getName).findFirst().orElse(null);
        }
        return null;
    }

    public static String sanitizeRemoteUrl(String remoteUrlStr) {
        if (StringUtils.isBlank((CharSequence)remoteUrlStr)) {
            return remoteUrlStr;
        }
        try {
            URIish uri = new URIish(remoteUrlStr);
            StringBuilder userInfo = new StringBuilder();
            if (StringUtils.isNotBlank((CharSequence)uri.getUser())) {
                userInfo.append(uri.getUser());
            }
            if (StringUtils.isNotBlank((CharSequence)uri.getPass())) {
                userInfo.append(":").append(uri.getPass());
            }
            if (userInfo.length() > 0) {
                remoteUrlStr = remoteUrlStr.replace(userInfo + "@", "");
            }
            return remoteUrlStr;
        }
        catch (URISyntaxException uRISyntaxException) {
            return remoteUrlStr;
        }
    }
}

