/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.archive.ArchiveDecompressor;

public class IoUtil {
    private static final Random RANDOM = new Random();
    private static final int PROGRESS_LENGTH = 50;

    private IoUtil() {
    }

    public static void download(KitLogger log, URL downloadUrl, File target) throws IOException {
        IoUtil.download(downloadUrl, response -> {
            try (OutputStream out = Files.newOutputStream(target.toPath(), new OpenOption[0]);
                 InputStream is = (InputStream)response.body();){
                int len;
                log.progressStart();
                int length = Integer.parseInt(response.headers("Content-Length").stream().findAny().orElse("-1"));
                byte[] buffer = new byte[8192];
                long readBytes = 0L;
                while (-1 != (len = is.read(buffer))) {
                    log.progressUpdate(target.getName(), "Downloading", IoUtil.getProgressBar(readBytes += (long)len, length));
                    out.write(buffer, 0, len);
                }
            }
            finally {
                log.progressFinished();
            }
        });
    }

    public static void downloadArchive(URL downloadUrl, File target) throws IOException {
        IoUtil.download(downloadUrl, response -> {
            try (InputStream is = (InputStream)response.body();){
                ArchiveDecompressor.extractArchive(is, target);
            }
        });
    }

    private static void download(URL downloadUrl, HttpResponseConsumer<InputStream> responseConsumer) throws IOException {
        try (HttpClient httpClient = HttpClientUtils.getHttpClientFactory().newBuilder(Config.empty()).build();){
            HttpResponse response = (HttpResponse)httpClient.sendAsync(httpClient.newHttpRequestBuilder().timeout(30L, TimeUnit.MINUTES).url(downloadUrl).build(), InputStream.class).get();
            if (!response.isSuccessful()) {
                throw new IOException("Got (" + response.code() + ") while downloading from URL " + downloadUrl);
            }
            responseConsumer.consume((HttpResponse<InputStream>)response);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IOException("Download interrupted", ex);
        }
        catch (ExecutionException e) {
            throw new IOException("Failed to download from URL " + downloadUrl, e);
        }
    }

    public static int getFreeRandomPort() {
        return IoUtil.getFreeRandomPort(49152, 65535, 100);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getFreeRandomPort(int min, int max, int attempts) {
        int i = 0;
        while (i < attempts) {
            int port = min + RANDOM.nextInt(max - min + 1);
            try (ServerSocket ignored = new ServerSocket(port);){
                int n = port;
                return n;
            }
            catch (Exception exception) {
                ++i;
            }
        }
        throw new IllegalStateException("Cannot find a free random port in the range [" + min + ", " + max + "] after " + attempts + " attempts");
    }

    public static String sanitizeFileName(String name) {
        if (name != null) {
            return name.replaceAll("[^A-Za-z0-9]+", "-");
        }
        return null;
    }

    private static String getProgressBar(long bytesRead, long length) {
        StringBuilder ret = new StringBuilder("[");
        if (length > -1L) {
            int bucketSize = (int)((double)length / 50.0 + 0.5);
            int index = (int)((double)bytesRead / (double)bucketSize + 0.5);
            for (int i = 0; i < 50; ++i) {
                ret.append(i < index ? "=" : (i == index ? ">" : " "));
            }
            ret.append(String.format("] %.2f MB/%.2f MB", Float.valueOf((float)bytesRead / 1048576.0f), Float.valueOf((float)length / 1048576.0f)));
        } else {
            int bucketSize = 204800;
            int index = (int)((double)bytesRead / (double)bucketSize + 0.5) % 50;
            for (int i = 0; i < 50; ++i) {
                ret.append(i == index ? "*" : " ");
            }
            ret.append("]");
        }
        return ret.toString();
    }

    @FunctionalInterface
    private static interface HttpResponseConsumer<T> {
        public void consume(HttpResponse<T> var1) throws IOException;
    }
}

