/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import io.fabric8.kubernetes.client.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.YamlUtil;

public class PropertiesUtil {
    public static final String JKUBE_INTERNAL_APP_CONFIG_FILE_LOCATION = "jkube.internal.application-config-file.path";

    private PropertiesUtil() {
    }

    public static Properties getPropertiesFromResource(URL resource) {
        Properties ret = new Properties();
        if (resource != null) {
            try (InputStream stream = resource.openStream();){
                ret.load(stream);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error while reading resource from URL " + resource, e);
            }
        }
        return ret;
    }

    public static Properties readProperties(Path properties) {
        Properties ret = new Properties();
        if (properties != null && properties.toFile().exists() && properties.toFile().isFile()) {
            try (InputStream stream = Files.newInputStream(properties, new OpenOption[0]);){
                ret.load(stream);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error while reading properties from file " + properties, e);
            }
        }
        return ret;
    }

    public static String getValueFromProperties(Properties properties, String ... keys) {
        for (String property : keys) {
            String value;
            if (!properties.containsKey(property) || !Utils.isNotNullOrEmpty((String)(value = properties.get(property).toString()))) continue;
            return value;
        }
        return null;
    }

    public static Map<String, String> toMap(Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry entry : Optional.ofNullable(properties).map(Hashtable::entrySet).orElse(Collections.emptySet())) {
            map.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return map;
    }

    public static Properties fromApplicationConfig(JavaProject javaProject, String[] appConfigSources) {
        URLClassLoader urlClassLoader = JKubeProjectUtil.getClassLoader(javaProject);
        for (String source : appConfigSources) {
            URL applicationConfigSource = urlClassLoader.findResource(source);
            Properties properties = source.endsWith(".properties") ? PropertiesUtil.getPropertiesFromResource(applicationConfigSource) : YamlUtil.getPropertiesFromYamlResource(applicationConfigSource);
            if (properties.isEmpty()) continue;
            properties.putAll(PropertiesUtil.toMap(javaProject.getProperties()));
            properties.put(JKUBE_INTERNAL_APP_CONFIG_FILE_LOCATION, applicationConfigSource);
            return properties;
        }
        return javaProject.getProperties();
    }
}

